/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.views;

import java.util.stream.Collectors;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.RequestWithPayload;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.views.AddApplicationRequest;
import org.sonarqube.ws.client.views.AddPortfolioRequest;
import org.sonarqube.ws.client.views.AddProjectBranchRequest;
import org.sonarqube.ws.client.views.AddProjectRequest;
import org.sonarqube.ws.client.views.ApplicationsRequest;
import org.sonarqube.ws.client.views.CreateRequest;
import org.sonarqube.ws.client.views.DeleteRequest;
import org.sonarqube.ws.client.views.MoveOptionsRequest;
import org.sonarqube.ws.client.views.MoveRequest;
import org.sonarqube.ws.client.views.PortfoliosRequest;
import org.sonarqube.ws.client.views.ProjectsRequest;
import org.sonarqube.ws.client.views.RefreshRequest;
import org.sonarqube.ws.client.views.RemoveApplicationRequest;
import org.sonarqube.ws.client.views.RemovePortfolioRequest;
import org.sonarqube.ws.client.views.RemoveProjectBranchRequest;
import org.sonarqube.ws.client.views.RemoveProjectRequest;
import org.sonarqube.ws.client.views.SearchRequest;
import org.sonarqube.ws.client.views.SetManualModeRequest;
import org.sonarqube.ws.client.views.SetNoneModeRequest;
import org.sonarqube.ws.client.views.SetRegexpModeRequest;
import org.sonarqube.ws.client.views.SetRemainingProjectsModeRequest;
import org.sonarqube.ws.client.views.SetTagsModeRequest;
import org.sonarqube.ws.client.views.ShowRequest;
import org.sonarqube.ws.client.views.UpdateRequest;

public class ViewsService
extends BaseService {
    public ViewsService(WsConnector wsConnector) {
        super(wsConnector, "api/views");
    }

    public void addApplication(AddApplicationRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("add_application")).setParam("application", request.getApplication())).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void addPortfolio(AddPortfolioRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("add_portfolio")).setParam("portfolio", request.getPortfolio())).setParam("reference", request.getReference())).setMediaType("application/json")).content();
    }

    public void addProject(AddProjectRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("add_project")).setParam("key", request.getKey())).setParam("project", request.getProject())).setMediaType("application/json")).content();
    }

    public void addProjectBranch(AddProjectBranchRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("add_project_branch")).setParam("branch", request.getBranch())).setParam("key", request.getKey())).setParam("project", request.getProject())).setMediaType("application/json")).content();
    }

    public String applications(ApplicationsRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("applications")).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void create(CreateRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("create")).setParam("description", request.getDescription())).setParam("key", request.getKey())).setParam("name", request.getName())).setParam("parent", request.getParent())).setParam("visibility", request.getVisibility())).setMediaType("application/json")).content();
    }

    public void delete(DeleteRequest request) {
        this.call(((RequestWithPayload)new PostRequest(this.path("delete")).setParam("key", request.getKey())).setMediaType("application/json")).content();
    }

    public String list() {
        return this.call(new GetRequest(this.path("list")).setMediaType("application/json")).content();
    }

    public void move(MoveRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("move")).setParam("destination", request.getDestination())).setParam("key", request.getKey())).setMediaType("application/json")).content();
    }

    public String moveOptions(MoveOptionsRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("move_options")).setParam("key", request.getKey())).setMediaType("application/json")).content();
    }

    public String portfolios(PortfoliosRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("portfolios")).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public String projects(ProjectsRequest request) {
        return this.call(((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("projects")).setParam("key", request.getKey())).setParam("p", request.getP())).setParam("ps", request.getPs())).setParam("query", request.getQuery())).setParam("selected", request.getSelected())).setMediaType("application/json")).content();
    }

    public void refresh(RefreshRequest request) {
        this.call(((RequestWithPayload)new PostRequest(this.path("refresh")).setParam("key", request.getKey())).setMediaType("application/json")).content();
    }

    public void removeApplication(RemoveApplicationRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("remove_application")).setParam("application", request.getApplication())).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void removePortfolio(RemovePortfolioRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("remove_portfolio")).setParam("portfolio", request.getPortfolio())).setParam("reference", request.getReference())).setMediaType("application/json")).content();
    }

    public void removeProject(RemoveProjectRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("remove_project")).setParam("key", request.getKey())).setParam("project", request.getProject())).setMediaType("application/json")).content();
    }

    public void removeProjectBranch(RemoveProjectBranchRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("remove_project_branch")).setParam("branch", request.getBranch())).setParam("key", request.getKey())).setParam("project", request.getProject())).setMediaType("application/json")).content();
    }

    public String search(SearchRequest request) {
        return this.call(((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("search")).setParam("onlyFavorites", request.getOnlyFavorites())).setParam("p", request.getP())).setParam("ps", request.getPs())).setParam("q", request.getQ())).setParam("qualifiers", request.getQualifiers())).setMediaType("application/json")).content();
    }

    public void setManualMode(SetManualModeRequest request) {
        this.call(((RequestWithPayload)new PostRequest(this.path("set_manual_mode")).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void setNoneMode(SetNoneModeRequest request) {
        this.call(((RequestWithPayload)new PostRequest(this.path("set_none_mode")).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void setRegexpMode(SetRegexpModeRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("set_regexp_mode")).setParam("branch", request.getBranch())).setParam("portfolio", request.getPortfolio())).setParam("regexp", request.getRegexp())).setMediaType("application/json")).content();
    }

    public void setRemainingProjectsMode(SetRemainingProjectsModeRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("set_remaining_projects_mode")).setParam("branch", request.getBranch())).setParam("portfolio", request.getPortfolio())).setMediaType("application/json")).content();
    }

    public void setTagsMode(SetTagsModeRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("set_tags_mode")).setParam("branch", request.getBranch())).setParam("portfolio", request.getPortfolio())).setParam("tags", request.getTags() == null ? null : request.getTags().stream().collect(Collectors.joining(",")))).setMediaType("application/json")).content();
    }

    public String show(ShowRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("show")).setParam("key", request.getKey())).setMediaType("application/json")).content();
    }

    public void update(UpdateRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("update")).setParam("description", request.getDescription())).setParam("key", request.getKey())).setParam("name", request.getName())).setMediaType("application/json")).content();
    }
}

