/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli.keystore;

import java.nio.file.Path;
import java.security.GeneralSecurityException;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.KeyStoreAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;

public abstract class BaseKeyStoreCommand
extends KeyStoreAwareCommand {
    private KeyStoreWrapper keyStore;
    private SecureString keyStorePassword;
    private final boolean keyStoreMustExist;
    OptionSpec<Void> forceOption;

    public BaseKeyStoreCommand(String description, boolean keyStoreMustExist) {
        super(description);
        this.keyStoreMustExist = keyStoreMustExist;
    }

    public final void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        try {
            Path configFile = env.configFile();
            this.keyStore = KeyStoreWrapper.load((Path)configFile);
            if (this.keyStore == null) {
                if (this.keyStoreMustExist) {
                    throw new UserException(65, "Elasticsearch keystore not found at [" + KeyStoreWrapper.keystorePath((Path)env.configFile()) + "]. Use 'create' command to create one.");
                }
                if (!options.has(this.forceOption) && !terminal.promptYesNo("The elasticsearch keystore does not exist. Do you want to create it?", false)) {
                    terminal.println((CharSequence)"Exiting without creating keystore.");
                    return;
                }
                this.keyStorePassword = new SecureString(new char[0]);
                this.keyStore = KeyStoreWrapper.create();
                this.keyStore.save(configFile, this.keyStorePassword.getChars());
            } else {
                this.keyStorePassword = this.keyStore.hasPassword() ? BaseKeyStoreCommand.readPassword((Terminal)terminal, (boolean)false) : new SecureString(new char[0]);
                this.keyStore.decrypt(this.keyStorePassword.getChars());
            }
            this.executeCommand(terminal, options, env);
        }
        catch (SecurityException | GeneralSecurityException e) {
            throw new UserException(65, e.getMessage());
        }
        finally {
            if (this.keyStorePassword != null) {
                this.keyStorePassword.close();
            }
        }
    }

    protected KeyStoreWrapper getKeyStore() {
        return this.keyStore;
    }

    protected SecureString getKeyStorePassword() {
        return this.keyStorePassword;
    }

    protected abstract void executeCommand(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

