/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene60;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene60.MetadataOnlyBKDReader;

public class Lucene60MetadataOnlyPointsReader
extends PointsReader {
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, PointValues> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene60MetadataOnlyPointsReader(SegmentReadState readState) throws IOException {
        long fp;
        int fieldNumber;
        HashMap<Integer, Long> fieldToFileOffset;
        block17: {
            this.readers = new HashMap<Integer, PointValues>();
            this.readState = readState;
            String indexFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"dii");
            fieldToFileOffset = new HashMap<Integer, Long>();
            try (ChecksumIndexInput indexIn = EndiannessReverserUtil.openChecksumInput((Directory)readState.directory, (String)indexFileName, (IOContext)readState.context);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader((DataInput)indexIn, (String)"Lucene60PointsFormatMeta", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                    int count = indexIn.readVInt();
                    for (int i = 0; i < count; ++i) {
                        fieldNumber = indexIn.readVInt();
                        fp = indexIn.readVLong();
                        fieldToFileOffset.put(fieldNumber, fp);
                    }
                }
                catch (Throwable t) {
                    try {
                        priorE = t;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)indexIn, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)indexIn, (Throwable)priorE);
            }
        }
        String dataFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"dim");
        boolean success = false;
        this.dataIn = EndiannessReverserUtil.openInput((Directory)readState.directory, (String)dataFileName, (IOContext)readState.context);
        try {
            CodecUtil.checkIndexHeader((DataInput)this.dataIn, (String)"Lucene60PointsFormatData", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
            CodecUtil.retrieveChecksum((IndexInput)this.dataIn);
            for (Map.Entry ent : fieldToFileOffset.entrySet()) {
                fieldNumber = (Integer)ent.getKey();
                fp = (Long)ent.getValue();
                this.dataIn.seek(fp);
                MetadataOnlyBKDReader reader = new MetadataOnlyBKDReader(this.dataIn);
                this.readers.put(fieldNumber, reader);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.dataIn);
    }

    public void close() throws IOException {
        this.dataIn.close();
        this.readers.clear();
    }
}

