/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene60;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.bkd.BKDConfig;

public class MetadataOnlyBKDReader
extends PointValues {
    public static final int VERSION_START = 0;
    public static final int VERSION_SELECTIVE_INDEXING = 6;
    public static final int VERSION_META_FILE = 9;
    public static final int VERSION_CURRENT = 9;
    final BKDConfig config;
    final int numLeaves;
    final byte[] minPackedValue;
    final byte[] maxPackedValue;
    final long pointCount;
    final int docCount;
    final int version;

    public MetadataOnlyBKDReader(IndexInput metaIn) throws IOException {
        this.version = CodecUtil.checkHeader((DataInput)metaIn, (String)"BKD", (int)0, (int)9);
        int numDims = metaIn.readVInt();
        int numIndexDims = this.version >= 6 ? metaIn.readVInt() : numDims;
        int maxPointsInLeafNode = metaIn.readVInt();
        int bytesPerDim = metaIn.readVInt();
        this.config = new BKDConfig(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
        this.numLeaves = metaIn.readVInt();
        assert (this.numLeaves > 0);
        this.minPackedValue = new byte[this.config.packedIndexBytesLength];
        this.maxPackedValue = new byte[this.config.packedIndexBytesLength];
        metaIn.readBytes(this.minPackedValue, 0, this.config.packedIndexBytesLength);
        metaIn.readBytes(this.maxPackedValue, 0, this.config.packedIndexBytesLength);
        ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator((int)this.config.bytesPerDim);
        for (int dim = 0; dim < this.config.numIndexDims; ++dim) {
            if (comparator.compare(this.minPackedValue, dim * this.config.bytesPerDim, this.maxPackedValue, dim * this.config.bytesPerDim) <= 0) continue;
            throw new CorruptIndexException("minPackedValue " + new BytesRef(this.minPackedValue) + " is > maxPackedValue " + new BytesRef(this.maxPackedValue) + " for dim=" + dim, (DataInput)metaIn);
        }
        this.pointCount = metaIn.readVLong();
        this.docCount = metaIn.readVInt();
    }

    public PointValues.PointTree getPointTree() {
        throw new UnsupportedOperationException("only metadata operations allowed");
    }

    public byte[] getMinPackedValue() {
        return this.minPackedValue;
    }

    public byte[] getMaxPackedValue() {
        return this.maxPackedValue;
    }

    public int getNumDimensions() {
        return this.config.numDims;
    }

    public int getNumIndexDimensions() {
        return this.config.numIndexDims;
    }

    public int getBytesPerDimension() {
        return this.config.bytesPerDim;
    }

    public long size() {
        return this.pointCount;
    }

    public int getDocCount() {
        return this.docCount;
    }
}

