/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.BitTableUtil;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.BytesStore;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FSTCompiler;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FSTStore;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.OnHeapFSTStore;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.Outputs;

public final class FST<T>
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FST.class);
    private static final int BIT_FINAL_ARC = 1;
    static final int BIT_LAST_ARC = 2;
    static final int BIT_TARGET_NEXT = 4;
    private static final int BIT_STOP_NODE = 8;
    public static final int BIT_ARC_HAS_OUTPUT = 16;
    private static final int BIT_ARC_HAS_FINAL_OUTPUT = 32;
    public static final byte ARCS_FOR_BINARY_SEARCH = 32;
    static final byte ARCS_FOR_DIRECT_ADDRESSING = 64;
    static final int FIXED_LENGTH_ARC_SHALLOW_DEPTH = 3;
    static final int FIXED_LENGTH_ARC_SHALLOW_NUM_ARCS = 5;
    static final int FIXED_LENGTH_ARC_DEEP_NUM_ARCS = 10;
    private static final float DIRECT_ADDRESSING_MAX_OVERSIZE_WITH_CREDIT_FACTOR = 1.66f;
    private static final String FILE_FORMAT_NAME = "FST";
    private static final int VERSION_START = 0;
    private static final int VERSION_INT_NUM_BYTES_PER_ARC = 1;
    private static final int VERSION_SHORT_BYTE2_LABELS = 2;
    private static final int VERSION_PACKED = 3;
    private static final int VERSION_VINT_TARGET = 4;
    private static final int VERSION_NO_NODE_ARC_COUNTS = 5;
    private static final int VERSION_PACKED_REMOVED = 6;
    private static final int VERSION_LITTLE_ENDIAN = 8;
    private static final int VERSION_CURRENT = 8;
    private static final long FINAL_END_NODE = -1L;
    private static final long NON_FINAL_END_NODE = 0L;
    public static final int END_LABEL = -1;
    final INPUT_TYPE inputType;
    T emptyOutput;
    final BytesStore bytes;
    private final FSTStore fstStore;
    private long startNode = -1L;
    public final Outputs<T> outputs;
    private final int version;
    private static final int DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;

    private static boolean flag(int flags, int bit) {
        return (flags & bit) != 0;
    }

    FST(INPUT_TYPE inputType, Outputs<T> outputs, int bytesPageBits) {
        this.inputType = inputType;
        this.outputs = outputs;
        this.fstStore = null;
        this.bytes = new BytesStore(bytesPageBits);
        this.bytes.writeByte((byte)0);
        this.emptyOutput = null;
        this.version = 8;
    }

    public FST(DataInput metaIn, DataInput in, Outputs<T> outputs) throws IOException {
        this(metaIn, in, outputs, new OnHeapFSTStore(DEFAULT_MAX_BLOCK_BITS));
    }

    public FST(DataInput metaIn, DataInput in, Outputs<T> outputs, FSTStore fstStore) throws IOException {
        this.bytes = null;
        this.fstStore = fstStore;
        this.outputs = outputs;
        this.version = CodecUtil.checkHeader((DataInput)metaIn, (String)FILE_FORMAT_NAME, (int)0, (int)8);
        if (this.version < 6 && in.readByte() == 1) {
            throw new CorruptIndexException("Cannot read packed FSTs anymore", in);
        }
        if (metaIn.readByte() == 1) {
            BytesStore emptyBytes = new BytesStore(10);
            int numBytes = metaIn.readVInt();
            emptyBytes.copyBytes(metaIn, numBytes);
            BytesReader reader = emptyBytes.getReverseReader();
            if (numBytes > 0) {
                reader.setPosition(numBytes - 1);
            }
            this.emptyOutput = outputs.readFinalOutput(reader);
        } else {
            this.emptyOutput = null;
        }
        byte t = metaIn.readByte();
        switch (t) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new CorruptIndexException("invalid input type " + t, in);
            }
        }
        this.startNode = metaIn.readVLong();
        if (this.version < 5) {
            metaIn.readVLong();
            metaIn.readVLong();
            metaIn.readVLong();
        }
        long numBytes = metaIn.readVLong();
        this.fstStore.init(in, numBytes);
    }

    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES_USED;
        size = this.fstStore != null ? (size += this.fstStore.ramBytesUsed()) : (size += this.bytes.ramBytesUsed());
        return size;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(input=" + this.inputType + ",output=" + this.outputs;
    }

    void finish(long newStartNode) throws IOException {
        assert (newStartNode <= this.bytes.getPosition());
        if (this.startNode != -1L) {
            throw new IllegalStateException("already finished");
        }
        if (newStartNode == -1L && this.emptyOutput != null) {
            newStartNode = 0L;
        }
        this.startNode = newStartNode;
        this.bytes.finish();
    }

    public T getEmptyOutput() {
        return this.emptyOutput;
    }

    void setEmptyOutput(T v) {
        this.emptyOutput = this.emptyOutput != null ? this.outputs.merge(this.emptyOutput, v) : v;
    }

    public void save(DataOutput metaOut, DataOutput out) throws IOException {
        if (this.startNode == -1L) {
            throw new IllegalStateException("call finish first");
        }
        CodecUtil.writeHeader((DataOutput)metaOut, (String)FILE_FORMAT_NAME, (int)8);
        if (this.emptyOutput != null) {
            metaOut.writeByte((byte)1);
            ByteBuffersDataOutput ros = new ByteBuffersDataOutput();
            this.outputs.writeFinalOutput(this.emptyOutput, (DataOutput)ros);
            byte[] emptyOutputBytes = ros.toArrayCopy();
            int emptyLen = emptyOutputBytes.length;
            int stopAt = emptyLen / 2;
            for (int upto = 0; upto < stopAt; ++upto) {
                byte b = emptyOutputBytes[upto];
                emptyOutputBytes[upto] = emptyOutputBytes[emptyLen - upto - 1];
                emptyOutputBytes[emptyLen - upto - 1] = b;
            }
            metaOut.writeVInt(emptyLen);
            metaOut.writeBytes(emptyOutputBytes, 0, emptyLen);
        } else {
            metaOut.writeByte((byte)0);
        }
        int t = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
        metaOut.writeByte((byte)t);
        metaOut.writeVLong(this.startNode);
        if (this.bytes != null) {
            long numBytes = this.bytes.getPosition();
            metaOut.writeVLong(numBytes);
            this.bytes.writeTo(out);
        } else {
            assert (this.fstStore != null);
            this.fstStore.writeTo(out);
        }
    }

    public void save(Path path) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)os);
            this.save((DataOutput)out, (DataOutput)out);
        }
    }

    public static <T> FST<T> read(Path path, Outputs<T> outputs) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            InputStreamDataInput in = new InputStreamDataInput((InputStream)new BufferedInputStream(is));
            FST<T> fST = new FST<T>((DataInput)in, (DataInput)in, outputs);
            return fST;
        }
    }

    private void writeLabel(DataOutput out, int v) throws IOException {
        assert (v >= 0) : "v=" + v;
        if (this.inputType == INPUT_TYPE.BYTE1) {
            assert (v <= 255) : "v=" + v;
            out.writeByte((byte)v);
        } else if (this.inputType == INPUT_TYPE.BYTE2) {
            assert (v <= 65535) : "v=" + v;
            out.writeShort((short)v);
        } else {
            out.writeVInt(v);
        }
    }

    public int readLabel(DataInput in) throws IOException {
        int v = this.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : (this.inputType == INPUT_TYPE.BYTE2 ? (this.version < 8 ? Short.reverseBytes(in.readShort()) & 0xFFFF : in.readShort() & 0xFFFF) : in.readVInt());
        return v;
    }

    public static <T> boolean targetHasArcs(Arc<T> arc) {
        return arc.target() > 0L;
    }

    long addNode(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> nodeIn) throws IOException {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (nodeIn.numArcs == 0) {
            if (nodeIn.isFinal) {
                return -1L;
            }
            return 0L;
        }
        long startAddress = fstCompiler.bytes.getPosition();
        boolean doFixedLengthArcs = this.shouldExpandNodeWithFixedLengthArcs(fstCompiler, nodeIn);
        if (doFixedLengthArcs && fstCompiler.numBytesPerArc.length < nodeIn.numArcs) {
            fstCompiler.numBytesPerArc = new int[ArrayUtil.oversize((int)nodeIn.numArcs, (int)4)];
            fstCompiler.numLabelBytesPerArc = new int[fstCompiler.numBytesPerArc.length];
        }
        fstCompiler.arcCount += (long)nodeIn.numArcs;
        int lastArc = nodeIn.numArcs - 1;
        long lastArcStart = fstCompiler.bytes.getPosition();
        int maxBytesPerArc = 0;
        int maxBytesPerArcWithoutLabel = 0;
        for (int arcIdx = 0; arcIdx < nodeIn.numArcs; ++arcIdx) {
            int numArcBytes;
            boolean targetHasArcs;
            FSTCompiler.Arc arc = nodeIn.arcs[arcIdx];
            FSTCompiler.CompiledNode target = (FSTCompiler.CompiledNode)arc.target;
            int flags = 0;
            if (arcIdx == lastArc) {
                flags += 2;
            }
            if (fstCompiler.lastFrozenNode == target.node && !doFixedLengthArcs) {
                flags += 4;
            }
            if (arc.isFinal) {
                ++flags;
                if (arc.nextFinalOutput != NO_OUTPUT) {
                    flags += 32;
                }
            } else assert (arc.nextFinalOutput == NO_OUTPUT);
            boolean bl = targetHasArcs = target.node > 0L;
            if (!targetHasArcs) {
                flags += 8;
            }
            if (arc.output != NO_OUTPUT) {
                flags += 16;
            }
            fstCompiler.bytes.writeByte((byte)flags);
            long labelStart = fstCompiler.bytes.getPosition();
            this.writeLabel(fstCompiler.bytes, arc.label);
            int numLabelBytes = (int)(fstCompiler.bytes.getPosition() - labelStart);
            if (arc.output != NO_OUTPUT) {
                this.outputs.write(arc.output, fstCompiler.bytes);
            }
            if (arc.nextFinalOutput != NO_OUTPUT) {
                this.outputs.writeFinalOutput(arc.nextFinalOutput, fstCompiler.bytes);
            }
            if (targetHasArcs && (flags & 4) == 0) {
                assert (target.node > 0L);
                fstCompiler.bytes.writeVLong(target.node);
            }
            if (!doFixedLengthArcs) continue;
            fstCompiler.numBytesPerArc[arcIdx] = numArcBytes = (int)(fstCompiler.bytes.getPosition() - lastArcStart);
            fstCompiler.numLabelBytesPerArc[arcIdx] = numLabelBytes;
            lastArcStart = fstCompiler.bytes.getPosition();
            maxBytesPerArc = Math.max(maxBytesPerArc, numArcBytes);
            maxBytesPerArcWithoutLabel = Math.max(maxBytesPerArcWithoutLabel, numArcBytes - numLabelBytes);
        }
        if (doFixedLengthArcs) {
            assert (maxBytesPerArc > 0);
            int labelRange = nodeIn.arcs[nodeIn.numArcs - 1].label - nodeIn.arcs[0].label + 1;
            assert (labelRange > 0);
            if (this.shouldExpandNodeWithDirectAddressing(fstCompiler, nodeIn, maxBytesPerArc, maxBytesPerArcWithoutLabel, labelRange)) {
                this.writeNodeForDirectAddressing(fstCompiler, nodeIn, startAddress, maxBytesPerArcWithoutLabel, labelRange);
                ++fstCompiler.directAddressingNodeCount;
            } else {
                this.writeNodeForBinarySearch(fstCompiler, nodeIn, startAddress, maxBytesPerArc);
                ++fstCompiler.binarySearchNodeCount;
            }
        }
        long thisNodeAddress = fstCompiler.bytes.getPosition() - 1L;
        fstCompiler.bytes.reverse(startAddress, thisNodeAddress);
        ++fstCompiler.nodeCount;
        return thisNodeAddress;
    }

    private boolean shouldExpandNodeWithFixedLengthArcs(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> node) {
        return fstCompiler.allowFixedLengthArcs && (node.depth <= 3 && node.numArcs >= 5 || node.numArcs >= 10);
    }

    private boolean shouldExpandNodeWithDirectAddressing(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> nodeIn, int numBytesPerArc, int maxBytesPerArcWithoutLabel, int labelRange) {
        int allowedOversize;
        int sizeForBinarySearch = numBytesPerArc * nodeIn.numArcs;
        int sizeForDirectAddressing = FST.getNumPresenceBytes(labelRange) + fstCompiler.numLabelBytesPerArc[0] + maxBytesPerArcWithoutLabel * nodeIn.numArcs;
        int expansionCost = sizeForDirectAddressing - (allowedOversize = (int)((float)sizeForBinarySearch * fstCompiler.getDirectAddressingMaxOversizingFactor()));
        if (expansionCost <= 0 || fstCompiler.directAddressingExpansionCredit >= (long)expansionCost && (float)sizeForDirectAddressing <= (float)allowedOversize * 1.66f) {
            fstCompiler.directAddressingExpansionCredit -= (long)expansionCost;
            return true;
        }
        return false;
    }

    private void writeNodeForBinarySearch(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> nodeIn, long startAddress, int maxBytesPerArc) {
        fstCompiler.fixedLengthArcsBuffer.resetPosition().writeByte((byte)32).writeVInt(nodeIn.numArcs).writeVInt(maxBytesPerArc);
        int headerLen = fstCompiler.fixedLengthArcsBuffer.getPosition();
        long srcPos = fstCompiler.bytes.getPosition();
        long destPos = startAddress + (long)headerLen + (long)(nodeIn.numArcs * maxBytesPerArc);
        assert (destPos >= srcPos);
        if (destPos > srcPos) {
            fstCompiler.bytes.skipBytes((int)(destPos - srcPos));
            for (int arcIdx = nodeIn.numArcs - 1; arcIdx >= 0; --arcIdx) {
                int arcLen = fstCompiler.numBytesPerArc[arcIdx];
                if ((srcPos -= (long)arcLen) == (destPos -= (long)maxBytesPerArc)) continue;
                assert (destPos > srcPos) : "destPos=" + destPos + " srcPos=" + srcPos + " arcIdx=" + arcIdx + " maxBytesPerArc=" + maxBytesPerArc + " arcLen=" + arcLen + " nodeIn.numArcs=" + nodeIn.numArcs;
                fstCompiler.bytes.copyBytes(srcPos, destPos, arcLen);
            }
        }
        fstCompiler.bytes.writeBytes(startAddress, fstCompiler.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
    }

    private void writeNodeForDirectAddressing(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> nodeIn, long startAddress, int maxBytesPerArcWithoutLabel, int labelRange) {
        int headerMaxLen = 11;
        int numPresenceBytes = FST.getNumPresenceBytes(labelRange);
        long srcPos = fstCompiler.bytes.getPosition();
        int totalArcBytes = fstCompiler.numLabelBytesPerArc[0] + nodeIn.numArcs * maxBytesPerArcWithoutLabel;
        int bufferOffset = headerMaxLen + numPresenceBytes + totalArcBytes;
        byte[] buffer = fstCompiler.fixedLengthArcsBuffer.ensureCapacity(bufferOffset).getBytes();
        for (int arcIdx = nodeIn.numArcs - 1; arcIdx >= 0; --arcIdx) {
            int srcArcLen = fstCompiler.numBytesPerArc[arcIdx];
            int labelLen = fstCompiler.numLabelBytesPerArc[arcIdx];
            fstCompiler.bytes.copyBytes(srcPos -= (long)srcArcLen, buffer, bufferOffset -= maxBytesPerArcWithoutLabel, 1);
            int remainingArcLen = srcArcLen - 1 - labelLen;
            if (remainingArcLen != 0) {
                fstCompiler.bytes.copyBytes(srcPos + 1L + (long)labelLen, buffer, bufferOffset + 1, remainingArcLen);
            }
            if (arcIdx != 0) continue;
            fstCompiler.bytes.copyBytes(srcPos + 1L, buffer, bufferOffset -= labelLen, labelLen);
        }
        assert (bufferOffset == headerMaxLen + numPresenceBytes);
        fstCompiler.fixedLengthArcsBuffer.resetPosition().writeByte((byte)64).writeVInt(labelRange).writeVInt(maxBytesPerArcWithoutLabel);
        int headerLen = fstCompiler.fixedLengthArcsBuffer.getPosition();
        long nodeEnd = startAddress + (long)headerLen + (long)numPresenceBytes + (long)totalArcBytes;
        long currentPosition = fstCompiler.bytes.getPosition();
        if (nodeEnd >= currentPosition) {
            fstCompiler.bytes.skipBytes((int)(nodeEnd - currentPosition));
        } else {
            fstCompiler.bytes.truncate(nodeEnd);
        }
        assert (fstCompiler.bytes.getPosition() == nodeEnd);
        long writeOffset = startAddress;
        fstCompiler.bytes.writeBytes(writeOffset, fstCompiler.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
        this.writePresenceBits(fstCompiler, nodeIn, writeOffset += (long)headerLen, numPresenceBytes);
        fstCompiler.bytes.writeBytes(writeOffset += (long)numPresenceBytes, fstCompiler.fixedLengthArcsBuffer.getBytes(), bufferOffset, totalArcBytes);
    }

    private void writePresenceBits(FSTCompiler<T> fstCompiler, FSTCompiler.UnCompiledNode<T> nodeIn, long dest, int numPresenceBytes) {
        long bytePos = dest;
        byte presenceBits = 1;
        int presenceIndex = 0;
        int previousLabel = nodeIn.arcs[0].label;
        for (int arcIdx = 1; arcIdx < nodeIn.numArcs; ++arcIdx) {
            int label = nodeIn.arcs[arcIdx].label;
            assert (label > previousLabel);
            presenceIndex += label - previousLabel;
            while (presenceIndex >= 8) {
                fstCompiler.bytes.writeByte(bytePos++, presenceBits);
                presenceBits = 0;
                presenceIndex -= 8;
            }
            presenceBits = (byte)(presenceBits | 1 << presenceIndex);
            previousLabel = label;
        }
        assert (presenceIndex == (nodeIn.arcs[nodeIn.numArcs - 1].label - nodeIn.arcs[0].label) % 8);
        assert (presenceBits != 0);
        assert ((presenceBits & 1 << presenceIndex) != 0);
        fstCompiler.bytes.writeByte(bytePos++, presenceBits);
        assert (bytePos - dest == (long)numPresenceBytes);
    }

    private static int getNumPresenceBytes(int labelRange) {
        assert (labelRange >= 0);
        return labelRange + 7 >> 3;
    }

    private void readPresenceBytes(Arc<T> arc, BytesReader in) throws IOException {
        assert (arc.bytesPerArc() > 0);
        assert (arc.nodeFlags() == 64);
        arc.bitTableStart = in.getPosition();
        in.skipBytes(FST.getNumPresenceBytes(arc.numArcs()));
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
            if (this.emptyOutput != NO_OUTPUT) {
                arc.flags = (byte)(arc.flags() | 0x20);
            }
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = NO_OUTPUT;
        }
        arc.output = NO_OUTPUT;
        arc.target = this.startNode;
        return arc;
    }

    Arc<T> readLastTargetArc(Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (!FST.targetHasArcs(follow)) {
            assert (follow.isFinal());
            arc.label = -1;
            arc.target = -1L;
            arc.output = follow.nextFinalOutput();
            arc.nodeFlags = arc.flags = (byte)2;
            return arc;
        }
        in.setPosition(follow.target());
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 32 || flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = this.version >= 4 ? in.readVInt() : in.readInt();
            if (flags == 64) {
                this.readPresenceBytes(arc, in);
                arc.firstLabel = this.readLabel(in);
                arc.posArcsStart = in.getPosition();
                this.readLastArcByDirectAddressing(arc, in);
            } else {
                arc.arcIdx = arc.numArcs() - 2;
                arc.posArcsStart = in.getPosition();
                this.readNextRealArc(arc, in);
            }
        } else {
            arc.flags = flags;
            arc.bytesPerArc = 0;
            while (!arc.isLast()) {
                this.readLabel(in);
                if (arc.flag(16)) {
                    this.outputs.skipOutput(in);
                }
                if (arc.flag(32)) {
                    this.outputs.skipFinalOutput(in);
                }
                if (!arc.flag(8) && !arc.flag(4)) {
                    this.readUnpackedNodeTarget(in);
                }
                arc.flags = in.readByte();
            }
            in.skipBytes(-1L);
            arc.nextArc = in.getPosition();
            this.readNextRealArc(arc, in);
        }
        assert (arc.isLast());
        return arc;
    }

    private long readUnpackedNodeTarget(BytesReader in) throws IOException {
        if (this.version < 4) {
            return in.readInt();
        }
        return in.readVLong();
    }

    public Arc<T> readFirstTargetArc(Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (follow.isFinal()) {
            arc.label = -1;
            arc.output = follow.nextFinalOutput();
            arc.flags = 1;
            if (follow.target() <= 0L) {
                arc.flags = (byte)(arc.flags | 2);
            } else {
                arc.nextArc = follow.target();
            }
            arc.target = -1L;
            arc.nodeFlags = arc.flags;
            return arc;
        }
        return this.readFirstRealTargetArc(follow.target(), arc, in);
    }

    public Arc<T> readFirstRealTargetArc(long nodeAddress, Arc<T> arc, BytesReader in) throws IOException {
        in.setPosition(nodeAddress);
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 32 || flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = this.version >= 4 ? in.readVInt() : in.readInt();
            arc.arcIdx = -1;
            if (flags == 64) {
                this.readPresenceBytes(arc, in);
                arc.firstLabel = this.readLabel(in);
                arc.presenceIndex = -1;
            }
            arc.posArcsStart = in.getPosition();
        } else {
            arc.nextArc = nodeAddress;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc, in);
    }

    boolean isExpandedTarget(Arc<T> follow, BytesReader in) throws IOException {
        if (!FST.targetHasArcs(follow)) {
            return false;
        }
        in.setPosition(follow.target());
        byte flags = in.readByte();
        return flags == 32 || flags == 64;
    }

    public Arc<T> readNextArc(Arc<T> arc, BytesReader in) throws IOException {
        if (arc.label() == -1) {
            if (arc.nextArc() <= 0L) {
                throw new IllegalArgumentException("cannot readNextArc when arc.isLast()=true");
            }
            return this.readFirstRealTargetArc(arc.nextArc(), arc, in);
        }
        return this.readNextRealArc(arc, in);
    }

    /*
     * Enabled aggressive block sorting
     */
    int readNextArcLabel(Arc<T> arc, BytesReader in) throws IOException {
        assert (!arc.isLast());
        if (arc.label() == -1) {
            in.setPosition(arc.nextArc());
            byte flags = in.readByte();
            if (flags != 32) {
                if (flags != 64) return this.readLabel(in);
            }
            int numArcs = in.readVInt();
            if (this.version >= 4) {
                in.readVInt();
            } else {
                in.readInt();
            }
            if (flags == 32) {
                in.readByte();
                return this.readLabel(in);
            }
            in.skipBytes(FST.getNumPresenceBytes(numArcs));
            return this.readLabel(in);
        }
        if (arc.bytesPerArc() == 0) {
            in.setPosition(arc.nextArc() - 1L);
            return this.readLabel(in);
        }
        if (arc.nodeFlags() == 32) {
            in.setPosition(arc.posArcsStart() - (long)((1 + arc.arcIdx()) * arc.bytesPerArc()) - 1L);
            return this.readLabel(in);
        }
        assert (arc.nodeFlags() == 64);
        assert (Arc.BitTable.assertIsValid(arc, in));
        assert (Arc.BitTable.isBitSet(arc.arcIdx(), arc, in));
        int nextIndex = Arc.BitTable.nextBitSet(arc.arcIdx(), arc, in);
        if ($assertionsDisabled) return arc.firstLabel() + nextIndex;
        if (nextIndex != -1) return arc.firstLabel() + nextIndex;
        throw new AssertionError();
    }

    public Arc<T> readArcByIndex(Arc<T> arc, BytesReader in, int idx) throws IOException {
        assert (arc.bytesPerArc() > 0);
        assert (arc.nodeFlags() == 32);
        assert (idx >= 0 && idx < arc.numArcs());
        in.setPosition(arc.posArcsStart() - (long)(idx * arc.bytesPerArc()));
        arc.arcIdx = idx;
        arc.flags = in.readByte();
        return this.readArc(arc, in);
    }

    public Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex) throws IOException {
        assert (Arc.BitTable.assertIsValid(arc, in));
        assert (rangeIndex >= 0 && rangeIndex < arc.numArcs());
        assert (Arc.BitTable.isBitSet(rangeIndex, arc, in));
        int presenceIndex = Arc.BitTable.countBitsUpTo(rangeIndex, arc, in);
        return this.readArcByDirectAddressing(arc, in, rangeIndex, presenceIndex);
    }

    private Arc<T> readArcByDirectAddressing(Arc<T> arc, BytesReader in, int rangeIndex, int presenceIndex) throws IOException {
        in.setPosition(arc.posArcsStart() - (long)(presenceIndex * arc.bytesPerArc()));
        arc.arcIdx = rangeIndex;
        arc.presenceIndex = presenceIndex;
        arc.flags = in.readByte();
        return this.readArc(arc, in);
    }

    public Arc<T> readLastArcByDirectAddressing(Arc<T> arc, BytesReader in) throws IOException {
        assert (Arc.BitTable.assertIsValid(arc, in));
        int presenceIndex = Arc.BitTable.countBits(arc, in) - 1;
        return this.readArcByDirectAddressing(arc, in, arc.numArcs() - 1, presenceIndex);
    }

    public Arc<T> readNextRealArc(Arc<T> arc, BytesReader in) throws IOException {
        switch (arc.nodeFlags()) {
            case 32: {
                assert (arc.bytesPerArc() > 0);
                ++arc.arcIdx;
                assert (arc.arcIdx() >= 0 && arc.arcIdx() < arc.numArcs());
                in.setPosition(arc.posArcsStart() - (long)(arc.arcIdx() * arc.bytesPerArc()));
                arc.flags = in.readByte();
                break;
            }
            case 64: {
                assert (Arc.BitTable.assertIsValid(arc, in));
                assert (arc.arcIdx() == -1 || Arc.BitTable.isBitSet(arc.arcIdx(), arc, in));
                int nextIndex = Arc.BitTable.nextBitSet(arc.arcIdx(), arc, in);
                return this.readArcByDirectAddressing(arc, in, nextIndex, arc.presenceIndex + 1);
            }
            default: {
                assert (arc.bytesPerArc() == 0);
                in.setPosition(arc.nextArc());
                arc.flags = in.readByte();
            }
        }
        return this.readArc(arc, in);
    }

    private Arc<T> readArc(Arc<T> arc, BytesReader in) throws IOException {
        arc.label = arc.nodeFlags() == 64 ? arc.firstLabel() + arc.arcIdx() : this.readLabel(in);
        arc.output = arc.flag(16) ? this.outputs.read(in) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.readFinalOutput(in) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1L : 0L;
            arc.nextArc = in.getPosition();
        } else if (arc.flag(4)) {
            arc.nextArc = in.getPosition();
            if (!arc.flag(2)) {
                if (arc.bytesPerArc() == 0) {
                    this.seekToNextNode(in);
                } else {
                    int numArcs = arc.nodeFlags == 64 ? Arc.BitTable.countBits(arc, in) : arc.numArcs();
                    in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * numArcs));
                }
            }
            arc.target = in.getPosition();
        } else {
            arc.target = this.readUnpackedNodeTarget(in);
            arc.nextArc = in.getPosition();
        }
        return arc;
    }

    static <T> Arc<T> readEndArc(Arc<T> follow, Arc<T> arc) {
        if (follow.isFinal()) {
            if (follow.target() <= 0L) {
                arc.flags = (byte)2;
            } else {
                arc.flags = 0;
                arc.nextArc = follow.target();
            }
            arc.output = follow.nextFinalOutput();
            arc.label = -1;
            return arc;
        }
        return null;
    }

    public Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target() <= 0L) {
                    arc.flags = (byte)2;
                } else {
                    arc.flags = 0;
                    arc.nextArc = follow.target();
                }
                arc.output = follow.nextFinalOutput();
                arc.label = -1;
                arc.nodeFlags = arc.flags;
                return arc;
            }
            return null;
        }
        if (!FST.targetHasArcs(follow)) {
            return null;
        }
        in.setPosition(follow.target());
        byte flags = arc.nodeFlags = in.readByte();
        if (flags == 64) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = this.version >= 4 ? in.readVInt() : in.readInt();
            this.readPresenceBytes(arc, in);
            arc.firstLabel = this.readLabel(in);
            arc.posArcsStart = in.getPosition();
            int arcIndex = labelToMatch - arc.firstLabel();
            if (arcIndex < 0 || arcIndex >= arc.numArcs()) {
                return null;
            }
            if (!Arc.BitTable.isBitSet(arcIndex, arc, in)) {
                return null;
            }
            return this.readArcByDirectAddressing(arc, in, arcIndex);
        }
        if (flags == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = this.version >= 4 ? in.readVInt() : in.readInt();
            arc.posArcsStart = in.getPosition();
            int low = 0;
            int high = arc.numArcs() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart() - (long)(arc.bytesPerArc() * mid + 1));
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.arcIdx = mid - 1;
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        this.readFirstRealTargetArc(follow.target(), arc, in);
        while (arc.label() != labelToMatch) {
            if (arc.label() > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            this.readNextRealArc(arc, in);
        }
        return arc;
    }

    private void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        } while (!FST.flag(flags, 2));
    }

    public BytesReader getBytesReader() {
        if (this.fstStore != null) {
            return this.fstStore.getReverseBytesReader();
        }
        return this.bytes.getReverseReader();
    }

    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }

    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);

        public abstract boolean reversed();
    }

    public static final class Arc<T> {
        private int label;
        private T output;
        private long target;
        private byte flags;
        private T nextFinalOutput;
        private long nextArc;
        private byte nodeFlags;
        private int bytesPerArc;
        private long posArcsStart;
        private int arcIdx;
        private int numArcs;
        private long bitTableStart;
        private int firstLabel;
        private int presenceIndex;

        public Arc<T> copyFrom(Arc<T> other) {
            this.label = other.label();
            this.target = other.target();
            this.flags = other.flags();
            this.output = other.output();
            this.nextFinalOutput = other.nextFinalOutput();
            this.nextArc = other.nextArc();
            this.nodeFlags = other.nodeFlags();
            this.bytesPerArc = other.bytesPerArc();
            this.posArcsStart = other.posArcsStart();
            this.arcIdx = other.arcIdx();
            this.numArcs = other.numArcs();
            this.bitTableStart = other.bitTableStart;
            this.firstLabel = other.firstLabel();
            this.presenceIndex = other.presenceIndex;
            return this;
        }

        boolean flag(int flag) {
            return FST.flag(this.flags, flag);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" target=").append(this.target());
            b.append(" label=0x").append(Integer.toHexString(this.label()));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                b.append(" output=").append(this.output());
            }
            if (this.flag(32)) {
                b.append(" nextFinalOutput=").append(this.nextFinalOutput());
            }
            if (this.bytesPerArc() != 0) {
                b.append(" arcArray(idx=").append(this.arcIdx()).append(" of ").append(this.numArcs()).append(")").append("(").append(this.nodeFlags() == 64 ? "da" : "bs").append(")");
            }
            return b.toString();
        }

        public int label() {
            return this.label;
        }

        public T output() {
            return this.output;
        }

        public long target() {
            return this.target;
        }

        public byte flags() {
            return this.flags;
        }

        public T nextFinalOutput() {
            return this.nextFinalOutput;
        }

        long nextArc() {
            return this.nextArc;
        }

        public int arcIdx() {
            return this.arcIdx;
        }

        public byte nodeFlags() {
            return this.nodeFlags;
        }

        public long posArcsStart() {
            return this.posArcsStart;
        }

        public int bytesPerArc() {
            return this.bytesPerArc;
        }

        public int numArcs() {
            return this.numArcs;
        }

        int firstLabel() {
            return this.firstLabel;
        }

        static class BitTable {
            BitTable() {
            }

            static boolean isBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.isBitSet(bitIndex, in);
            }

            static int countBits(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBits(FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static int countBitsUpTo(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.countBitsUpTo(bitIndex, in);
            }

            static int nextBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.nextBitSet(bitIndex, FST.getNumPresenceBytes(arc.numArcs()), in);
            }

            static int previousBitSet(int bitIndex, Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.nodeFlags() == 64);
                in.setPosition(arc.bitTableStart);
                return BitTableUtil.previousBitSet(bitIndex, in);
            }

            static boolean assertIsValid(Arc<?> arc, BytesReader in) throws IOException {
                assert (arc.bytesPerArc() > 0);
                assert (arc.nodeFlags() == 64);
                assert (BitTable.isBitSet(0, arc, in));
                assert (BitTable.isBitSet(arc.numArcs() - 1, arc, in));
                assert (BitTable.nextBitSet(arc.numArcs() - 1, arc, in) == -1);
                return true;
            }
        }
    }
}

