/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst;

import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FST;

final class ForwardBytesReader
extends FST.BytesReader {
    private final byte[] bytes;
    private int pos;

    ForwardBytesReader(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte readByte() {
        return this.bytes[this.pos++];
    }

    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos + count);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = (int)pos;
    }

    @Override
    public boolean reversed() {
        return false;
    }
}

