/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst;

import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FST;

final class ReverseBytesReader
extends FST.BytesReader {
    private final byte[] bytes;
    private int pos;

    ReverseBytesReader(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte readByte() {
        return this.bytes[this.pos--];
    }

    public void readBytes(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            b[offset + i] = this.bytes[this.pos--];
        }
    }

    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos - count);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = (int)pos;
    }

    @Override
    public boolean reversed() {
        return true;
    }
}

