/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.aggregations.bucket.timeseries.InternalTimeSeries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class TimeSeriesAggregator
extends BucketsAggregator {
    protected final BytesKeyedBucketOrds bucketOrds;
    private final boolean keyed;
    private final int size;

    public TimeSeriesAggregator(String name, AggregatorFactories factories, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata, int size) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.keyed = keyed;
        this.bucketOrds = BytesKeyedBucketOrds.build((BigArrays)this.bigArrays(), (CardinalityUpperBound)bucketCardinality);
        this.size = size;
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        BytesRef spare = new BytesRef();
        InternalTimeSeries.InternalBucket[][] allBucketsPerOrd = new InternalTimeSeries.InternalBucket[owningBucketOrds.length][];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            ArrayList<InternalTimeSeries.InternalBucket> buckets = new ArrayList<InternalTimeSeries.InternalBucket>();
            BytesRef prev = null;
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                ordsEnum.readValue(spare);
                assert (prev == null || spare.compareTo(prev) > 0) : "key [" + spare.utf8ToString() + "] is smaller than previous key [" + prev.utf8ToString() + "]";
                prev = BytesRef.deepCopyOf((BytesRef)spare);
                InternalTimeSeries.InternalBucket bucket = new InternalTimeSeries.InternalBucket(prev, docCount, null, this.keyed);
                bucket.bucketOrd = ordsEnum.ord();
                buckets.add(bucket);
                if (buckets.size() < this.size) continue;
                break;
            }
            allBucketsPerOrd[ordIdx] = buckets.toArray(new InternalTimeSeries.InternalBucket[0]);
        }
        this.buildSubAggsForAllBuckets((Object[][])allBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
            b.aggregations = a;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(allBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalTimeSeries(this.name, new ArrayList<InternalTimeSeries.InternalBucket>(), false, this.metadata());
    }

    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    protected LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(sub, null){
            long currentTsidOrd;
            long currentBucket;
            long currentBucketOrdinal;
            {
                super(arg0, arg1);
                this.currentTsidOrd = -1L;
                this.currentBucket = -1L;
            }

            public void collect(int doc, long bucket) throws IOException {
                if (this.currentBucket == bucket && this.currentTsidOrd == (long)aggCtx.getTsidOrd()) {
                    TimeSeriesAggregator.this.collectExistingBucket(sub, doc, this.currentBucketOrdinal);
                    return;
                }
                long bucketOrdinal = TimeSeriesAggregator.this.bucketOrds.add(bucket, aggCtx.getTsid());
                if (bucketOrdinal < 0L) {
                    bucketOrdinal = -1L - bucketOrdinal;
                    TimeSeriesAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                } else {
                    TimeSeriesAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                }
                this.currentBucketOrdinal = bucketOrdinal;
                this.currentTsidOrd = aggCtx.getTsidOrd();
                this.currentBucket = bucket;
            }
        };
    }

    InternalTimeSeries buildResult(InternalTimeSeries.InternalBucket[] topBuckets) {
        return new InternalTimeSeries(this.name, List.of(topBuckets), this.keyed, this.metadata());
    }
}

