/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.aggregations.metric.ArrayValuesSourceAggregationBuilder;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public abstract class ArrayValuesSourceParser
implements Aggregator.Parser {
    private final boolean formattable;
    private final ValuesSourceType valuesSourceType;

    private ArrayValuesSourceParser(boolean formattable, ValuesSourceType valuesSourceType) {
        this.valuesSourceType = valuesSourceType;
        this.formattable = formattable;
    }

    public final ArrayValuesSourceAggregationBuilder<?> parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        List<String> fields = null;
        String format = null;
        HashMap<String, Object> missingMap = null;
        HashMap<ParseField, Object> otherOptions = new HashMap<ParseField, Object>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (AggregationBuilder.CommonFields.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    fields = Collections.singletonList(parser.text());
                    continue;
                }
                if (this.formattable && AggregationBuilder.CommonFields.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (AggregationBuilder.CommonFields.VALUE_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (AggregationBuilder.CommonFields.MISSING.match(currentFieldName, parser.getDeprecationHandler())) {
                    missingMap = new HashMap<String, Object>();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        this.parseMissingAndAdd(aggregationName, currentFieldName, parser, missingMap);
                    }
                    continue;
                }
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (AggregationBuilder.CommonFields.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    fields = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            fields.add(parser.text());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
                    }
                    continue;
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
        }
        ArrayValuesSourceAggregationBuilder<?> factory = this.createFactory(aggregationName, this.valuesSourceType, otherOptions);
        if (fields != null) {
            factory.fields(fields);
        }
        if (format != null) {
            factory.format(format);
        }
        if (missingMap != null) {
            factory.missingMap(missingMap);
        }
        return factory;
    }

    private void parseMissingAndAdd(String aggregationName, String currentFieldName, XContentParser parser, Map<String, Object> missing) throws IOException {
        String fieldName;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            fieldName = parser.currentName();
            if (missing.containsKey(fieldName)) {
                throw new ParsingException(parser.getTokenLocation(), "Missing field [" + fieldName + "] already defined as [" + missing.get(fieldName) + "] in [" + aggregationName + "].", new Object[0]);
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " [" + currentFieldName + "] in [" + aggregationName + "]", new Object[0]);
        }
        parser.nextToken();
        missing.put(fieldName, parser.objectText());
    }

    protected abstract ArrayValuesSourceAggregationBuilder<?> createFactory(String var1, ValuesSourceType var2, Map<ParseField, Object> var3);

    protected abstract boolean token(String var1, String var2, XContentParser.Token var3, XContentParser var4, Map<ParseField, Object> var5) throws IOException;

    public static abstract class GeoPointValuesSourceParser
    extends ArrayValuesSourceParser {
        protected GeoPointValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)CoreValuesSourceType.GEOPOINT);
        }
    }

    public static abstract class BytesValuesSourceParser
    extends ArrayValuesSourceParser {
        protected BytesValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)CoreValuesSourceType.KEYWORD);
        }
    }

    public static abstract class NumericValuesSourceParser
    extends ArrayValuesSourceParser {
        protected NumericValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)CoreValuesSourceType.NUMERIC);
        }
    }
}

