/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;

public final class Releasables
extends Enum<Releasables> {
    private static final /* synthetic */ Releasables[] $VALUES;

    public static Releasables[] values() {
        return (Releasables[])$VALUES.clone();
    }

    public static Releasables valueOf(String name) {
        return Enum.valueOf(Releasables.class, name);
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        try {
            IOUtils.close(releasables);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(@Nullable Releasable releasable) {
        try {
            IOUtils.close((Closeable)releasable);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(Releasable ... releasables) {
        Releasables.close(true, releasables);
    }

    public static void closeExpectNoException(Releasable ... releasables) {
        try {
            Releasables.close(releasables);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeExpectNoException(Releasable releasable) {
        try {
            Releasables.close(releasable);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeWhileHandlingException(Releasable ... releasables) {
        Releasables.close(false, releasables);
    }

    private static void close(boolean success, Releasable ... releasables) {
        block2: {
            try {
                IOUtils.close(releasables);
            }
            catch (IOException e) {
                if (!success) break block2;
                throw new UncheckedIOException(e);
            }
        }
    }

    public static Releasable wrap(Iterable<Releasable> releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable wrap(Releasable ... releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable releaseOnce(Releasable releasable) {
        final AtomicReference<Releasable> ref = new AtomicReference<Releasable>(releasable);
        return new Releasable(){

            @Override
            public void close() {
                Releasable acquired = ref.getAndSet(null);
                if (acquired != null) {
                    acquired.close();
                }
            }

            public String toString() {
                return "releaseOnce[" + ref.get() + "]";
            }
        };
    }

    private static /* synthetic */ Releasables[] $values() {
        return new Releasables[0];
    }

    static {
        $VALUES = Releasables.$values();
    }
}

