/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.internal.provider.EmbeddedModulePath;
import org.elasticsearch.core.internal.provider.InMemoryModuleFinder;

public final class EmbeddedImplClassLoader
extends SecureClassLoader {
    private static final String IMPL_PREFIX = "IMPL-JARS/";
    private static final String JAR_LISTING_FILE = "/LISTING.TXT";
    private final List<JarMeta> jarMetas;
    private final Map<String, JarMeta> packageToJarMeta;
    private final Map<String, CodeSource> prefixToCodeBase;
    private final ClassLoader parent;
    private static final int BASE_VERSION_FEATURE = 8;
    private static final int RUNTIME_VERSION_FEATURE = Runtime.version().feature();
    private static final String MRJAR_VERSION_PREFIX = "META-INF/versions/";

    static EmbeddedImplClassLoader getInstance(ClassLoader parent, String providerName) {
        PrivilegedAction<EmbeddedImplClassLoader> pa = () -> new EmbeddedImplClassLoader(parent, EmbeddedImplClassLoader.getProviderPrefixes(parent, providerName));
        return AccessController.doPrivileged(pa);
    }

    private EmbeddedImplClassLoader(ClassLoader parent, Map<JarMeta, CodeSource> prefixToCodeBase) {
        super(null);
        this.jarMetas = prefixToCodeBase.keySet().stream().toList();
        this.parent = parent;
        this.prefixToCodeBase = prefixToCodeBase.entrySet().stream().collect(Collectors.toUnmodifiableMap(k -> ((JarMeta)k.getKey()).prefix(), Map.Entry::getValue));
        HashMap map = new HashMap();
        for (JarMeta jarMeta : prefixToCodeBase.keySet()) {
            jarMeta.packages().stream().forEach(pkg -> {
                JarMeta prev = map.put(pkg, jarMeta);
                assert (prev == null);
            });
        }
        this.packageToJarMeta = Collections.unmodifiableMap(map);
    }

    private Resource privilegedGetResourceOrNull(JarMeta jarMeta, String pkg, String filepath) {
        return AccessController.doPrivileged(() -> {
            InputStream is = this.findResourceInLoaderPkgOrNull(jarMeta, pkg, filepath, this.parent::getResourceAsStream);
            if (is != null) {
                return new Resource(is, this.prefixToCodeBase.get(jarMeta.prefix()));
            }
            return null;
        });
    }

    @Override
    public Class<?> findClass(String moduleName, String name) {
        try {
            Class<?> c = this.findClass(name);
            if (moduleName != null && !moduleName.equals(c.getModule().getName())) {
                throw new AssertionError((Object)("expected module:" + moduleName + ", got: " + c.getModule().getName()));
            }
            return c;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String filepath = name.replace('.', '/').concat(".class");
        String pkg = EmbeddedImplClassLoader.toPackageName(filepath);
        JarMeta jarMeta = this.packageToJarMeta.get(pkg);
        if (jarMeta != null) {
            Resource res = this.privilegedGetResourceOrNull(jarMeta, pkg, filepath);
            if (res != null) {
                Class<?> clazz;
                block10: {
                    InputStream in = res.inputStream();
                    try {
                        byte[] bytes = in.readAllBytes();
                        clazz = this.defineClass(name, bytes, 0, bytes.length, res.codeSource());
                        if (in == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    in.close();
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        return this.parent.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        Objects.requireNonNull(name);
        String pkg = EmbeddedImplClassLoader.toPackageName(name);
        JarMeta jarMeta = this.packageToJarMeta.get(pkg);
        URL url = jarMeta != null ? this.findResourceInLoaderPkgOrNull(jarMeta, pkg, name, this.parent::getResource) : this.findMiscResourceOrNull(name);
        if (url != null) {
            return url;
        }
        return this.parent.getResource(name);
    }

    <T> T findResourceInLoaderPkgOrNull(JarMeta jarMeta, String pkg, String name, Function<String, T> finder) {
        List releaseVersions = jarMeta.pkgToVersions().getOrDefault(pkg, List.of());
        Iterator iterator = releaseVersions.iterator();
        while (iterator.hasNext()) {
            int releaseVersion = (Integer)iterator.next();
            String fullName = jarMeta.prefix() + "/META-INF/versions/" + releaseVersion + "/" + name;
            T t = finder.apply(fullName);
            if (t == null) continue;
            return t;
        }
        return finder.apply(jarMeta.prefix() + "/" + name);
    }

    URL findMiscResourceOrNull(String name) {
        for (JarMeta jarMeta : this.jarMetas) {
            URL url = this.findResourceForPrefixOrNull(name, jarMeta);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    URL findResourceForPrefixOrNull(String name, JarMeta jarMeta) {
        URL url;
        if (jarMeta.isMultiRelease && (url = this.findVersionedResourceForPrefixOrNull(jarMeta.prefix(), name)) != null) {
            return url;
        }
        return this.parent.getResource(jarMeta.prefix() + "/" + name);
    }

    URL findVersionedResourceForPrefixOrNull(String prefix, String name) {
        for (int v = RUNTIME_VERSION_FEATURE; v >= 8; --v) {
            URL url = this.parent.getResource(prefix + "/META-INF/versions/" + v + "/" + name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(final String name) throws IOException {
        Enumeration<URL> enum1 = new Enumeration<URL>(){
            private int jarMetaIndex = 0;
            private URL url = null;

            private boolean next() {
                if (this.url != null) {
                    return true;
                }
                while (this.jarMetaIndex < EmbeddedImplClassLoader.this.jarMetas.size()) {
                    URL u = EmbeddedImplClassLoader.this.findResourceForPrefixOrNull(name, EmbeddedImplClassLoader.this.jarMetas.get(this.jarMetaIndex));
                    ++this.jarMetaIndex;
                    if (u == null) continue;
                    this.url = u;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }
        };
        Enumeration[] tmp = new Enumeration[]{enum1, this.parent.getResources(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    InMemoryModuleFinder moduleFinder(Set<String> missingModules) throws IOException {
        Path[] modulePath = this.modulePath();
        assert (modulePath.length >= 1);
        InMemoryModuleFinder moduleFinder = InMemoryModuleFinder.of(missingModules, modulePath);
        if (modulePath[0].getFileSystem().provider().getScheme().equals("jar")) {
            modulePath[0].getFileSystem().close();
        }
        return moduleFinder;
    }

    static String basePrefix(String prefix) {
        int idx = prefix.indexOf(MRJAR_VERSION_PREFIX);
        if (idx == -1) {
            return prefix;
        }
        return prefix.substring(0, idx - 1);
    }

    private Path[] modulePath() throws IOException {
        URI rootURI = EmbeddedImplClassLoader.rootURI(this.prefixToCodeBase.values().stream().findFirst().map(CodeSource::getLocation).orElseThrow());
        return EmbeddedImplClassLoader.embeddedJarPath(this.prefixToCodeBase.keySet(), rootURI);
    }

    private static Path[] embeddedJarPath(Set<String> prefixes, URI rootURI) throws IOException {
        Function<Path, Path[]> entries = path -> (Path[])prefixes.stream().map(EmbeddedImplClassLoader::basePrefix).distinct().map(pfx -> path.resolve((String)pfx)).toArray(Path[]::new);
        if (rootURI.getScheme().equals("file")) {
            return entries.apply(Path.of(rootURI));
        }
        if (rootURI.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(rootURI, Map.of(), ClassLoader.getSystemClassLoader());
            Path rootPath = fileSystem.getPath("/", new String[0]);
            return entries.apply(rootPath);
        }
        throw new IOException("unknown scheme:" + rootURI.getScheme());
    }

    static URI rootURI(URL url) {
        try {
            URI uri = url.toURI();
            if (uri.getScheme().equals("jar")) {
                String s = uri.toString();
                return URI.create(s.substring(0, s.lastIndexOf("!/")));
            }
            return URI.create(EmbeddedImplClassLoader.getParent(EmbeddedImplClassLoader.getParent(EmbeddedImplClassLoader.getParent(uri.toString()))));
        }
        catch (URISyntaxException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    static String removeMRJARPrefix(Path path) {
        assert (path.startsWith(MRJAR_VERSION_PREFIX)) : path;
        int c = path.getNameCount();
        assert (c >= 3) : path.getNameCount();
        return c == 3 ? "" : path.subpath(3, path.getNameCount()).toString();
    }

    static int getMRVersionFromPrefix(Path path) {
        assert (path.startsWith(MRJAR_VERSION_PREFIX)) : path;
        int c = path.getNameCount();
        assert (c >= 3) : path.getNameCount();
        return Integer.valueOf(path.subpath(2, 3).toString());
    }

    static String toPackageName(String name) {
        assert (!name.endsWith("/"));
        int index = name.lastIndexOf(47);
        if (index != -1) {
            return name.substring(0, index).replace('/', '.');
        }
        return name;
    }

    static ScanResult scanPackages(Path dir, boolean isMultiRelease) {
        String separator = dir.getFileSystem().getSeparator();
        HashSet pkgs = new HashSet();
        HashMap pkgVersions = new HashMap();
        try (Stream<Path> paths = Files.find(dir, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);){
            paths.map(path -> dir.relativize((Path)path)).forEach(path -> {
                Path parent = path.getParent();
                if (parent != null) {
                    if (parent.startsWith(MRJAR_VERSION_PREFIX)) {
                        String pkg;
                        int version = EmbeddedImplClassLoader.getMRVersionFromPrefix(path);
                        if (isMultiRelease && version <= RUNTIME_VERSION_FEATURE && EmbeddedModulePath.isPackageName(pkg = EmbeddedImplClassLoader.removeMRJARPrefix(parent).replace(separator, "."))) {
                            pkgVersions.computeIfAbsent(pkg, k -> new ArrayList()).add(version);
                            pkgs.add(pkg);
                        }
                    } else {
                        String pkg = parent.toString().replace(separator, ".");
                        if (EmbeddedModulePath.isPackageName(pkg)) {
                            pkgs.add(pkg);
                        }
                    }
                }
            });
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return new ScanResult(Set.copyOf(pkgs), pkgVersions.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().sorted(Comparator.reverseOrder()).toList())));
    }

    /*
     * Exception decompiling
     */
    private static Map<JarMeta, CodeSource> getProviderPrefixes(ClassLoader parent, String providerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CodeSource codeSource(URL baseURL, String jarName) throws MalformedURLException {
        return new CodeSource(new URL(baseURL, jarName), (CodeSigner[])null);
    }

    private static boolean isMultiRelease(ClassLoader parent, String jarPrefix) throws IOException {
        try (InputStream is = parent.getResourceAsStream(jarPrefix + "/META-INF/MANIFEST.MF");){
            if (is != null) {
                Manifest manifest = new Manifest(is);
                boolean bl = Boolean.parseBoolean(manifest.getMainAttributes().getValue(Attributes.Name.MULTI_RELEASE));
                return bl;
            }
        }
        return false;
    }

    private static String getParent(String uriString) {
        int index = uriString.lastIndexOf(47);
        if (index > 0) {
            return uriString.substring(0, index);
        }
        return "/";
    }

    static {
        assert (RUNTIME_VERSION_FEATURE >= 8);
    }

    record JarMeta(String prefix, boolean isMultiRelease, Set<String> packages, Map<String, List<Integer>> pkgToVersions) {
    }

    record Resource(InputStream inputStream, CodeSource codeSource) {
    }

    static final class CompoundEnumeration<E>
    implements Enumeration<E> {
        private final Enumeration<E>[] enumerations;
        private int index;

        CompoundEnumeration(Enumeration<E>[] enumerations) {
            this.enumerations = enumerations;
        }

        private boolean next() {
            while (this.index < this.enumerations.length) {
                if (this.enumerations[this.index] != null && this.enumerations[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enumerations[this.index].nextElement();
        }
    }

    record ScanResult(Set<String> packages, Map<String, List<Integer>> pkgVersions) {
    }
}

