/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.util.EnumSet;
import java.util.stream.Collectors;
import org.elasticsearch.common.ssl.SslConfigException;

public enum X509Field {
    SAN_OTHERNAME_COMMONNAME("subjectAltName.otherName.commonName", true),
    SAN_DNS("subjectAltName.dnsName", true);

    private final String configValue;
    private final boolean supportedForRestrictedTrust;

    private X509Field(String configValue, boolean supportedForRestrictedTrust) {
        this.configValue = configValue;
        this.supportedForRestrictedTrust = supportedForRestrictedTrust;
    }

    public String toString() {
        return this.configValue;
    }

    public static X509Field parseForRestrictedTrust(String s) {
        return EnumSet.allOf(X509Field.class).stream().filter(v -> v.supportedForRestrictedTrust).filter(v -> v.configValue.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> {
            throw new SslConfigException(s + " is not a supported x509 field for trust restrictions. Recognised values are [" + EnumSet.allOf(X509Field.class).stream().map(e -> e.configValue).collect(Collectors.toSet()) + "]");
        });
    }
}

