/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;

class AggregateMetricBackedAvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final AggregateMetricsValuesSource.AggregateDoubleMetric valuesSource;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    AggregateMetricBackedAvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        AggregateMetricsValuesSource.AggregateDoubleMetric aggregateDoubleMetric = this.valuesSource = valuesSourceConfig.hasValues() ? (AggregateMetricsValuesSource.AggregateDoubleMetric)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
        }
        this.format = valuesSourceConfig.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.bigArrays();
        final SortedNumericDoubleValues aggregateSums = this.valuesSource.getAggregateMetricValues(aggCtx.getLeafReaderContext(), AggregateDoubleMetricFieldMapper.Metric.sum);
        final SortedNumericDoubleValues aggregateValueCounts = this.valuesSource.getAggregateMetricValues(aggCtx.getLeafReaderContext(), AggregateDoubleMetricFieldMapper.Metric.value_count);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, this.sums){

            public void collect(int doc, long bucket) throws IOException {
                AggregateMetricBackedAvgAggregator.this.sums = bigArrays.grow(AggregateMetricBackedAvgAggregator.this.sums, bucket + 1L);
                AggregateMetricBackedAvgAggregator.this.compensations = bigArrays.grow(AggregateMetricBackedAvgAggregator.this.compensations, bucket + 1L);
                if (aggregateSums.advanceExact(doc)) {
                    double sum = AggregateMetricBackedAvgAggregator.this.sums.get(bucket);
                    double compensation = AggregateMetricBackedAvgAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < aggregateSums.docValueCount(); ++i) {
                        double value = aggregateSums.nextValue();
                        kahanSummation.add(value);
                    }
                    AggregateMetricBackedAvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    AggregateMetricBackedAvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
                AggregateMetricBackedAvgAggregator.this.counts = bigArrays.grow(AggregateMetricBackedAvgAggregator.this.counts, bucket + 1L);
                if (aggregateValueCounts.advanceExact(doc)) {
                    for (int i = 0; i < aggregateValueCounts.docValueCount(); ++i) {
                        double d = aggregateValueCounts.nextValue();
                        long value = Double.valueOf(d).longValue();
                        AggregateMetricBackedAvgAggregator.this.counts.increment(bucket, value);
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.sums, this.compensations});
    }
}

