/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.objectweb.asm.commons.Method;

public class ScriptClassInfo {
    private final Class<?> baseClass;
    private final Method executeMethod;
    private final Class<?> executeMethodReturnType;
    private final List<MethodArgument> executeArguments;
    private final List<Method> needsMethods;
    private final List<Method> getMethods;
    private final List<Class<?>> getReturns;
    public final List<FunctionTable.LocalFunction> converters;
    public final FunctionTable.LocalFunction defConverter;

    public ScriptClassInfo(PainlessLookup painlessLookup, Class<?> baseClass) {
        Class<?>[] types;
        this.baseClass = baseClass;
        java.lang.reflect.Method executeMethod = null;
        ArrayList<Method> needsMethods = new ArrayList<Method>();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        ArrayList getReturns = new ArrayList();
        Class<?> returnType = null;
        for (java.lang.reflect.Method m : baseClass.getMethods()) {
            if (m.isDefault()) continue;
            if (m.getName().equals("execute")) {
                if (executeMethod == null) {
                    executeMethod = m;
                    returnType = m.getReturnType();
                    continue;
                }
                throw new IllegalArgumentException("Painless can only implement interfaces that have a single method named [execute] but [" + baseClass.getName() + "] has more than one.");
            }
            if (m.getName().startsWith("needs") && m.getReturnType() == Boolean.TYPE && m.getParameterTypes().length == 0) {
                needsMethods.add(new Method(m.getName(), WriterConstants.NEEDS_PARAMETER_METHOD_TYPE.toMethodDescriptorString()));
                continue;
            }
            if (!m.getName().startsWith("get") || m.getName().equals("getClass") || Modifier.isStatic(m.getModifiers())) continue;
            getReturns.add(ScriptClassInfo.definitionTypeForClass(painlessLookup, m.getReturnType(), componentType -> "[" + m.getName() + "] has unknown return type [" + componentType.getName() + "]. Painless can only support getters with return types that are whitelisted."));
            getMethods.add(new Method(m.getName(), MethodType.methodType(m.getReturnType()).toMethodDescriptorString()));
        }
        if (executeMethod == null) {
            throw new IllegalStateException("no execute method found");
        }
        ArrayList<FunctionTable.LocalFunction> converters = new ArrayList<FunctionTable.LocalFunction>();
        FunctionTable.LocalFunction defConverter = null;
        for (java.lang.reflect.Method m : baseClass.getMethods()) {
            if (!m.getName().startsWith("convertFrom") || m.getParameterTypes().length != 1 || m.getReturnType() != returnType || !Modifier.isStatic(m.getModifiers())) continue;
            if (m.getName().equals("convertFromDef")) {
                if (m.getParameterTypes()[0] != Object.class) {
                    throw new IllegalStateException("convertFromDef must take a single Object as an argument, not [" + m.getParameterTypes()[0] + "]");
                }
                defConverter = new FunctionTable.LocalFunction(m.getName(), m.getReturnType(), List.of(m.getParameterTypes()), true, true);
                continue;
            }
            converters.add(new FunctionTable.LocalFunction(m.getName(), m.getReturnType(), List.of(m.getParameterTypes()), true, true));
        }
        this.defConverter = defConverter;
        this.converters = Collections.unmodifiableList(converters);
        MethodType methodType = MethodType.methodType(executeMethod.getReturnType(), executeMethod.getParameterTypes());
        this.executeMethod = new Method(executeMethod.getName(), methodType.toMethodDescriptorString());
        this.executeMethodReturnType = ScriptClassInfo.definitionTypeForClass(painlessLookup, executeMethod.getReturnType(), componentType -> "Painless can only implement execute methods returning a whitelisted type but [" + baseClass.getName() + "#execute] returns [" + componentType.getName() + "] which isn't whitelisted.");
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        String[] argumentNamesConstant = ScriptClassInfo.readArgumentNamesConstant(baseClass);
        if (argumentNamesConstant.length != (types = executeMethod.getParameterTypes()).length) {
            throw new IllegalArgumentException("[" + baseClass.getName() + "#ARGUMENTS] has length [2] but [" + baseClass.getName() + "#execute] takes [1] argument.");
        }
        for (int arg = 0; arg < types.length; ++arg) {
            arguments.add(this.methodArgument(painlessLookup, types[arg], argumentNamesConstant[arg]));
        }
        this.executeArguments = Collections.unmodifiableList(arguments);
        this.needsMethods = Collections.unmodifiableList(needsMethods);
        this.getMethods = Collections.unmodifiableList(getMethods);
        this.getReturns = Collections.unmodifiableList(getReturns);
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public Method getExecuteMethod() {
        return this.executeMethod;
    }

    public Class<?> getExecuteMethodReturnType() {
        return this.executeMethodReturnType;
    }

    public List<MethodArgument> getExecuteArguments() {
        return this.executeArguments;
    }

    public List<Method> getNeedsMethods() {
        return this.needsMethods;
    }

    public List<Method> getGetMethods() {
        return this.getMethods;
    }

    public List<Class<?>> getGetReturns() {
        return this.getReturns;
    }

    private MethodArgument methodArgument(PainlessLookup painlessLookup, Class<?> clazz, String argName) {
        Class<?> defClass = ScriptClassInfo.definitionTypeForClass(painlessLookup, clazz, componentType -> "[" + argName + "] is of unknown type [" + componentType.getName() + ". Painless interfaces can only accept arguments that are of whitelisted types.");
        return new MethodArgument(defClass, argName);
    }

    private static Class<?> definitionTypeForClass(PainlessLookup painlessLookup, Class<?> type, Function<Class<?>, String> unknownErrorMessageSource) {
        Class<?> componentType = type = PainlessLookupUtility.javaTypeToType(type);
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        if (componentType != def.class && painlessLookup.lookupPainlessClass(componentType) == null) {
            throw new IllegalArgumentException(unknownErrorMessageSource.apply(componentType));
        }
        return type;
    }

    private static String[] readArgumentNamesConstant(Class<?> iface) {
        Field argumentNamesField;
        try {
            argumentNamesField = iface.getField("PARAMETERS");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Painless needs a constant [String[] PARAMETERS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.", e);
        }
        if (!argumentNamesField.getType().equals(String[].class)) {
            throw new IllegalArgumentException("Painless needs a constant [String[] PARAMETERS] on all interfaces it implements with the names of the method arguments but [" + iface.getName() + "] doesn't have one.");
        }
        try {
            return (String[])argumentNamesField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error trying to read [" + iface.getName() + "#ARGUMENTS]", e);
        }
    }

    public record MethodArgument(Class<?> clazz, String name) {
    }
}

