/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.LambdaBootstrap;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.PainlessScript;
import org.elasticsearch.painless.Utility;
import org.elasticsearch.painless.api.ValueIterator;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class WriterConstants {
    public static final int CLASS_VERSION = 52;
    public static final int ASM_VERSION = 327680;
    public static final String BASE_INTERFACE_NAME = PainlessScript.class.getName();
    public static final Type BASE_INTERFACE_TYPE = Type.getType(PainlessScript.class);
    public static final String CLASS_NAME = BASE_INTERFACE_NAME + "$Script";
    public static final Type CLASS_TYPE = Type.getObjectType((String)CLASS_NAME.replace('.', '/'));
    public static final String CTOR_METHOD_NAME = "<init>";
    public static final Method CLINIT = WriterConstants.getAsmMethod(Void.TYPE, "<clinit>", new Class[0]);
    public static final Type PAINLESS_ERROR_TYPE = Type.getType(PainlessError.class);
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final MethodType NEEDS_PARAMETER_METHOD_TYPE = MethodType.methodType(Boolean.TYPE);
    public static final Type ITERATOR_TYPE = Type.getType(Iterator.class);
    public static final Type VALUE_ITERATOR_TYPE = Type.getType(ValueIterator.class);
    public static final Method ITERATOR_HASNEXT = WriterConstants.getAsmMethod(Boolean.TYPE, "hasNext", new Class[0]);
    public static final Method ITERATOR_NEXT = WriterConstants.getAsmMethod(Object.class, "next", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_BOOLEAN = WriterConstants.getAsmMethod(Boolean.TYPE, "nextBoolean", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_BYTE = WriterConstants.getAsmMethod(Byte.TYPE, "nextByte", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_SHORT = WriterConstants.getAsmMethod(Short.TYPE, "nextShort", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_CHAR = WriterConstants.getAsmMethod(Character.TYPE, "nextChar", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_INT = WriterConstants.getAsmMethod(Integer.TYPE, "nextInt", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_LONG = WriterConstants.getAsmMethod(Long.TYPE, "nextLong", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_FLOAT = WriterConstants.getAsmMethod(Float.TYPE, "nextFloat", new Class[0]);
    public static final Method VALUE_ITERATOR_NEXT_DOUBLE = WriterConstants.getAsmMethod(Double.TYPE, "nextDouble", new Class[0]);
    public static final Type UTILITY_TYPE = Type.getType(Utility.class);
    public static final Method STRING_TO_CHAR = WriterConstants.getAsmMethod(Character.TYPE, "StringTochar", String.class);
    public static final Method CHAR_TO_STRING = WriterConstants.getAsmMethod(String.class, "charToString", Character.TYPE);
    public static final Method PATTERN_COMPILE = WriterConstants.getAsmMethod(Pattern.class, "compile", String.class, Integer.TYPE);
    public static final Method PATTERN_MATCHER = WriterConstants.getAsmMethod(Matcher.class, "matcher", Pattern.class, Integer.TYPE, CharSequence.class);
    public static final Method MATCHER_MATCHES = WriterConstants.getAsmMethod(Boolean.TYPE, "matches", new Class[0]);
    public static final Method MATCHER_FIND = WriterConstants.getAsmMethod(Boolean.TYPE, "find", new Class[0]);
    public static final Method DEF_BOOTSTRAP_METHOD = WriterConstants.getAsmMethod(CallSite.class, "$bootstrapDef", MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class);
    static final Handle DEF_BOOTSTRAP_HANDLE = new Handle(6, CLASS_TYPE.getInternalName(), "$bootstrapDef", DEF_BOOTSTRAP_METHOD.getDescriptor(), false);
    public static final Type DEF_UTIL_TYPE = Type.getType(Def.class);
    public static final Method DEF_TO_P_BOOLEAN = WriterConstants.getAsmMethod(Boolean.TYPE, "defToboolean", Object.class);
    public static final Method DEF_TO_P_BYTE_IMPLICIT = WriterConstants.getAsmMethod(Byte.TYPE, "defTobyteImplicit", Object.class);
    public static final Method DEF_TO_P_SHORT_IMPLICIT = WriterConstants.getAsmMethod(Short.TYPE, "defToshortImplicit", Object.class);
    public static final Method DEF_TO_P_CHAR_IMPLICIT = WriterConstants.getAsmMethod(Character.TYPE, "defTocharImplicit", Object.class);
    public static final Method DEF_TO_P_INT_IMPLICIT = WriterConstants.getAsmMethod(Integer.TYPE, "defTointImplicit", Object.class);
    public static final Method DEF_TO_P_LONG_IMPLICIT = WriterConstants.getAsmMethod(Long.TYPE, "defTolongImplicit", Object.class);
    public static final Method DEF_TO_P_FLOAT_IMPLICIT = WriterConstants.getAsmMethod(Float.TYPE, "defTofloatImplicit", Object.class);
    public static final Method DEF_TO_P_DOUBLE_IMPLICIT = WriterConstants.getAsmMethod(Double.TYPE, "defTodoubleImplicit", Object.class);
    public static final Method DEF_TO_P_BYTE_EXPLICIT = WriterConstants.getAsmMethod(Byte.TYPE, "defTobyteExplicit", Object.class);
    public static final Method DEF_TO_P_SHORT_EXPLICIT = WriterConstants.getAsmMethod(Short.TYPE, "defToshortExplicit", Object.class);
    public static final Method DEF_TO_P_CHAR_EXPLICIT = WriterConstants.getAsmMethod(Character.TYPE, "defTocharExplicit", Object.class);
    public static final Method DEF_TO_P_INT_EXPLICIT = WriterConstants.getAsmMethod(Integer.TYPE, "defTointExplicit", Object.class);
    public static final Method DEF_TO_P_LONG_EXPLICIT = WriterConstants.getAsmMethod(Long.TYPE, "defTolongExplicit", Object.class);
    public static final Method DEF_TO_P_FLOAT_EXPLICIT = WriterConstants.getAsmMethod(Float.TYPE, "defTofloatExplicit", Object.class);
    public static final Method DEF_TO_P_DOUBLE_EXPLICIT = WriterConstants.getAsmMethod(Double.TYPE, "defTodoubleExplicit", Object.class);
    public static final Method DEF_TO_B_BOOLEAN = WriterConstants.getAsmMethod(Boolean.class, "defToBoolean", Object.class);
    public static final Method DEF_TO_B_BYTE_IMPLICIT = WriterConstants.getAsmMethod(Byte.class, "defToByteImplicit", Object.class);
    public static final Method DEF_TO_B_SHORT_IMPLICIT = WriterConstants.getAsmMethod(Short.class, "defToShortImplicit", Object.class);
    public static final Method DEF_TO_B_CHARACTER_IMPLICIT = WriterConstants.getAsmMethod(Character.class, "defToCharacterImplicit", Object.class);
    public static final Method DEF_TO_B_INTEGER_IMPLICIT = WriterConstants.getAsmMethod(Integer.class, "defToIntegerImplicit", Object.class);
    public static final Method DEF_TO_B_LONG_IMPLICIT = WriterConstants.getAsmMethod(Long.class, "defToLongImplicit", Object.class);
    public static final Method DEF_TO_B_FLOAT_IMPLICIT = WriterConstants.getAsmMethod(Float.class, "defToFloatImplicit", Object.class);
    public static final Method DEF_TO_B_DOUBLE_IMPLICIT = WriterConstants.getAsmMethod(Double.class, "defToDoubleImplicit", Object.class);
    public static final Method DEF_TO_B_BYTE_EXPLICIT = WriterConstants.getAsmMethod(Byte.class, "defToByteExplicit", Object.class);
    public static final Method DEF_TO_B_SHORT_EXPLICIT = WriterConstants.getAsmMethod(Short.class, "defToShortExplicit", Object.class);
    public static final Method DEF_TO_B_CHARACTER_EXPLICIT = WriterConstants.getAsmMethod(Character.class, "defToCharacterExplicit", Object.class);
    public static final Method DEF_TO_B_INTEGER_EXPLICIT = WriterConstants.getAsmMethod(Integer.class, "defToIntegerExplicit", Object.class);
    public static final Method DEF_TO_B_LONG_EXPLICIT = WriterConstants.getAsmMethod(Long.class, "defToLongExplicit", Object.class);
    public static final Method DEF_TO_B_FLOAT_EXPLICIT = WriterConstants.getAsmMethod(Float.class, "defToFloatExplicit", Object.class);
    public static final Method DEF_TO_B_DOUBLE_EXPLICIT = WriterConstants.getAsmMethod(Double.class, "defToDoubleExplicit", Object.class);
    public static final Method DEF_TO_STRING_IMPLICIT = WriterConstants.getAsmMethod(String.class, "defToStringImplicit", Object.class);
    public static final Method DEF_TO_STRING_EXPLICIT = WriterConstants.getAsmMethod(String.class, "defToStringExplicit", Object.class);
    public static final MethodType LAMBDA_BOOTSTRAP_TYPE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, String.class, Integer.TYPE, String.class, MethodType.class, Integer.TYPE, Integer.TYPE, Object[].class);
    public static final Handle LAMBDA_BOOTSTRAP_HANDLE = new Handle(6, Type.getInternalName(LambdaBootstrap.class), "lambdaBootstrap", LAMBDA_BOOTSTRAP_TYPE.toMethodDescriptorString(), false);
    public static final MethodType DELEGATE_BOOTSTRAP_TYPE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodHandle.class, Integer.TYPE, Object[].class);
    public static final Handle DELEGATE_BOOTSTRAP_HANDLE = new Handle(6, Type.getInternalName(LambdaBootstrap.class), "delegateBootstrap", DELEGATE_BOOTSTRAP_TYPE.toMethodDescriptorString(), false);
    public static final MethodType MAKE_CONCAT_TYPE = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final Handle STRING_CONCAT_BOOTSTRAP_HANDLE = new Handle(6, Type.getInternalName(StringConcatFactory.class), "makeConcat", MAKE_CONCAT_TYPE.toMethodDescriptorString(), false);
    public static final int MAX_STRING_CONCAT_ARGS = 200;
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type OBJECTS_TYPE = Type.getType(Objects.class);
    public static final Method EQUALS = WriterConstants.getAsmMethod(Boolean.TYPE, "equals", Object.class, Object.class);
    public static final Type COLLECTION_TYPE = Type.getType(Collection.class);
    public static final Method COLLECTION_SIZE = WriterConstants.getAsmMethod(Integer.TYPE, "size", new Class[0]);

    private static Method getAsmMethod(Class<?> rtype, String name, Class<?> ... ptypes) {
        return new Method(name, MethodType.methodType(rtype, ptypes).toMethodDescriptorString());
    }

    private WriterConstants() {
    }
}

