/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.Def;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessClassBuilder;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistClass;
import org.elasticsearch.painless.spi.WhitelistClassBinding;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistInstanceBinding;
import org.elasticsearch.painless.spi.WhitelistMethod;
import org.elasticsearch.painless.spi.annotation.AliasAnnotation;
import org.elasticsearch.painless.spi.annotation.AugmentedAnnotation;
import org.elasticsearch.painless.spi.annotation.CompileTimeOnlyAnnotation;
import org.elasticsearch.painless.spi.annotation.InjectConstantAnnotation;
import org.elasticsearch.painless.spi.annotation.NoImportAnnotation;

public final class PainlessLookupBuilder {
    private static final Map<PainlessConstructor, PainlessConstructor> painlessConstructorCache = new HashMap<PainlessConstructor, PainlessConstructor>();
    private static final Map<PainlessMethod, PainlessMethod> painlessMethodCache = new HashMap<PainlessMethod, PainlessMethod>();
    private static final Map<PainlessField, PainlessField> painlessFieldCache = new HashMap<PainlessField, PainlessField>();
    private static final Map<PainlessClassBinding, PainlessClassBinding> painlessClassBindingCache = new HashMap<PainlessClassBinding, PainlessClassBinding>();
    private static final Map<PainlessInstanceBinding, PainlessInstanceBinding> painlessInstanceBindingCache = new HashMap<PainlessInstanceBinding, PainlessInstanceBinding>();
    private static final Map<PainlessMethod, PainlessMethod> painlessFilteredCache = new HashMap<PainlessMethod, PainlessMethod>();
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][._a-zA-Z0-9]*$");
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private final Map<String, Class<?>> javaClassNamesToClasses = new HashMap();
    private final Map<String, Class<?>> canonicalClassNamesToClasses = new HashMap();
    private final Map<Class<?>, PainlessClassBuilder> classesToPainlessClassBuilders = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> classesToDirectSubClasses = new HashMap();
    private final Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods = new HashMap<String, PainlessMethod>();
    private final Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings = new HashMap<String, PainlessClassBinding>();
    private final Map<String, PainlessInstanceBinding> painlessMethodKeysToPainlessInstanceBindings = new HashMap<String, PainlessInstanceBinding>();

    public static PainlessLookup buildFromWhitelists(List<Whitelist> whitelists) {
        PainlessLookupBuilder painlessLookupBuilder = new PainlessLookupBuilder();
        String origin = "internal error";
        try {
            for (Whitelist whitelist : whitelists) {
                for (WhitelistClass whitelistClass : whitelist.whitelistClasses) {
                    origin = whitelistClass.origin;
                    painlessLookupBuilder.addPainlessClass(whitelist.classLoader, whitelistClass.javaClassName, whitelistClass.painlessAnnotations);
                }
            }
            for (Whitelist whitelist : whitelists) {
                for (WhitelistClass whitelistClass : whitelist.whitelistClasses) {
                    String targetCanonicalClassName = whitelistClass.javaClassName.replace('$', '.');
                    for (WhitelistConstructor whitelistConstructor : whitelistClass.whitelistConstructors) {
                        origin = whitelistConstructor.origin;
                        painlessLookupBuilder.addPainlessConstructor(targetCanonicalClassName, whitelistConstructor.canonicalTypeNameParameters, whitelistConstructor.painlessAnnotations);
                    }
                    for (WhitelistMethod whitelistMethod : whitelistClass.whitelistMethods) {
                        origin = whitelistMethod.origin;
                        painlessLookupBuilder.addPainlessMethod(whitelist.classLoader, targetCanonicalClassName, whitelistMethod.augmentedCanonicalClassName, whitelistMethod.methodName, whitelistMethod.returnCanonicalTypeName, whitelistMethod.canonicalTypeNameParameters, whitelistMethod.painlessAnnotations);
                    }
                    for (WhitelistField whitelistField : whitelistClass.whitelistFields) {
                        origin = whitelistField.origin;
                        painlessLookupBuilder.addPainlessField(whitelist.classLoader, targetCanonicalClassName, whitelistField.fieldName, whitelistField.canonicalTypeNameParameter, whitelistField.painlessAnnotations);
                    }
                }
                for (WhitelistMethod whitelistStatic : whitelist.whitelistImportedMethods) {
                    origin = whitelistStatic.origin;
                    painlessLookupBuilder.addImportedPainlessMethod(whitelist.classLoader, whitelistStatic.augmentedCanonicalClassName, whitelistStatic.methodName, whitelistStatic.returnCanonicalTypeName, whitelistStatic.canonicalTypeNameParameters, whitelistStatic.painlessAnnotations);
                }
                for (WhitelistClassBinding whitelistClassBinding : whitelist.whitelistClassBindings) {
                    origin = whitelistClassBinding.origin;
                    painlessLookupBuilder.addPainlessClassBinding(whitelist.classLoader, whitelistClassBinding.targetJavaClassName, whitelistClassBinding.methodName, whitelistClassBinding.returnCanonicalTypeName, whitelistClassBinding.canonicalTypeNameParameters, whitelistClassBinding.painlessAnnotations);
                }
                for (WhitelistInstanceBinding whitelistInstanceBinding : whitelist.whitelistInstanceBindings) {
                    origin = whitelistInstanceBinding.origin;
                    painlessLookupBuilder.addPainlessInstanceBinding(whitelistInstanceBinding.targetInstance, whitelistInstanceBinding.methodName, whitelistInstanceBinding.returnCanonicalTypeName, whitelistInstanceBinding.canonicalTypeNameParameters, whitelistInstanceBinding.painlessAnnotations);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("error loading whitelist(s) " + origin, exception);
        }
        return painlessLookupBuilder.build();
    }

    private Class<?> canonicalTypeNameToType(String canonicalTypeName) {
        return PainlessLookupUtility.canonicalTypeNameToType(canonicalTypeName, this.canonicalClassNamesToClasses);
    }

    private boolean isValidType(Class<?> type) {
        while (type.getComponentType() != null) {
            type = type.getComponentType();
        }
        return type == def.class || this.classesToPainlessClassBuilders.containsKey(type);
    }

    private Class<?> loadClass(ClassLoader classLoader, String javaClassName, Supplier<String> errorMessage) {
        try {
            return Class.forName(javaClassName, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName(javaClassName);
            }
            catch (ClassNotFoundException cnfe2) {
                IllegalArgumentException iae = new IllegalArgumentException(errorMessage.get(), cnfe2);
                cnfe2.addSuppressed(cnfe);
                throw iae;
            }
        }
    }

    private static MethodHandles.Lookup lookup(Class<?> targetClass) {
        if (targetClass.getModule() == PainlessLookupBuilder.class.getModule()) {
            MethodHandles.Lookup l = MethodHandles.lookup().dropLookupMode(8);
            assert (l.lookupModes() == 17) : "lookup modes:" + Integer.toHexString(l.lookupModes());
            return l;
        }
        return MethodHandles.publicLookup().in(targetClass);
    }

    public void addPainlessClass(ClassLoader classLoader, String javaClassName, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(javaClassName);
        Class<Object> clazz = "void".equals(javaClassName) ? Void.TYPE : ("boolean".equals(javaClassName) ? Boolean.TYPE : ("byte".equals(javaClassName) ? Byte.TYPE : ("short".equals(javaClassName) ? Short.TYPE : ("char".equals(javaClassName) ? Character.TYPE : ("int".equals(javaClassName) ? Integer.TYPE : ("long".equals(javaClassName) ? Long.TYPE : ("float".equals(javaClassName) ? Float.TYPE : ("double".equals(javaClassName) ? Double.TYPE : this.loadClass(classLoader, javaClassName, () -> "class [" + javaClassName + "] not found")))))))));
        this.addPainlessClass(clazz, annotations);
    }

    private static IllegalArgumentException lookupException(String formatText, Object ... args) {
        return new IllegalArgumentException(Strings.format((String)formatText, (Object[])args));
    }

    private static IllegalArgumentException lookupException(Throwable cause, String formatText, Object ... args) {
        return new IllegalArgumentException(Strings.format((String)formatText, (Object[])args), cause);
    }

    public void addPainlessClass(Class<?> clazz, Map<Class<?>, Object> annotations) {
        boolean importClassName;
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(annotations);
        if (clazz == def.class) {
            throw new IllegalArgumentException("cannot add reserved class [def]");
        }
        String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(clazz);
        if (clazz.isArray()) {
            throw new IllegalArgumentException("cannot add array type [" + canonicalClassName + "] as a class");
        }
        if (!CLASS_NAME_PATTERN.matcher(canonicalClassName).matches()) {
            throw new IllegalArgumentException("invalid class name [" + canonicalClassName + "]");
        }
        Class<?> existingClass = this.javaClassNamesToClasses.get(clazz.getName());
        if (existingClass == null) {
            this.javaClassNamesToClasses.put(clazz.getName().intern(), clazz);
        } else if (existingClass != clazz) {
            throw PainlessLookupBuilder.lookupException("class [%s] cannot represent multiple java classes with the same name from different class loaders", canonicalClassName);
        }
        existingClass = this.canonicalClassNamesToClasses.get(canonicalClassName);
        if (existingClass != null && existingClass != clazz) {
            throw PainlessLookupBuilder.lookupException("class [%s] cannot represent multiple java classes with the same name from different class loaders", canonicalClassName);
        }
        PainlessClassBuilder existingPainlessClassBuilder = this.classesToPainlessClassBuilders.get(clazz);
        if (existingPainlessClassBuilder == null) {
            PainlessClassBuilder painlessClassBuilder = new PainlessClassBuilder();
            painlessClassBuilder.annotations.putAll(annotations);
            this.canonicalClassNamesToClasses.put(canonicalClassName.intern(), clazz);
            this.classesToPainlessClassBuilders.put(clazz, painlessClassBuilder);
        }
        String javaClassName = clazz.getName();
        String importedCanonicalClassName = javaClassName.substring(javaClassName.lastIndexOf(46) + 1).replace('$', '.');
        boolean bl = importClassName = !annotations.containsKey(NoImportAnnotation.class);
        if (canonicalClassName.equals(importedCanonicalClassName)) {
            if (importClassName) {
                throw new IllegalArgumentException("must use no_import parameter on class [" + canonicalClassName + "] with no package");
            }
        } else {
            Class<?> importedClass = this.canonicalClassNamesToClasses.get(importedCanonicalClassName);
            if (importedClass == null) {
                if (importClassName) {
                    AliasAnnotation alias;
                    Class<?> existing;
                    if (existingPainlessClassBuilder != null) {
                        throw new IllegalArgumentException("inconsistent no_import parameter found for class [" + canonicalClassName + "]");
                    }
                    this.canonicalClassNamesToClasses.put(importedCanonicalClassName.intern(), clazz);
                    Object object = annotations.get(AliasAnnotation.class);
                    if (object instanceof AliasAnnotation && (existing = this.canonicalClassNamesToClasses.put((alias = (AliasAnnotation)object).alias(), clazz)) != null) {
                        throw PainlessLookupBuilder.lookupException("Cannot add alias [%s] for [%s] that shadows class [%s]", alias.alias(), clazz, existing);
                    }
                }
            } else {
                if (importedClass != clazz) {
                    throw PainlessLookupBuilder.lookupException("imported class [%s] cannot represent multiple classes [%s] and [%s]", importedCanonicalClassName, canonicalClassName, PainlessLookupUtility.typeToCanonicalTypeName(importedClass));
                }
                if (!importClassName) {
                    throw new IllegalArgumentException("inconsistent no_import parameter found for class [" + canonicalClassName + "]");
                }
            }
        }
    }

    public void addPainlessConstructor(String targetCanonicalClassName, List<String> canonicalTypeNameParameters, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for constructor [[%s], %s]", targetCanonicalClassName, targetCanonicalClassName, canonicalTypeNameParameters);
        }
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for constructor [[%s], %s]", canonicalTypeNameParameter, targetCanonicalClassName, canonicalTypeNameParameters);
            }
            typeParameters.add(typeParameter);
        }
        this.addPainlessConstructor(targetClass, typeParameters, annotations);
    }

    public void addPainlessConstructor(Class<?> targetClass, List<Class<?>> typeParameters, Map<Class<?>, Object> annotations) {
        MethodHandle methodHandle;
        Constructor<?> javaConstructor;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add constructor to reserved class [def]");
        }
        String targetCanonicalClassName = targetClass.getCanonicalName();
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for constructor [[%s], %s]", targetCanonicalClassName, targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for constructor [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        try {
            javaConstructor = targetClass.getConstructor((Class[])javaTypeParameters.toArray(Class[]::new));
        }
        catch (NoSuchMethodException nsme) {
            throw PainlessLookupBuilder.lookupException(nsme, "reflection object not found for constructor [[%s], %s]", targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        try {
            methodHandle = PainlessLookupBuilder.lookup(targetClass).unreflectConstructor(javaConstructor);
        }
        catch (IllegalAccessException iae) {
            throw PainlessLookupBuilder.lookupException(iae, "method handle not found for constructor [[%s], %s]", targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (annotations.containsKey(CompileTimeOnlyAnnotation.class)) {
            throw new IllegalArgumentException("constructors can't have @compile_time_only");
        }
        MethodType methodType = methodHandle.type();
        String painlessConstructorKey = PainlessLookupUtility.buildPainlessConstructorKey(typeParametersSize);
        PainlessConstructor existingPainlessConstructor = painlessClassBuilder.constructors.get(painlessConstructorKey);
        PainlessConstructor newPainlessConstructor = new PainlessConstructor(javaConstructor, typeParameters, methodHandle, methodType, annotations);
        if (existingPainlessConstructor == null) {
            newPainlessConstructor = painlessConstructorCache.computeIfAbsent(newPainlessConstructor, Function.identity());
            painlessClassBuilder.constructors.put(painlessConstructorKey.intern(), newPainlessConstructor);
        } else if (!newPainlessConstructor.equals(existingPainlessConstructor)) {
            throw PainlessLookupBuilder.lookupException("cannot add constructors with the same arity but are not equivalent for constructors [[%s], %s] and [[%s], %s]", targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessConstructor.typeParameters()));
        }
    }

    public void addPainlessMethod(ClassLoader classLoader, String targetCanonicalClassName, String augmentedCanonicalClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Objects.requireNonNull(annotations);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for method [[%s], [%s], %s]", targetCanonicalClassName, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
        }
        Class<?> augmentedClass = null;
        if (augmentedCanonicalClassName != null) {
            augmentedClass = this.loadClass(classLoader, augmentedCanonicalClassName, () -> Strings.format((String)"augmented class [%s] not found for method [[%s], [%s], %s]", (Object[])new Object[]{augmentedCanonicalClassName, targetCanonicalClassName, methodName, canonicalTypeNameParameters}));
        }
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for method [[%s], [%s], %s]", canonicalTypeNameParameter, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for method [[%s], [%s], %s]", returnCanonicalTypeName, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
        }
        this.addPainlessMethod(targetClass, augmentedClass, methodName, returnType, typeParameters, annotations);
    }

    public void addPainlessMethod(Class<?> targetClass, Class<?> augmentedClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters, Map<Class<?>, Object> annotations) {
        MethodHandle methodHandle;
        Method javaMethod;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        Objects.requireNonNull(annotations);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add method to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for method [[%s], [%s], %s]", targetCanonicalClassName, targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        int typeParametersSize = typeParameters.size();
        int augmentedParameterOffset = augmentedClass == null ? 0 : 1;
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize + augmentedParameterOffset);
        if (augmentedClass != null) {
            javaTypeParameters.add(targetClass);
        }
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        if (!this.isValidType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (augmentedClass == null) {
            try {
                javaMethod = targetClass.getMethod(methodName, (Class[])javaTypeParameters.toArray(Class[]::new));
            }
            catch (NoSuchMethodException nsme) {
                throw PainlessLookupBuilder.lookupException(nsme, "reflection object not found for method [[%s], [%s], %s]", targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
        }
        try {
            javaMethod = augmentedClass.getMethod(methodName, (Class[])javaTypeParameters.toArray(Class[]::new));
            if (!Modifier.isStatic(javaMethod.getModifiers())) {
                throw PainlessLookupBuilder.lookupException("method [[%s], [%s], %s] with augmented class [%s] must be static", targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass));
            }
        }
        catch (NoSuchMethodException nsme) {
            throw PainlessLookupBuilder.lookupException(nsme, "reflection object not found for method [[%s], [%s], %s] with augmented class [%s]", targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass));
        }
        InjectConstantAnnotation inject = (InjectConstantAnnotation)annotations.get(InjectConstantAnnotation.class);
        if (inject != null) {
            int numInjections = inject.injects().size();
            if (numInjections > 0) {
                typeParameters.subList(0, numInjections).clear();
            }
            typeParametersSize = typeParameters.size();
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] does not match the specified returned type [%s] for method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()), PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (augmentedClass == null) {
            try {
                methodHandle = PainlessLookupBuilder.lookup(targetClass).unreflect(javaMethod);
            }
            catch (IllegalAccessException iae) {
                throw PainlessLookupBuilder.lookupException(iae, "method handle not found for method [[%s], [%s], %s], with lookup [%s]", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), PainlessLookupBuilder.lookup(targetClass));
            }
        }
        try {
            methodHandle = PainlessLookupBuilder.lookup(augmentedClass).unreflect(javaMethod);
        }
        catch (IllegalAccessException iae) {
            throw PainlessLookupBuilder.lookupException(iae, "method handle not found for method [[%s], [%s], %s] with augmented class [%s]", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass));
        }
        if (annotations.containsKey(CompileTimeOnlyAnnotation.class)) {
            throw new IllegalArgumentException("regular methods can't have @compile_time_only");
        }
        MethodType methodType = methodHandle.type();
        boolean isStatic = augmentedClass == null && Modifier.isStatic(javaMethod.getModifiers());
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        PainlessMethod existingPainlessMethod = isStatic ? painlessClassBuilder.staticMethods.get(painlessMethodKey) : painlessClassBuilder.methods.get(painlessMethodKey);
        PainlessMethod newPainlessMethod = new PainlessMethod(javaMethod, targetClass, returnType, typeParameters, methodHandle, methodType, annotations);
        if (existingPainlessMethod == null) {
            newPainlessMethod = painlessMethodCache.computeIfAbsent(newPainlessMethod, key -> key);
            if (isStatic) {
                painlessClassBuilder.staticMethods.put(painlessMethodKey.intern(), newPainlessMethod);
            } else {
                painlessClassBuilder.methods.put(painlessMethodKey.intern(), newPainlessMethod);
            }
        } else if (!newPainlessMethod.equals(existingPainlessMethod)) {
            throw PainlessLookupBuilder.lookupException("cannot add methods with the same name and arity but are not equivalent for methods [[%s], [%s], [%s], %s] and [[%s], [%s], [%s], %s]", targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(returnType), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessMethod.returnType()), PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessMethod.typeParameters()));
        }
    }

    public void addPainlessField(ClassLoader classLoader, String targetCanonicalClassName, String fieldName, String canonicalTypeNameParameter, Map<Class<?>, Object> annotations) {
        Class<?> typeParameter;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(canonicalTypeNameParameter);
        Objects.requireNonNull(annotations);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for field [[%s], [%s], [%s]]", targetCanonicalClassName, targetCanonicalClassName, fieldName, canonicalTypeNameParameter);
        }
        String augmentedCanonicalClassName = annotations.containsKey(AugmentedAnnotation.class) ? ((AugmentedAnnotation)annotations.get(AugmentedAnnotation.class)).augmentedCanonicalClassName() : null;
        Class<?> augmentedClass = null;
        if (augmentedCanonicalClassName != null) {
            augmentedClass = this.loadClass(classLoader, augmentedCanonicalClassName, () -> Strings.format((String)"augmented class [%s] not found for field [[%s], [%s]]", (Object[])new Object[]{augmentedCanonicalClassName, targetCanonicalClassName, fieldName}));
        }
        if ((typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter)) == null) {
            throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for field [[%s], [%s]]", canonicalTypeNameParameter, targetCanonicalClassName, fieldName);
        }
        this.addPainlessField(targetClass, augmentedClass, fieldName, typeParameter, annotations);
    }

    public void addPainlessField(Class<?> targetClass, Class<?> augmentedClass, String fieldName, Class<?> typeParameter, Map<Class<?>, Object> annotations) {
        MethodHandle methodHandleGetter;
        Field javaField;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(typeParameter);
        Objects.requireNonNull(annotations);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add field to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!FIELD_NAME_PATTERN.matcher(fieldName).matches()) {
            throw new IllegalArgumentException("invalid field name [" + fieldName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw PainlessLookupBuilder.lookupException("target class [%s] not found for field [[%s], [%s], [%s]]", targetCanonicalClassName, targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter));
        }
        if (!this.isValidType(typeParameter)) {
            throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for field [[%s], [%s], [%s]]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter));
        }
        if (augmentedClass == null) {
            try {
                javaField = targetClass.getField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                throw PainlessLookupBuilder.lookupException(nsfe, "reflection object not found for field [[%s], [%s], [%s]]", targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter));
            }
        }
        try {
            javaField = augmentedClass.getField(fieldName);
            if (!Modifier.isStatic(javaField.getModifiers()) || !Modifier.isFinal(javaField.getModifiers())) {
                throw PainlessLookupBuilder.lookupException("field [[%s], [%s]] with augmented class [%s] must be static and final", targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass));
            }
        }
        catch (NoSuchFieldException nsfe) {
            throw PainlessLookupBuilder.lookupException(nsfe, "reflection object not found for field [[%s], [%s], [%s]] with augmented class [%s]", targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass));
        }
        if (javaField.getType() != PainlessLookupUtility.typeToJavaType(typeParameter)) {
            throw PainlessLookupBuilder.lookupException("type parameter [%s] does not match the specified type parameter [%s] for field [[%s], [%s]]", PainlessLookupUtility.typeToCanonicalTypeName(javaField.getType()), PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, fieldName);
        }
        try {
            methodHandleGetter = MethodHandles.publicLookup().unreflectGetter(javaField);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("getter method handle not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
        }
        String painlessFieldKey = PainlessLookupUtility.buildPainlessFieldKey(fieldName);
        if (Modifier.isStatic(javaField.getModifiers())) {
            if (!Modifier.isFinal(javaField.getModifiers())) {
                throw new IllegalArgumentException("static field [[" + targetCanonicalClassName + "], [" + fieldName + "]] must be final");
            }
            PainlessField existingPainlessField = painlessClassBuilder.staticFields.get(painlessFieldKey);
            PainlessField newPainlessField = new PainlessField(javaField, typeParameter, annotations, methodHandleGetter, null);
            if (existingPainlessField == null) {
                newPainlessField = painlessFieldCache.computeIfAbsent(newPainlessField, Function.identity());
                painlessClassBuilder.staticFields.put(painlessFieldKey.intern(), newPainlessField);
            } else if (!newPainlessField.equals(existingPainlessField)) {
                throw PainlessLookupBuilder.lookupException("cannot add fields with the same name but are not equivalent for fields [[%s], [%s], [%s]] and [[%s], [%s], [%s]] with the same name and different type parameters", targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, existingPainlessField.javaField().getName(), PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessField.typeParameter()));
            }
        } else {
            MethodHandle methodHandleSetter;
            try {
                methodHandleSetter = MethodHandles.publicLookup().unreflectSetter(javaField);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("setter method handle not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
            }
            PainlessField existingPainlessField = painlessClassBuilder.fields.get(painlessFieldKey);
            PainlessField newPainlessField = new PainlessField(javaField, typeParameter, annotations, methodHandleGetter, methodHandleSetter);
            if (existingPainlessField == null) {
                newPainlessField = painlessFieldCache.computeIfAbsent(newPainlessField, key -> key);
                painlessClassBuilder.fields.put(painlessFieldKey.intern(), newPainlessField);
            } else if (!newPainlessField.equals(existingPainlessField)) {
                throw PainlessLookupBuilder.lookupException("cannot add fields with the same name but are not equivalent for fields [[%s], [%s], [%s]] and [[%s], [%s], [%s]] with the same name and different type parameters", targetCanonicalClassName, fieldName, PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, existingPainlessField.javaField().getName(), PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessField.typeParameter()));
            }
        }
    }

    public void addImportedPainlessMethod(ClassLoader classLoader, String targetJavaClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetJavaClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = this.loadClass(classLoader, targetJavaClassName, () -> "class [" + targetJavaClassName + "] not found");
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for imported method [[%s], [%s], %s]", canonicalTypeNameParameter, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for imported method [[%s], [%s], %s]", returnCanonicalTypeName, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
        }
        this.addImportedPainlessMethod(targetClass, methodName, returnType, typeParameters, annotations);
    }

    public void addImportedPainlessMethod(Class<?> targetClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters, Map<Class<?>, Object> annotations) {
        MethodHandle methodHandle;
        Method javaMethod;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add imported method from reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        Class<?> existingTargetClass = this.javaClassNamesToClasses.get(targetClass.getName());
        if (existingTargetClass == null) {
            this.javaClassNamesToClasses.put(targetClass.getName().intern(), targetClass);
        } else if (existingTargetClass != targetClass) {
            throw PainlessLookupBuilder.lookupException("class [%s] cannot represent multiple java classes with the same name from different class loaders", targetCanonicalClassName);
        }
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid imported method name [" + methodName + "] for target class [" + targetCanonicalClassName + "].");
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for imported method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        if (!this.isValidType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for imported method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        try {
            javaMethod = targetClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw PainlessLookupBuilder.lookupException(nsme, "imported method reflection object [[%s], [%s], %s] not found", targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] does not match the specified returned type [%s] for imported method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()), PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (!Modifier.isStatic(javaMethod.getModifiers())) {
            throw PainlessLookupBuilder.lookupException("imported method [[%s], [%s], %s] must be static", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        if (this.painlessMethodKeysToPainlessClassBindings.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("imported method and class binding cannot have the same name [" + methodName + "]");
        }
        if (this.painlessMethodKeysToPainlessInstanceBindings.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("imported method and instance binding cannot have the same name [" + methodName + "]");
        }
        try {
            methodHandle = PainlessLookupBuilder.lookup(targetClass).unreflect(javaMethod);
        }
        catch (IllegalAccessException iae) {
            throw PainlessLookupBuilder.lookupException(iae, "imported method handle [[%s], [%s], %s] not found", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        MethodType methodType = methodHandle.type();
        PainlessMethod existingImportedPainlessMethod = this.painlessMethodKeysToImportedPainlessMethods.get(painlessMethodKey);
        PainlessMethod newImportedPainlessMethod = new PainlessMethod(javaMethod, targetClass, returnType, typeParameters, methodHandle, methodType, annotations);
        if (existingImportedPainlessMethod == null) {
            newImportedPainlessMethod = painlessMethodCache.computeIfAbsent(newImportedPainlessMethod, key -> key);
            this.painlessMethodKeysToImportedPainlessMethods.put(painlessMethodKey.intern(), newImportedPainlessMethod);
        } else if (!newImportedPainlessMethod.equals(existingImportedPainlessMethod)) {
            throw PainlessLookupBuilder.lookupException("cannot add imported methods with the same name and arity but do not have equivalent methods [[%s], [%s], [%s], %s] and [[%s], [%s], [%s], %s]", targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(returnType), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(existingImportedPainlessMethod.returnType()), PainlessLookupUtility.typesToCanonicalTypeNames(existingImportedPainlessMethod.typeParameters()));
        }
    }

    public void addPainlessClassBinding(ClassLoader classLoader, String targetJavaClassName, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetJavaClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = this.loadClass(classLoader, targetJavaClassName, () -> "class [" + targetJavaClassName + "] not found");
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for class binding [[%s], [%s], %s]", canonicalTypeNameParameter, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for class binding [[%s], [%s], %s]", returnCanonicalTypeName, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
        }
        this.addPainlessClassBinding(targetClass, methodName, returnType, typeParameters, annotations);
    }

    public void addPainlessClassBinding(Class<?> targetClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters, Map<Class<?>, Object> annotations) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add class binding as reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        Class<?> existingTargetClass = this.javaClassNamesToClasses.get(targetClass.getName());
        if (existingTargetClass == null) {
            this.javaClassNamesToClasses.put(targetClass.getName().intern(), targetClass);
        } else if (existingTargetClass != targetClass) {
            throw PainlessLookupBuilder.lookupException("class [%s] cannot represent multiple java classes with the same name from different class loaders", targetCanonicalClassName);
        }
        Constructor<?>[] javaConstructors = targetClass.getConstructors();
        Constructor<?> javaConstructor = null;
        for (Constructor<?> eachJavaConstructor : javaConstructors) {
            if (eachJavaConstructor.getDeclaringClass() != targetClass) continue;
            if (javaConstructor != null) {
                throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] cannot have multiple constructors");
            }
            javaConstructor = eachJavaConstructor;
        }
        if (javaConstructor == null) {
            throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] must have exactly one constructor");
        }
        Class<?>[] constructorParameterTypes = javaConstructor.getParameterTypes();
        for (int typeParameterIndex = 0; typeParameterIndex < constructorParameterTypes.length; ++typeParameterIndex) {
            Class<?> typeParameter = typeParameters.get(typeParameterIndex);
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            Method[] javaTypeParameter = constructorParameterTypes[typeParameterIndex];
            if (!this.isValidType((Class<?>)javaTypeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            if (javaTypeParameter == PainlessLookupUtility.typeToJavaType(typeParameter)) continue;
            throw PainlessLookupBuilder.lookupException("type parameter [%s] does not match the specified type parameter [%s] for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaTypeParameter), PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetClass.getCanonicalName(), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for class binding [" + targetCanonicalClassName + "].");
        }
        if (annotations.containsKey(CompileTimeOnlyAnnotation.class)) {
            throw new IllegalArgumentException("class bindings can't have @compile_time_only");
        }
        Method[] javaMethods = targetClass.getMethods();
        Method javaMethod = null;
        for (Method eachJavaMethod : javaMethods) {
            if (eachJavaMethod.getDeclaringClass() != targetClass) continue;
            if (javaMethod != null) {
                throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] cannot have multiple methods");
            }
            javaMethod = eachJavaMethod;
        }
        if (javaMethod == null) {
            throw new IllegalArgumentException("class binding [" + targetCanonicalClassName + "] must have exactly one method");
        }
        Class<?>[] methodParameterTypes = javaMethod.getParameterTypes();
        for (int typeParameterIndex = 0; typeParameterIndex < methodParameterTypes.length; ++typeParameterIndex) {
            Class<?> typeParameter = typeParameters.get(constructorParameterTypes.length + typeParameterIndex);
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            Class<?> javaTypeParameter = javaMethod.getParameterTypes()[typeParameterIndex];
            if (!this.isValidType(javaTypeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            if (javaTypeParameter == PainlessLookupUtility.typeToJavaType(typeParameter)) continue;
            throw PainlessLookupBuilder.lookupException("type parameter [%s] does not match the specified type parameter [%s] for class binding [[%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaTypeParameter), PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetClass.getCanonicalName(), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (!this.isValidType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for class binding [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] does not match the specified returned type [%s] for class binding [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()), PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, constructorParameterTypes.length + methodParameterTypes.length);
        if (this.painlessMethodKeysToImportedPainlessMethods.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("class binding and imported method cannot have the same name [" + methodName + "]");
        }
        if (this.painlessMethodKeysToPainlessInstanceBindings.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("class binding and instance binding cannot have the same name [" + methodName + "]");
        }
        if (Modifier.isStatic(javaMethod.getModifiers())) {
            throw PainlessLookupBuilder.lookupException("class binding [[%s], [%s], %s] cannot be static", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        PainlessClassBinding existingPainlessClassBinding = this.painlessMethodKeysToPainlessClassBindings.get(painlessMethodKey);
        PainlessClassBinding newPainlessClassBinding = new PainlessClassBinding(javaConstructor, javaMethod, returnType, typeParameters, annotations);
        if (existingPainlessClassBinding == null) {
            newPainlessClassBinding = painlessClassBindingCache.computeIfAbsent(newPainlessClassBinding, Function.identity());
            this.painlessMethodKeysToPainlessClassBindings.put(painlessMethodKey.intern(), newPainlessClassBinding);
        } else if (!newPainlessClassBinding.equals(existingPainlessClassBinding)) {
            throw PainlessLookupBuilder.lookupException("cannot add class bindings with the same name and arity but do not have equivalent methods [[%s], [%s], [%s], %s] and [[%s], [%s], [%s], %s]", targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(returnType), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessClassBinding.returnType()), PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessClassBinding.typeParameters()));
        }
    }

    public void addPainlessInstanceBinding(Object targetInstance, String methodName, String returnCanonicalTypeName, List<String> canonicalTypeNameParameters, Map<Class<?>, Object> painlessAnnotations) {
        Objects.requireNonNull(targetInstance);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(canonicalTypeNameParameters);
        Class<?> targetClass = targetInstance.getClass();
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        ArrayList typeParameters = new ArrayList(canonicalTypeNameParameters.size());
        for (String canonicalTypeNameParameter : canonicalTypeNameParameters) {
            Class<?> typeParameter = this.canonicalTypeNameToType(canonicalTypeNameParameter);
            if (typeParameter == null) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for instance binding [[%s], [%s], %s]", canonicalTypeNameParameter, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
            }
            typeParameters.add(typeParameter);
        }
        Class<?> returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        if (returnType == null) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for class binding [[%s], [%s], %s]", returnCanonicalTypeName, targetCanonicalClassName, methodName, canonicalTypeNameParameters);
        }
        this.addPainlessInstanceBinding(targetInstance, methodName, returnType, typeParameters, painlessAnnotations);
    }

    public void addPainlessInstanceBinding(Object targetInstance, String methodName, Class<?> returnType, List<Class<?>> typeParameters, Map<Class<?>, Object> painlessAnnotations) {
        Method javaMethod;
        Objects.requireNonNull(targetInstance);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        Class<?> targetClass = targetInstance.getClass();
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add instance binding as reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        Class<?> existingTargetClass = this.javaClassNamesToClasses.get(targetClass.getName());
        if (existingTargetClass == null) {
            this.javaClassNamesToClasses.put(targetClass.getName().intern(), targetClass);
        } else if (existingTargetClass != targetClass) {
            throw PainlessLookupBuilder.lookupException("class [%s] cannot represent multiple java classes with the same name from different class loaders", targetCanonicalClassName);
        }
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for instance binding [" + targetCanonicalClassName + "].");
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            if (!this.isValidType(typeParameter)) {
                throw PainlessLookupBuilder.lookupException("type parameter [%s] not found for instance binding [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(typeParameter), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        if (!this.isValidType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] not found for imported method [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        try {
            javaMethod = targetClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw PainlessLookupBuilder.lookupException(nsme, "instance binding reflection object [[%s], [%s], %s] not found", targetCanonicalClassName, methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw PainlessLookupBuilder.lookupException("return type [%s] does not match the specified returned type [%s] for instance binding [[%s], [%s], %s]", PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()), PainlessLookupUtility.typeToCanonicalTypeName(returnType), targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        if (Modifier.isStatic(javaMethod.getModifiers())) {
            throw PainlessLookupBuilder.lookupException("instance binding [[%s], [%s], %s] cannot be static", targetClass.getCanonicalName(), methodName, PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters));
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        if (this.painlessMethodKeysToImportedPainlessMethods.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("instance binding and imported method cannot have the same name [" + methodName + "]");
        }
        if (this.painlessMethodKeysToPainlessClassBindings.containsKey(painlessMethodKey)) {
            throw new IllegalArgumentException("instance binding and class binding cannot have the same name [" + methodName + "]");
        }
        PainlessInstanceBinding existingPainlessInstanceBinding = this.painlessMethodKeysToPainlessInstanceBindings.get(painlessMethodKey);
        PainlessInstanceBinding newPainlessInstanceBinding = new PainlessInstanceBinding(targetInstance, javaMethod, returnType, typeParameters, painlessAnnotations);
        if (existingPainlessInstanceBinding == null) {
            newPainlessInstanceBinding = painlessInstanceBindingCache.computeIfAbsent(newPainlessInstanceBinding, key -> key);
            this.painlessMethodKeysToPainlessInstanceBindings.put(painlessMethodKey.intern(), newPainlessInstanceBinding);
        } else if (!newPainlessInstanceBinding.equals(existingPainlessInstanceBinding)) {
            throw PainlessLookupBuilder.lookupException("cannot add instances bindings with the same name and arity but do not have equivalent methods [[%s], [%s], [%s], %s], %s and [[%s], [%s], [%s], %s], %s", targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(returnType), PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters), painlessAnnotations, targetCanonicalClassName, methodName, PainlessLookupUtility.typeToCanonicalTypeName(existingPainlessInstanceBinding.returnType()), PainlessLookupUtility.typesToCanonicalTypeNames(existingPainlessInstanceBinding.typeParameters()), existingPainlessInstanceBinding.annotations());
        }
    }

    public PainlessLookup build() {
        this.buildPainlessClassHierarchy();
        this.setFunctionalInterfaceMethods();
        this.generateRuntimeMethods();
        this.cacheRuntimeHandles();
        Map classesToPainlessClasses = Maps.newMapWithExpectedSize((int)this.classesToPainlessClassBuilders.size());
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            classesToPainlessClasses.put(painlessClassBuilderEntry.getKey(), painlessClassBuilderEntry.getValue().build());
        }
        if (!this.javaClassNamesToClasses.values().containsAll(this.canonicalClassNamesToClasses.values())) {
            throw new IllegalArgumentException("the values of java class names to classes must be a superset of the values of canonical class names to classes");
        }
        if (!this.javaClassNamesToClasses.values().containsAll(classesToPainlessClasses.keySet())) {
            throw new IllegalArgumentException("the values of java class names to classes must be a superset of the keys of classes to painless classes");
        }
        if (!this.canonicalClassNamesToClasses.values().containsAll(classesToPainlessClasses.keySet()) || !classesToPainlessClasses.keySet().containsAll(this.canonicalClassNamesToClasses.values())) {
            throw new IllegalArgumentException("the values of canonical class names to classes must have the same classes as the keys of classes to painless classes");
        }
        return new PainlessLookup(this.javaClassNamesToClasses, this.canonicalClassNamesToClasses, classesToPainlessClasses, this.classesToDirectSubClasses, this.painlessMethodKeysToImportedPainlessMethods, this.painlessMethodKeysToPainlessClassBindings, this.painlessMethodKeysToPainlessInstanceBindings);
    }

    private void buildPainlessClassHierarchy() {
        for (Class<?> targetClass : this.classesToPainlessClassBuilders.keySet()) {
            this.classesToDirectSubClasses.put(targetClass, new HashSet());
        }
        for (Class<?> subClass : this.classesToPainlessClassBuilders.keySet()) {
            ArrayDeque superInterfaces = new ArrayDeque(Arrays.asList(subClass.getInterfaces()));
            if (subClass.isInterface() && superInterfaces.isEmpty() && this.classesToPainlessClassBuilders.containsKey(Object.class)) {
                this.classesToDirectSubClasses.get(Object.class).add(subClass);
            } else {
                Class<?> superClass;
                for (superClass = subClass.getSuperclass(); superClass != null && !this.classesToPainlessClassBuilders.containsKey(superClass); superClass = superClass.getSuperclass()) {
                    superInterfaces.addAll(Arrays.asList(superClass.getInterfaces()));
                }
                if (superClass != null) {
                    this.classesToDirectSubClasses.get(superClass).add(subClass);
                }
            }
            HashSet<Class> resolvedInterfaces = new HashSet<Class>();
            while (!superInterfaces.isEmpty()) {
                Class superInterface = (Class)superInterfaces.removeFirst();
                if (!resolvedInterfaces.add(superInterface)) continue;
                if (this.classesToPainlessClassBuilders.containsKey(superInterface)) {
                    this.classesToDirectSubClasses.get(superInterface).add(subClass);
                    continue;
                }
                superInterfaces.addAll(Arrays.asList(superInterface.getInterfaces()));
            }
        }
    }

    private void setFunctionalInterfaceMethods() {
        this.classesToPainlessClassBuilders.forEach(this::setFunctionalInterfaceMethod);
    }

    private void setFunctionalInterfaceMethod(Class<?> targetClass, PainlessClassBuilder targetPainlessClassBuilder) {
        if (targetClass.isInterface()) {
            ArrayList<Method> javaMethods = new ArrayList<Method>();
            for (Method javaMethod : targetClass.getMethods()) {
                if (javaMethod.isDefault() || Modifier.isStatic(javaMethod.getModifiers())) continue;
                try {
                    Object.class.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
                }
                catch (ReflectiveOperationException roe) {
                    javaMethods.add(javaMethod);
                }
            }
            if (javaMethods.size() != 1 && targetClass.isAnnotationPresent(FunctionalInterface.class)) {
                throw PainlessLookupBuilder.lookupException("class [%s] is illegally marked as a FunctionalInterface with java methods %s", PainlessLookupUtility.typeToCanonicalTypeName(targetClass), javaMethods);
            }
            if (javaMethods.size() == 1) {
                Class superInterface;
                Method javaMethod = (Method)javaMethods.get(0);
                String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(javaMethod.getName(), javaMethod.getParameterCount());
                ArrayDeque superInterfaces = new ArrayDeque();
                HashSet<Class> resolvedInterfaces = new HashSet<Class>();
                superInterfaces.addLast(targetClass);
                while ((superInterface = (Class)superInterfaces.pollFirst()) != null) {
                    if (!resolvedInterfaces.add(superInterface)) continue;
                    PainlessClassBuilder functionalInterfacePainlessClassBuilder = this.classesToPainlessClassBuilders.get(superInterface);
                    if (functionalInterfacePainlessClassBuilder != null) {
                        targetPainlessClassBuilder.functionalInterfaceMethod = functionalInterfacePainlessClassBuilder.methods.get(painlessMethodKey);
                        if (targetPainlessClassBuilder.functionalInterfaceMethod != null) break;
                    }
                    superInterfaces.addAll(Arrays.asList(superInterface.getInterfaces()));
                }
            }
        }
    }

    private void generateRuntimeMethods() {
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            Class<?> targetClass = painlessClassBuilderEntry.getKey();
            PainlessClassBuilder painlessClassBuilder = painlessClassBuilderEntry.getValue();
            painlessClassBuilder.runtimeMethods.putAll(painlessClassBuilder.methods);
            for (PainlessMethod painlessMethod : painlessClassBuilder.runtimeMethods.values()) {
                for (Class<?> typeParameter : painlessMethod.typeParameters()) {
                    if (typeParameter != Byte.class && typeParameter != Short.class && typeParameter != Character.class && typeParameter != Integer.class && typeParameter != Long.class && typeParameter != Float.class && typeParameter != Double.class) continue;
                    this.generateFilteredMethod(targetClass, painlessClassBuilder, painlessMethod);
                }
            }
        }
    }

    private void generateFilteredMethod(Class<?> targetClass, PainlessClassBuilder painlessClassBuilder, PainlessMethod painlessMethod) {
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(painlessMethod.javaMethod().getName(), painlessMethod.typeParameters().size());
        PainlessMethod filteredPainlessMethod = painlessFilteredCache.get(painlessMethod);
        if (filteredPainlessMethod == null) {
            Method javaMethod = painlessMethod.javaMethod();
            boolean isStatic = Modifier.isStatic(painlessMethod.javaMethod().getModifiers());
            int filteredTypeParameterOffset = isStatic ? 0 : 1;
            ArrayList filteredTypeParameters = new ArrayList(javaMethod.getParameterCount() + filteredTypeParameterOffset);
            if (!isStatic) {
                filteredTypeParameters.add(javaMethod.getDeclaringClass());
            }
            for (Class<?> typeParameter : javaMethod.getParameterTypes()) {
                if (typeParameter == Byte.class || typeParameter == Short.class || typeParameter == Character.class || typeParameter == Integer.class || typeParameter == Long.class || typeParameter == Float.class || typeParameter == Double.class) {
                    filteredTypeParameters.add(Object.class);
                    continue;
                }
                filteredTypeParameters.add(typeParameter);
            }
            MethodType filteredMethodType = MethodType.methodType(painlessMethod.returnType(), filteredTypeParameters);
            MethodHandle filteredMethodHandle = painlessMethod.methodHandle();
            try {
                Class<?>[] methodParameters = javaMethod.getParameterTypes();
                for (int typeParameterCount = 0; typeParameterCount < methodParameters.length; ++typeParameterCount) {
                    Class<?> typeParameter = methodParameters[typeParameterCount];
                    MethodHandle castMethodHandle = Def.DEF_TO_BOXED_TYPE_IMPLICIT_CAST.get(typeParameter);
                    if (castMethodHandle == null) continue;
                    filteredMethodHandle = MethodHandles.filterArguments(filteredMethodHandle, typeParameterCount + filteredTypeParameterOffset, castMethodHandle);
                }
                filteredPainlessMethod = new PainlessMethod(painlessMethod.javaMethod(), targetClass, painlessMethod.returnType(), filteredTypeParameters, filteredMethodHandle, filteredMethodType, Map.of());
                painlessClassBuilder.runtimeMethods.put(painlessMethodKey.intern(), filteredPainlessMethod);
                painlessFilteredCache.put(painlessMethod, filteredPainlessMethod);
            }
            catch (Exception exception) {
                throw new IllegalStateException("internal error occurred attempting to generate a runtime method [" + painlessMethodKey + "]", exception);
            }
        } else {
            painlessClassBuilder.runtimeMethods.put(painlessMethodKey.intern(), filteredPainlessMethod);
        }
    }

    private void cacheRuntimeHandles() {
        this.classesToPainlessClassBuilders.values().forEach(this::cacheRuntimeHandles);
    }

    private void cacheRuntimeHandles(PainlessClassBuilder painlessClassBuilder) {
        for (Map.Entry<String, PainlessMethod> painlessMethodEntry : painlessClassBuilder.methods.entrySet()) {
            String methodKey = painlessMethodEntry.getKey();
            PainlessMethod painlessMethod = painlessMethodEntry.getValue();
            PainlessMethod bridgePainlessMethod = painlessClassBuilder.runtimeMethods.get(methodKey);
            String methodName = painlessMethod.javaMethod().getName();
            int typeParametersSize = painlessMethod.typeParameters().size();
            if (typeParametersSize == 0 && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                painlessClassBuilder.getterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), bridgePainlessMethod.methodHandle());
                continue;
            }
            if (typeParametersSize == 0 && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2))) {
                painlessClassBuilder.getterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3), bridgePainlessMethod.methodHandle());
                continue;
            }
            if (typeParametersSize != 1 || !methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) continue;
            painlessClassBuilder.setterMethodHandles.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), bridgePainlessMethod.methodHandle());
        }
        for (PainlessField painlessField : painlessClassBuilder.fields.values()) {
            painlessClassBuilder.getterMethodHandles.put(painlessField.javaField().getName().intern(), painlessField.getterMethodHandle());
            painlessClassBuilder.setterMethodHandles.put(painlessField.javaField().getName().intern(), painlessField.setterMethodHandle());
        }
    }
}

