/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.NotBinaryFilePredicate;
import org.sonar.plugins.secrets.SecretsRulesDefinition;
import org.sonar.plugins.secrets.api.SpecificationBasedCheck;
import org.sonar.plugins.secrets.api.SpecificationLoader;
import org.sonar.plugins.text.TextRuleDefinition;
import org.sonarsource.analyzer.commons.ProgressReport;

public class TextAndSecretsSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(TextAndSecretsSensor.class);
    public static final String EXCLUDED_FILE_SUFFIXES_KEY = "sonar.text.excluded.file.suffixes";
    private static final String ANALYZE_ALL_FILES_KEY = "sonar.text.analyzeAllFiles";
    public static final String TEXT_CATEGORY = "Secrets";
    private static final FilePredicate LANGUAGE_FILE_PREDICATE = inputFile -> inputFile.language() != null;
    private final CheckFactory checkFactory;
    private boolean displayHelpAboutExcludingBinaryFile = true;

    public TextAndSecretsSensor(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("TextAndSecretsSensor").createIssuesForRuleRepositories(new String[]{"text", "secrets"}).processesFilesIndependently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SensorContext sensorContext) {
        List<Check> activeChecks = this.getActiveChecks();
        this.initializeSpecificationBasedChecks(activeChecks);
        if (activeChecks.isEmpty()) {
            return;
        }
        NotBinaryFilePredicate notBinaryFilePredicate = TextAndSecretsSensor.binaryFilePredicate(sensorContext);
        NotBinaryFilePredicate filePredicate = TextAndSecretsSensor.isSonarLintContext(sensorContext) || TextAndSecretsSensor.analyzeAllFiles(sensorContext) ? notBinaryFilePredicate : LANGUAGE_FILE_PREDICATE;
        List<InputFile> inputFiles = TextAndSecretsSensor.getInputFiles(sensorContext, filePredicate);
        if (inputFiles.isEmpty()) {
            return;
        }
        List<String> filenames = inputFiles.stream().map(InputFile::toString).collect(Collectors.toList());
        ProgressReport progressReport = new ProgressReport("Progress of the text and secrets analysis", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(filenames);
        boolean cancelled = false;
        try {
            for (InputFile inputFile : inputFiles) {
                if (sensorContext.isCancelled()) {
                    cancelled = true;
                    break;
                }
                this.analyze(sensorContext, activeChecks, inputFile, notBinaryFilePredicate);
                progressReport.nextFile();
            }
        }
        finally {
            if (cancelled) {
                progressReport.cancel();
            } else {
                progressReport.stop();
            }
        }
    }

    private static NotBinaryFilePredicate binaryFilePredicate(SensorContext sensorContext) {
        return new NotBinaryFilePredicate(sensorContext.config().getStringArray(EXCLUDED_FILE_SUFFIXES_KEY));
    }

    private static boolean isSonarLintContext(SensorContext sensorContext) {
        return sensorContext.runtime().getProduct().equals((Object)SonarProduct.SONARLINT);
    }

    private static boolean analyzeAllFiles(SensorContext sensorContext) {
        return "true".equals(sensorContext.config().get(ANALYZE_ALL_FILES_KEY).orElse("false"));
    }

    private static List<InputFile> getInputFiles(SensorContext sensorContext, FilePredicate filePredicate) {
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        FileSystem fileSystem = sensorContext.fileSystem();
        for (InputFile inputFile : fileSystem.inputFiles(filePredicate)) {
            inputFiles.add(inputFile);
        }
        return inputFiles;
    }

    private void analyze(SensorContext sensorContext, List<Check> activeChecks, InputFile inputFile, NotBinaryFilePredicate notBinaryFilePredicate) {
        if (notBinaryFilePredicate.apply(inputFile)) {
            try {
                InputFileContext inputFileContext = new InputFileContext(sensorContext, inputFile);
                if (inputFileContext.hasNonTextCharacters()) {
                    this.excludeBinaryFileExtension(notBinaryFilePredicate, inputFile);
                } else {
                    for (Check check : activeChecks) {
                        check.analyze(inputFileContext);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                TextAndSecretsSensor.logAnalysisError(sensorContext, inputFile, e);
            }
        }
    }

    private void excludeBinaryFileExtension(NotBinaryFilePredicate notBinaryFilePredicate, InputFile inputFile) {
        String extension = NotBinaryFilePredicate.extension(inputFile.filename());
        if (extension != null) {
            notBinaryFilePredicate.addBinaryFileExtension(extension);
            LOG.warn("'{}' was added to the binary file filter because the file '{}' is a binary file.", (Object)extension, (Object)inputFile);
            if (this.displayHelpAboutExcludingBinaryFile) {
                this.displayHelpAboutExcludingBinaryFile = false;
                LOG.info("To remove the previous warning you can add the '.{}' extension to the '{}' property.", (Object)extension, (Object)EXCLUDED_FILE_SUFFIXES_KEY);
            }
        }
    }

    protected List<Check> getActiveChecks() {
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.addAll(this.checkFactory.create("text").addAnnotatedChecks(TextRuleDefinition.checks()).all());
        checks.addAll(this.checkFactory.create("secrets").addAnnotatedChecks(SecretsRulesDefinition.checks()).all());
        return checks;
    }

    protected void initializeSpecificationBasedChecks(List<Check> checks) {
        SpecificationLoader specificationLoader = new SpecificationLoader();
        HashMap<InputFileContext, List<TextRange>> reportedIssuesForCtx = new HashMap<InputFileContext, List<TextRange>>();
        for (Check activeCheck : checks) {
            if (!(activeCheck instanceof SpecificationBasedCheck)) continue;
            ((SpecificationBasedCheck)activeCheck).initialize(specificationLoader, reportedIssuesForCtx);
        }
    }

    private static void logAnalysisError(SensorContext sensorContext, InputFile inputFile, Exception e) {
        String message = String.format("Unable to analyze file %s: %s", inputFile, e.getMessage());
        sensorContext.newAnalysisError().message(message).onFile(inputFile).save();
        LOG.warn(message);
        String exceptionString = e.toString();
        LOG.debug(exceptionString);
    }
}

