/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

public class Match {
    private final String text;
    private final int fileStartOffset;
    private final int fileEndOffset;

    public Match(String text, int fileStartOffset, int fileEndOffset) {
        this.text = text;
        this.fileStartOffset = fileStartOffset;
        this.fileEndOffset = fileEndOffset;
    }

    public String getText() {
        return this.text;
    }

    public int getFileStartOffset() {
        return this.fileStartOffset;
    }

    public int getFileEndOffset() {
        return this.fileEndOffset;
    }

    public boolean isBefore(Match match) {
        return this.fileEndOffset < match.getFileStartOffset();
    }

    public boolean isAfter(Match match) {
        return this.fileStartOffset > match.getFileEndOffset();
    }

    public boolean inDistanceOf(Match match, int distance) {
        boolean matchesOverlap;
        int firstEndToSecondStartDistance = this.fileEndOffset - match.getFileStartOffset();
        int firstStartToSecondEndDistance = this.fileStartOffset - match.getFileEndOffset();
        boolean bl = matchesOverlap = firstEndToSecondStartDistance >= 0 && firstStartToSecondEndDistance <= 0;
        if (matchesOverlap) {
            return true;
        }
        return Math.min(Math.abs(firstEndToSecondStartDistance), Math.abs(firstStartToSecondEndDistance)) <= distance;
    }
}

