/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.Matching;

public class PatternMatcher {
    private final Pattern pattern;

    PatternMatcher(@Nullable String stringPattern) {
        this.pattern = stringPattern != null ? Pattern.compile(stringPattern) : null;
    }

    public static PatternMatcher build(@Nullable Matching matching) {
        if (matching != null) {
            return new PatternMatcher(matching.getPattern());
        }
        return new PatternMatcher(null);
    }

    public static PatternMatcher build(AuxiliaryPattern auxiliaryPattern) {
        return new PatternMatcher(auxiliaryPattern.getPattern());
    }

    public List<Match> findIn(String content) {
        if (this.pattern == null) {
            return Collections.emptyList();
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            if (matcher.groupCount() == 0) {
                matches.add(new Match(matchResult.group(), matchResult.start(), matchResult.end()));
                continue;
            }
            matches.add(new Match(matchResult.group(1), matchResult.start(1), matchResult.end(1)));
        }
        return matches;
    }
}

