/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.SecretMatcher;
import org.sonar.plugins.secrets.api.SpecificationLoader;
import org.sonar.plugins.secrets.configuration.model.Rule;

public abstract class SpecificationBasedCheck
extends Check {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificationBasedCheck.class);
    private List<SecretMatcher> matcher;
    private Map<InputFileContext, List<TextRange>> reportedIssuesForCtx;

    @Override
    protected String repositoryKey() {
        return "secrets";
    }

    protected SpecificationBasedCheck() {
    }

    public void initialize(SpecificationLoader loader, Map<InputFileContext, List<TextRange>> reportedIssuesForCtx) {
        this.reportedIssuesForCtx = reportedIssuesForCtx;
        String rule = this.ruleKey.rule();
        List<Rule> rulesForKey = loader.getRulesForKey(rule);
        if (rulesForKey.isEmpty()) {
            LOG.error("Found no rule specification for rule with key: {}", (Object)rule);
        }
        this.matcher = rulesForKey.stream().map(SecretMatcher::build).collect(Collectors.toList());
    }

    @Override
    public void analyze(InputFileContext ctx) {
        for (SecretMatcher secretMatcher : this.matcher) {
            secretMatcher.findIn(ctx).stream().map(match -> ctx.newTextRangeFromFileOffsets(match.getFileStartOffset(), match.getFileEndOffset())).forEach(textRange -> this.reportIfNoOverlappingSecretAlreadyFound(ctx, (TextRange)textRange, secretMatcher));
        }
    }

    public void reportIfNoOverlappingSecretAlreadyFound(InputFileContext ctx, TextRange foundSecret, SecretMatcher secretMatcher) {
        List reportedSecrets = this.reportedIssuesForCtx.compute(ctx, (k, v) -> v == null ? new ArrayList() : v);
        boolean noOverlappingSecrets = reportedSecrets.stream().noneMatch(reportedSecret -> reportedSecret.overlap(foundSecret));
        if (noOverlappingSecrets) {
            reportedSecrets.add(foundSecret);
            ctx.reportIssue(this.ruleKey, foundSecret, secretMatcher.getMessageFromRule());
        }
    }

    public List<SecretMatcher> getMatcher() {
        return this.matcher;
    }
}

