/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.secrets.SecretsSpecificationFilesDefinition;
import org.sonar.plugins.secrets.configuration.deserialization.DeserializationException;
import org.sonar.plugins.secrets.configuration.deserialization.SpecificationDeserializer;
import org.sonar.plugins.secrets.configuration.model.Rule;
import org.sonar.plugins.secrets.configuration.model.Specification;
import org.sonar.plugins.secrets.configuration.validation.SchemaValidationException;

public class SpecificationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificationLoader.class);
    public static final String DEFAULT_SPECIFICATION_LOCATION = "org/sonar/plugins/secrets/configuration/";
    private final Map<String, List<Rule>> rulesMappedToKey;

    public SpecificationLoader() {
        this(DEFAULT_SPECIFICATION_LOCATION, SecretsSpecificationFilesDefinition.existingSecretSpecifications());
    }

    public SpecificationLoader(String specificationLocation, Set<String> specifications) {
        this.rulesMappedToKey = SpecificationLoader.initialize(specificationLocation, specifications);
    }

    private static Map<String, List<Rule>> initialize(String specificationLocation, Set<String> specifications) {
        HashMap<String, List<Rule>> keyToRule = new HashMap<String, List<Rule>>();
        for (String specificationFileName : specifications) {
            Specification specification;
            try {
                specification = SpecificationLoader.loadSpecification(specificationLocation, specificationFileName);
            }
            catch (DeserializationException | SchemaValidationException e) {
                LOG.error("{}: Could not load specification from file: {}", (Object)e.getClass().getSimpleName(), (Object)specificationFileName);
                continue;
            }
            for (Rule rule : specification.getProvider().getRules()) {
                keyToRule.computeIfAbsent(rule.getRspecKey(), k -> new ArrayList()).add(rule);
            }
        }
        return keyToRule;
    }

    private static Specification loadSpecification(String specificationLocation, String fileName) {
        InputStream specificationStream = SpecificationLoader.class.getClassLoader().getResourceAsStream(specificationLocation + fileName);
        return SpecificationDeserializer.deserialize(specificationStream, fileName);
    }

    public List<Rule> getRulesForKey(String key) {
        return this.rulesMappedToKey.getOrDefault(key, new ArrayList());
    }

    public Map<String, List<Rule>> getRulesMappedToKey() {
        return this.rulesMappedToKey;
    }
}

