/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.InputStream;
import java.util.Set;
import org.sonar.plugins.secrets.configuration.validation.SchemaValidationException;

public class SchemaValidator {
    private static final String FILE_LOCATION = "/org/sonar/plugins/secrets/configuration/specifications/";
    private static final String VALIDATION_SCHEMA_FILE = "specification-json-schema.json";
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());
    private static final JsonSchema VALIDATION_SCHEMA = SchemaValidator.initializeValidationSchema();

    private SchemaValidator() {
    }

    private static JsonSchema initializeValidationSchema() {
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.builder(JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V202012)).objectMapper(MAPPER).build();
        InputStream validationSchema = SchemaValidator.class.getResourceAsStream("/org/sonar/plugins/secrets/configuration/specifications/specification-json-schema.json");
        return schemaFactory.getSchema(validationSchema);
    }

    public static void validate(JsonNode specification, String fileName) {
        Set<ValidationMessage> validate = VALIDATION_SCHEMA.validate(specification);
        if (!validate.isEmpty()) {
            String errorMessage = String.format("Specification file \"%s\" failed the schema validation", fileName);
            throw new SchemaValidationException(errorMessage);
        }
    }
}

