/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jwt.SignedJWT;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.jwt.JwkSetLoader;
import org.elasticsearch.xpack.security.authc.jwt.JwkValidateUtil;
import org.elasticsearch.xpack.security.authc.jwt.JwtValidateUtil;

public interface JwtSignatureValidator
extends Releasable {
    default public void close() {
    }

    public void validate(String var1, SignedJWT var2, ActionListener<Void> var3);

    public static interface PkcJwkSetReloadNotifier {
        public void reloaded();
    }

    public static class PkcJwtSignatureValidator
    implements JwtSignatureValidator {
        private static final Logger logger = LogManager.getLogger(PkcJwtSignatureValidator.class);
        private final JwkSetLoader jwkSetLoader;
        private final PkcJwkSetReloadNotifier reloadNotifier;

        PkcJwtSignatureValidator(JwkSetLoader jwkSetLoader, PkcJwkSetReloadNotifier reloadNotifier) {
            this.jwkSetLoader = jwkSetLoader;
            this.reloadNotifier = reloadNotifier;
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT signedJWT, ActionListener<Void> listener) {
            JwkSetLoader.ContentAndJwksAlgs contentAndJwksAlgs = this.jwkSetLoader.getContentAndJwksAlgs();
            JwkSetLoader.JwksAlgs jwksAlgs = contentAndJwksAlgs.jwksAlgs();
            try {
                JwtValidateUtil.validateSignature(signedJWT, jwksAlgs.jwks());
                listener.onResponse(null);
            }
            catch (Exception primaryException) {
                logger.debug(() -> Strings.format((String)"Signature verification failed for JWT [%s] reloading JWKSet (was: #[%s] JWKs, #[%s] algs, sha256=[%s])", (Object[])new Object[]{tokenPrincipal, jwksAlgs.jwks().size(), jwksAlgs.algs().size(), MessageDigests.toHexString((byte[])contentAndJwksAlgs.sha256())}), (Throwable)primaryException);
                this.jwkSetLoader.reload((ActionListener<Tuple<Boolean, JwkSetLoader.JwksAlgs>>)ActionListener.wrap(reloadResult -> {
                    if (!((Boolean)reloadResult.v1()).booleanValue()) {
                        logger.debug("Reloaded same PKC JWKs, can't retry verify JWT token [{}]", (Object)tokenPrincipal);
                        listener.onFailure(primaryException);
                        return;
                    }
                    this.reloadNotifier.reloaded();
                    JwkSetLoader.JwksAlgs reloadedJwksAlgs = (JwkSetLoader.JwksAlgs)reloadResult.v2();
                    if (reloadedJwksAlgs.isEmpty()) {
                        logger.debug("Reloaded empty PKC JWKs, signature verification will fail for JWT [{}]", (Object)tokenPrincipal);
                    }
                    try {
                        JwtValidateUtil.validateSignature(signedJWT, reloadedJwksAlgs.jwks());
                        listener.onResponse(null);
                    }
                    catch (Exception secondaryException) {
                        logger.debug("Signature verification of JWT [{}] failed - original failure: [{}], failure after reload: [{}]", (Object)tokenPrincipal, (Object)primaryException.getMessage(), (Object)secondaryException.getMessage());
                        secondaryException.addSuppressed(primaryException);
                        listener.onFailure(secondaryException);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }

        @Override
        public void close() {
            this.jwkSetLoader.close();
        }
    }

    public static class HmacJwtSignatureValidator
    implements JwtSignatureValidator {
        private final JwkSetLoader.JwksAlgs jwksAlgs;

        HmacJwtSignatureValidator(JwkSetLoader.JwksAlgs jwksAlgs) {
            this.jwksAlgs = jwksAlgs;
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT jwt, ActionListener<Void> listener) {
            try {
                JwtValidateUtil.validateSignature(jwt, this.jwksAlgs.jwks());
                listener.onResponse(null);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public static class DelegatingJwtSignatureValidator
    implements JwtSignatureValidator {
        private static final Logger logger = LogManager.getLogger(DelegatingJwtSignatureValidator.class);
        private final RealmConfig realmConfig;
        final List<String> allowedJwksAlgsPkc;
        final List<String> allowedJwksAlgsHmac;
        @Nullable
        private final HmacJwtSignatureValidator hmacJwtSignatureValidator;
        @Nullable
        private final PkcJwtSignatureValidator pkcJwtSignatureValidator;

        public DelegatingJwtSignatureValidator(RealmConfig realmConfig, SSLService sslService, PkcJwkSetReloadNotifier reloadNotifier) {
            List<JWK> jwksHmac;
            this.realmConfig = realmConfig;
            List algs = (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS);
            this.allowedJwksAlgsHmac = algs.stream().filter(JwtRealmSettings.SUPPORTED_SIGNATURE_ALGORITHMS_HMAC::contains).toList();
            this.allowedJwksAlgsPkc = algs.stream().filter(JwtRealmSettings.SUPPORTED_SIGNATURE_ALGORITHMS_PKC::contains).toList();
            String jwkSetPath = (String)realmConfig.getSetting(JwtRealmSettings.PKC_JWKSET_PATH);
            SecureString hmacJwkSetContents = (SecureString)realmConfig.getSetting(JwtRealmSettings.HMAC_JWKSET);
            SecureString hmacKeyContents = (SecureString)realmConfig.getSetting(JwtRealmSettings.HMAC_KEY);
            boolean isConfiguredJwkSetPkc = org.elasticsearch.common.Strings.hasText((String)jwkSetPath);
            boolean isConfiguredJwkSetHmac = org.elasticsearch.common.Strings.hasText((CharSequence)hmacJwkSetContents);
            boolean isConfiguredJwkOidcHmac = org.elasticsearch.common.Strings.hasText((CharSequence)hmacKeyContents);
            DelegatingJwtSignatureValidator.validateJwkSettings(realmConfig, isConfiguredJwkSetPkc, isConfiguredJwkSetHmac, isConfiguredJwkOidcHmac);
            if (isConfiguredJwkSetHmac) {
                jwksHmac = JwkValidateUtil.loadJwksFromJwkSetString(RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET), hmacJwkSetContents.toString());
            } else if (isConfiguredJwkOidcHmac) {
                OctetSequenceKey hmacKey = JwkValidateUtil.loadHmacJwkFromJwkString(RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY), (CharSequence)hmacKeyContents);
                assert (hmacKey != null) : "Null HMAC key should not happen here";
                jwksHmac = List.of(hmacKey);
            } else {
                jwksHmac = null;
            }
            if (jwksHmac != null) {
                JwkSetLoader.JwksAlgs jwksAlgs = JwkValidateUtil.filterJwksAndAlgorithms(jwksHmac, this.allowedJwksAlgsHmac);
                logger.info("Usable HMAC: JWKs [{}]. Algorithms [{}].", (Object)jwksAlgs.jwks().size(), (Object)String.join((CharSequence)",", jwksAlgs.algs()));
                this.hmacJwtSignatureValidator = new HmacJwtSignatureValidator(jwksAlgs);
            } else {
                this.hmacJwtSignatureValidator = null;
            }
            this.pkcJwtSignatureValidator = isConfiguredJwkSetPkc ? new PkcJwtSignatureValidator(new JwkSetLoader(realmConfig, this.allowedJwksAlgsPkc, sslService), reloadNotifier) : null;
            this.logWarnIfAuthenticationWillAlwaysFail();
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT jwt, ActionListener<Void> listener) {
            String algorithm = jwt.getHeader().getAlgorithm().getName();
            if (this.allowedJwksAlgsHmac.contains(algorithm)) {
                if (this.hmacJwtSignatureValidator != null) {
                    this.hmacJwtSignatureValidator.validate(tokenPrincipal, jwt, listener);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is a HMAC signing algorithm, but none of the HMAC JWK settings [" + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + ", " + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] is configured", RestStatus.BAD_REQUEST, new Object[]{algorithm})));
                }
            } else if (this.allowedJwksAlgsPkc.contains(algorithm)) {
                if (this.pkcJwtSignatureValidator != null) {
                    this.pkcJwtSignatureValidator.validate(tokenPrincipal, jwt, listener);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is a PKC signing algorithm, but PKC JWK setting [" + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.PKC_JWKSET_PATH) + "] is not configured", RestStatus.BAD_REQUEST, new Object[]{algorithm})));
                }
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is not in the list of supported algorithms [%s]", RestStatus.BAD_REQUEST, new Object[]{algorithm, org.elasticsearch.common.Strings.collectionToCommaDelimitedString(Stream.of(this.allowedJwksAlgsHmac.stream(), this.allowedJwksAlgsPkc.stream()).toList())})));
            }
        }

        @Override
        public void close() {
            if (this.pkcJwtSignatureValidator != null) {
                this.pkcJwtSignatureValidator.close();
            }
        }

        private void logWarnIfAuthenticationWillAlwaysFail() {
            boolean hasUsableJwksAndAlgorithms;
            boolean bl = hasUsableJwksAndAlgorithms = this.hmacJwtSignatureValidator != null && false == this.hmacJwtSignatureValidator.jwksAlgs.isEmpty() || this.pkcJwtSignatureValidator != null && false == this.pkcJwtSignatureValidator.jwkSetLoader.getContentAndJwksAlgs().jwksAlgs().isEmpty();
            if (!hasUsableJwksAndAlgorithms) {
                logger.warn("No available JWK and algorithm for HMAC or PKC. JWT realm authentication expected to fail until this is fixed.");
            }
        }

        private static void validateJwkSettings(RealmConfig realmConfig, boolean isConfiguredJwkSetPkc, boolean isConfiguredJwkSetHmac, boolean isConfiguredJwkOidcHmac) {
            if (!(isConfiguredJwkSetPkc || isConfiguredJwkSetHmac || isConfiguredJwkOidcHmac)) {
                throw new SettingsException("At least one of [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.PKC_JWKSET_PATH) + "] must be set");
            }
            if (isConfiguredJwkSetHmac && isConfiguredJwkOidcHmac) {
                throw new SettingsException("Settings [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] and [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + "] are not allowed at the same time.");
            }
        }

        Tuple<JwkSetLoader.JwksAlgs, JwkSetLoader.JwksAlgs> getAllJwksAlgs() {
            JwkSetLoader.JwksAlgs jwksAlgsHmac = this.hmacJwtSignatureValidator == null ? new JwkSetLoader.JwksAlgs(List.of(), List.of()) : this.hmacJwtSignatureValidator.jwksAlgs;
            JwkSetLoader.JwksAlgs jwksAlgsPkc = this.pkcJwtSignatureValidator == null ? new JwkSetLoader.JwksAlgs(List.of(), List.of()) : this.pkcJwtSignatureValidator.jwkSetLoader.getContentAndJwksAlgs().jwksAlgs();
            return new Tuple((Object)jwksAlgsHmac, (Object)jwksAlgsPkc);
        }
    }
}

