/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.security.authc.jwt.FallbackableClaim;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;

public class JwtStringClaimValidator
implements JwtFieldValidator {
    public static JwtStringClaimValidator ALLOW_ALL_SUBJECTS = new JwtStringClaimValidator("sub", null, true);
    private final String claimName;
    @Nullable
    private final Map<String, String> fallbackClaimNames;
    @Nullable
    private final List<String> allowedClaimValues;
    private final boolean singleValuedClaim;

    public JwtStringClaimValidator(String claimName, List<String> allowedClaimValues, boolean singleValuedClaim) {
        this(claimName, null, allowedClaimValues, singleValuedClaim);
    }

    public JwtStringClaimValidator(String claimName, Map<String, String> fallbackClaimNames, List<String> allowedClaimValues, boolean singleValuedClaim) {
        this.claimName = claimName;
        this.fallbackClaimNames = fallbackClaimNames;
        this.allowedClaimValues = allowedClaimValues;
        this.singleValuedClaim = singleValuedClaim;
    }

    @Override
    public void validate(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) {
        FallbackableClaim fallbackableClaim = new FallbackableClaim(this.claimName, this.fallbackClaimNames, jwtClaimsSet);
        List<String> claimValues = this.getStringClaimValues(fallbackableClaim);
        if (claimValues == null) {
            throw new IllegalArgumentException("missing required string claim [" + fallbackableClaim + "]");
        }
        if (this.allowedClaimValues != null) {
            if (!claimValues.stream().anyMatch(this.allowedClaimValues::contains)) {
                throw new IllegalArgumentException("string claim [" + fallbackableClaim + "] has value [" + Strings.collectionToCommaDelimitedString(claimValues) + "] which does not match allowed claim values [" + Strings.collectionToCommaDelimitedString(this.allowedClaimValues) + "]");
            }
        }
    }

    private List<String> getStringClaimValues(FallbackableClaim fallbackableClaim) {
        if (this.singleValuedClaim) {
            String claimValue = fallbackableClaim.getStringClaimValue();
            return claimValue != null ? List.of(claimValue) : null;
        }
        return fallbackableClaim.getStringListClaimValue();
    }
}

