/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class JwtUtil {
    private static final Logger LOGGER = LogManager.getLogger(JwtUtil.class);

    public static SecureString getHeaderValue(ThreadContext threadContext, String headerName, String schemeName, boolean ignoreSchemeNameCase) {
        String schemeValuePlusSpace;
        String headerValue = threadContext.getHeader(headerName);
        if (Strings.hasText((String)headerValue) && headerValue.regionMatches(ignoreSchemeNameCase, 0, schemeValuePlusSpace = schemeName + " ", 0, schemeValuePlusSpace.length())) {
            String trimmedSchemeParameters = headerValue.substring(schemeValuePlusSpace.length()).trim();
            return new SecureString(trimmedSchemeParameters.toCharArray());
        }
        return null;
    }

    public static void validateClientAuthenticationSettings(String clientAuthenticationTypeConfigKey, JwtRealmSettings.ClientAuthenticationType clientAuthenticationType, String clientAuthenticationSharedSecretConfigKey, SecureString clientAuthenticationSharedSecret) throws SettingsException {
        switch (clientAuthenticationType) {
            case SHARED_SECRET: {
                if (Strings.hasText((CharSequence)clientAuthenticationSharedSecret)) break;
                throw new SettingsException("Missing setting for [" + clientAuthenticationSharedSecretConfigKey + "]. It is required when setting [" + clientAuthenticationTypeConfigKey + "] is [" + JwtRealmSettings.ClientAuthenticationType.SHARED_SECRET.value() + "]");
            }
            default: {
                if (Strings.hasText((CharSequence)clientAuthenticationSharedSecret)) {
                    throw new SettingsException("Setting [" + clientAuthenticationSharedSecretConfigKey + "] is not supported, because setting [" + clientAuthenticationTypeConfigKey + "] is [" + JwtRealmSettings.ClientAuthenticationType.NONE.value() + "]");
                }
                LOGGER.warn("Setting [{}] value [{}] may not be secure. Unauthorized clients may be able to submit JWTs from the same issuer.", (Object)clientAuthenticationSharedSecretConfigKey, (Object)JwtRealmSettings.ClientAuthenticationType.NONE.value());
            }
        }
    }

    public static void validateClientAuthentication(JwtRealmSettings.ClientAuthenticationType type, SecureString expectedSecret, SecureString actualSecret) throws Exception {
        switch (type) {
            case SHARED_SECRET: {
                if (!Strings.hasText((CharSequence)actualSecret)) {
                    throw new Exception("Rejected client. Authentication type is [" + type + "] and secret is missing.");
                }
                if (!expectedSecret.equals((Object)actualSecret)) {
                    throw new Exception("Rejected client. Authentication type is [" + type + "] and secret did not match.");
                }
                LOGGER.trace("Accepted client. Authentication type is [{}] and secret matched.", (Object)type);
                break;
            }
            default: {
                if (Strings.hasText((CharSequence)actualSecret)) {
                    LOGGER.debug("Accepted client. Authentication type [{}]. Secret is present but ignored.", (Object)type);
                    break;
                }
                LOGGER.trace("Accepted client. Authentication type [{}].", (Object)type);
            }
        }
    }

    public static URI parseHttpsUri(String uriString) {
        if (Strings.hasText((String)uriString)) {
            if (uriString.startsWith("https")) {
                URI uri;
                try {
                    uri = new URI(uriString);
                }
                catch (Exception e) {
                    throw new SettingsException("Failed to parse HTTPS URI [" + uriString + "].", (Throwable)e);
                }
                if (!Strings.hasText((String)uri.getHost())) {
                    throw new SettingsException("Host is missing in HTTPS URI [" + uriString + "].");
                }
                return uri;
            }
            if (uriString.startsWith("http")) {
                throw new SettingsException("Not allowed to use HTTP URI [" + uriString + "]. Only HTTPS is supported.");
            }
            LOGGER.trace("Not a HTTPS URI [{}].", (Object)uriString);
        }
        return null;
    }

    public static void readUriContents(String jwkSetConfigKeyPkc, URI jwkSetPathPkcUri, CloseableHttpAsyncClient httpClient, ActionListener<byte[]> listener) {
        JwtUtil.readBytes(httpClient, jwkSetPathPkcUri, (ActionListener<byte[]>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), ex -> listener.onFailure((Exception)new SettingsException("Can't get contents for setting [" + jwkSetConfigKeyPkc + "] value [" + jwkSetPathPkcUri + "].", (Throwable)ex))));
    }

    public static byte[] readFileContents(String jwkSetConfigKeyPkc, String jwkSetPathPkc, Environment environment) throws SettingsException {
        try {
            Path path = JwtUtil.resolvePath(environment, jwkSetPathPkc);
            return Files.readAllBytes(path);
        }
        catch (Exception e) {
            throw new SettingsException("Failed to read contents for setting [" + jwkSetConfigKeyPkc + "] value [" + jwkSetPathPkc + "].", (Throwable)e);
        }
    }

    public static String serializeJwkSet(JWKSet jwkSet, boolean publicKeysOnly) {
        if (jwkSet == null) {
            return null;
        }
        return JSONObjectUtils.toJSONString((Map)jwkSet.toJSONObject(publicKeysOnly));
    }

    public static String serializeJwkHmacOidc(JWK key) {
        return new String(key.toOctetSequenceKey().toByteArray(), StandardCharsets.UTF_8);
    }

    public static CloseableHttpAsyncClient createHttpClient(RealmConfig realmConfig, SSLService sslService) {
        try {
            SpecialPermission.check();
            return AccessController.doPrivileged(() -> {
                DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor();
                String sslKey = RealmSettings.realmSslPrefix((RealmConfig.RealmIdentifier)realmConfig.identifier());
                SslConfiguration sslConfiguration = sslService.getSSLConfiguration(sslKey);
                SSLContext clientContext = sslService.sslContext(sslConfiguration);
                HostnameVerifier verifier = SSLService.getHostnameVerifier((SslConfiguration)sslConfiguration);
                Registry registry = RegistryBuilder.create().register("https", (Object)new SSLIOSessionStrategy(clientContext, verifier)).build();
                PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, registry);
                connectionManager.setDefaultMaxPerRoute(((Integer)realmConfig.getSetting(JwtRealmSettings.HTTP_MAX_ENDPOINT_CONNECTIONS)).intValue());
                connectionManager.setMaxTotal(((Integer)realmConfig.getSetting(JwtRealmSettings.HTTP_MAX_CONNECTIONS)).intValue());
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Math.toIntExact(((TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_CONNECT_TIMEOUT)).getMillis())).setConnectionRequestTimeout(Math.toIntExact(((TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_CONNECTION_READ_TIMEOUT)).getMillis())).setSocketTimeout(Math.toIntExact(((TimeValue)realmConfig.getSetting(JwtRealmSettings.HTTP_SOCKET_TIMEOUT)).getMillis())).build();
                HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
                CloseableHttpAsyncClient httpAsyncClient = httpAsyncClientBuilder.build();
                httpAsyncClient.start();
                return httpAsyncClient;
            });
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException("Unable to create a HttpAsyncClient instance", e);
        }
    }

    public static void readBytes(CloseableHttpAsyncClient httpClient, final URI uri, final ActionListener<byte[]> listener) {
        AccessController.doPrivileged(() -> {
            httpClient.execute((HttpUriRequest)new HttpGet(uri), (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    StatusLine statusLine = result.getStatusLine();
                    int statusCode = statusLine.getStatusCode();
                    if (statusCode == 200) {
                        HttpEntity entity = result.getEntity();
                        try (InputStream inputStream = entity.getContent();){
                            listener.onResponse((Object)inputStream.readAllBytes());
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    } else {
                        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Get [" + uri + "] failed, status [" + statusCode + "], reason [" + statusLine.getReasonPhrase() + "].", new Object[0])));
                    }
                }

                public void failed(Exception e) {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Get [" + uri + "] failed.", e, new Object[0])));
                }

                public void cancelled() {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Get [" + uri + "] was cancelled.", new Object[0])));
                }
            });
            return null;
        });
    }

    public static Path resolvePath(Environment environment, String jwkSetPath) {
        Path directoryPath = environment.configFile();
        return directoryPath.resolve(jwkSetPath);
    }

    public static SecureString join(CharSequence delimiter, CharSequence ... secureStrings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < secureStrings.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(secureStrings[i]);
        }
        return new SecureString(sb.toString().toCharArray());
    }

    public static byte[] sha256(CharSequence charSequence) {
        MessageDigest messageDigest = MessageDigests.sha256();
        messageDigest.update(charSequence.toString().getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }
}

