/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.xpack.security.authc.jwt.JwkValidateUtil;

public class JwtValidateUtil {
    private static final Logger LOGGER = LogManager.getLogger(JwtValidateUtil.class);

    public static void validateSignature(SignedJWT jwt, List<JWK> jwks) throws Exception {
        assert (jwks != null) : "Verify requires a non-null JWK list";
        if (jwks.isEmpty()) {
            throw new ElasticsearchException("Verify requires a non-empty JWK list", new Object[0]);
        }
        String id = jwt.getHeader().getKeyID();
        JWSAlgorithm alg = jwt.getHeader().getAlgorithm();
        LOGGER.trace("JWKs [{}], JWT KID [{}], and JWT Algorithm [{}] before filters.", (Object)jwks.size(), (Object)id, (Object)alg.getName());
        List<JWK> jwksKid = jwks.stream().filter(j -> id == null || j.getKeyID() == null || id.equals(j.getKeyID())).toList();
        LOGGER.trace("JWKs [{}] after KID [{}](|null) filter.", (Object)jwksKid.size(), (Object)id);
        List<JWK> jwksAlg = jwksKid.stream().filter(j -> j.getAlgorithm() == null || alg.equals((Object)j.getAlgorithm())).toList();
        LOGGER.trace("JWKs [{}] after Algorithm [{}](|null) filter.", (Object)jwksAlg.size(), (Object)alg.getName());
        List<JWK> jwksStrength = jwksAlg.stream().filter(j -> JwkValidateUtil.isMatch(j, alg.getName())).toList();
        LOGGER.debug("JWKs [{}] after Algorithm [{}] match filter.", (Object)jwksStrength.size(), (Object)alg);
        if (jwksStrength.isEmpty()) {
            throw new ElasticsearchException("Verify failed because all " + jwks.size() + " provided JWKs were filtered.", new Object[0]);
        }
        for (JWK jwk : jwksStrength) {
            if (jwt.verify(JwtValidateUtil.createJwsVerifier(jwk))) {
                LOGGER.trace("JWT signature validation succeeded with JWK kty=[{}], jwtAlg=[{}], jwtKid=[{}], use=[{}], ops=[{}]", (Object)jwk.getKeyType(), (Object)jwk.getAlgorithm(), (Object)jwk.getKeyID(), (Object)jwk.getKeyUse(), (Object)jwk.getKeyOperations());
                return;
            }
            LOGGER.trace("JWT signature validation failed with JWK kty=[{}], jwtAlg=[{}], jwtKid=[{}], use=[{}], ops={}", (Object)jwk.getKeyType(), (Object)jwk.getAlgorithm(), (Object)jwk.getKeyID(), (Object)jwk.getKeyUse(), jwk.getKeyOperations() == null ? "[null]" : jwk.getKeyOperations());
        }
        throw new ElasticsearchException("Verify failed using " + jwksStrength.size() + " of " + jwks.size() + " provided JWKs.", new Object[0]);
    }

    public static JWSVerifier createJwsVerifier(JWK jwk) throws JOSEException {
        if (jwk instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)jwk;
            return new RSASSAVerifier(rsaKey);
        }
        if (jwk instanceof ECKey) {
            ECKey ecKey = (ECKey)jwk;
            return new ECDSAVerifier(ecKey);
        }
        if (jwk instanceof OctetSequenceKey) {
            OctetSequenceKey octetSequenceKey = (OctetSequenceKey)jwk;
            return new MACVerifier(octetSequenceKey);
        }
        throw new JOSEException("Unsupported JWK class [" + (jwk == null ? "null" : jwk.getClass().getCanonicalName()) + "]. Supported classes are [" + RSAKey.class.getCanonicalName() + ", " + ECKey.class.getCanonicalName() + ", " + OctetSequenceKey.class.getCanonicalName() + "].");
    }
}

