/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.IndexQueryCache;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.accesscontrol.FieldExtractor;

public final class OptOutQueryCache
extends IndexQueryCache {
    private static final Logger logger = LogManager.getLogger(IndexQueryCache.class);
    private final ThreadContext context;

    public OptOutQueryCache(Index index, IndicesQueryCache indicesQueryCache, ThreadContext context) {
        super(index, indicesQueryCache);
        this.context = Objects.requireNonNull(context, "threadContext must not be null");
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.context.getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            logger.debug("opting out of the query cache for index [{}]. current request doesn't hold indices permissions", (Object)this.index);
            return weight;
        }
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(this.index.getName());
        if (indexAccessControl != null && indexAccessControl.getFieldPermissions().hasFieldLevelSecurity()) {
            if (OptOutQueryCache.cachingIsSafe(weight, indexAccessControl)) {
                logger.trace("not opting out of the query cache. request for index [{}] is safe to cache", (Object)this.index);
                return super.doCache(weight, policy);
            }
            logger.trace("opting out of the query cache. request for index [{}] is unsafe to cache", (Object)this.index);
            return weight;
        }
        logger.trace("not opting out of the query cache. request for index [{}] has field level security disabled", (Object)this.index);
        return super.doCache(weight, policy);
    }

    static boolean cachingIsSafe(Weight weight, IndicesAccessControl.IndexAccessControl permissions) {
        HashSet<String> fields = new HashSet<String>();
        try {
            FieldExtractor.extractFields(weight.getQuery(), fields);
        }
        catch (UnsupportedOperationException ok) {
            return false;
        }
        for (String field : fields) {
            if (!field.startsWith("_") && permissions.getFieldPermissions().grantsAccessTo(field)) continue;
            return false;
        }
        return true;
    }
}

