/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.ingest;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class SetSecurityUserProcessor
extends AbstractProcessor {
    public static final String TYPE = "set_security_user";
    private final Logger logger = LogManager.getLogger(SetSecurityUserProcessor.class);
    private final SecurityContext securityContext;
    private final Settings settings;
    private final String field;
    private final Set<Property> properties;

    public SetSecurityUserProcessor(String tag, String description, SecurityContext securityContext, Settings settings, String field, Set<Property> properties) {
        super(tag, description);
        this.securityContext = securityContext;
        this.settings = Objects.requireNonNull(settings, "settings object cannot be null");
        if (!((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            this.logger.warn("Creating processor [{}] (tag [{}]) on field [{}] but authentication is not currently enabled on this cluster  - this processor is likely to fail at runtime if it is used", (Object)TYPE, (Object)tag, (Object)field);
        } else if (this.securityContext == null) {
            throw new IllegalArgumentException("Authentication is allowed on this cluster state, but there is no security context");
        }
        this.field = field;
        this.properties = properties;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Authentication authentication = null;
        User user = null;
        if (this.securityContext != null && (authentication = this.securityContext.getAuthentication()) != null) {
            user = authentication.getEffectiveSubject().getUser();
        }
        if (user == null) {
            this.logger.debug("Failed to find active user. SecurityContext=[{}] Authentication=[{}] User=[{}]", (Object)this.securityContext, (Object)authentication, (Object)user);
            if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
                throw new IllegalStateException("There is no authenticated user - the [set_security_user] processor requires an authenticated user");
            }
            throw new IllegalStateException("Security (authentication) is not enabled on this cluster, so there is no active user - the [set_security_user] processor cannot be used without security");
        }
        Object fieldValue = ingestDocument.getFieldValue(this.field, Object.class, true);
        Map userObject = fieldValue instanceof Map ? (Map)fieldValue : new HashMap();
        block10: for (Property property : this.properties) {
            switch (property) {
                case USERNAME: {
                    if (user.principal() == null) continue block10;
                    userObject.put("username", user.principal());
                    break;
                }
                case FULL_NAME: {
                    if (user.fullName() == null) continue block10;
                    userObject.put("full_name", user.fullName());
                    break;
                }
                case EMAIL: {
                    if (user.email() == null) continue block10;
                    userObject.put("email", user.email());
                    break;
                }
                case ROLES: {
                    if (user.roles() == null || user.roles().length == 0) continue block10;
                    userObject.put("roles", Arrays.asList(user.roles()));
                    break;
                }
                case METADATA: {
                    if (user.metadata() == null || user.metadata().isEmpty()) continue block10;
                    userObject.put("metadata", user.metadata());
                    break;
                }
                case API_KEY: {
                    Map<String, Object> apiKeyMetadata;
                    Map apiKeyField;
                    if (!authentication.isApiKey()) continue block10;
                    String apiKey = "api_key";
                    Object existingApiKeyField = userObject.get("api_key");
                    Map map = apiKeyField = existingApiKeyField instanceof Map ? (Map)existingApiKeyField : new HashMap();
                    if (authentication.getAuthenticatingSubject().getMetadata().containsKey("_security_api_key_name")) {
                        apiKeyField.put("name", authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_name"));
                    }
                    if (authentication.getAuthenticatingSubject().getMetadata().containsKey("_security_api_key_id")) {
                        apiKeyField.put("id", authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id"));
                    }
                    if (!(apiKeyMetadata = ApiKeyService.getApiKeyMetadata(authentication)).isEmpty()) {
                        apiKeyField.put("metadata", apiKeyMetadata);
                    }
                    if (apiKeyField.isEmpty()) continue block10;
                    userObject.put("api_key", apiKeyField);
                    break;
                }
                case REALM: {
                    String realmType;
                    String realmKey = "realm";
                    Object existingRealmField = userObject.get("realm");
                    Map realmField = existingRealmField instanceof Map ? (Map)existingRealmField : new HashMap();
                    String realmName = ApiKeyService.getCreatorRealmName(authentication);
                    if (realmName != null) {
                        realmField.put("name", realmName);
                    }
                    if ((realmType = ApiKeyService.getCreatorRealmType(authentication)) != null) {
                        realmField.put("type", realmType);
                    }
                    if (realmField.isEmpty()) continue block10;
                    userObject.put("realm", realmField);
                    break;
                }
                case AUTHENTICATION_TYPE: {
                    if (authentication.getAuthenticationType() == null) continue block10;
                    userObject.put("authentication_type", authentication.getAuthenticationType().toString());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported property [" + property + "]");
                }
            }
        }
        ingestDocument.setFieldValue(this.field, (Object)userObject);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    public static enum Property {
        USERNAME,
        FULL_NAME,
        EMAIL,
        ROLES,
        METADATA,
        API_KEY,
        REALM,
        AUTHENTICATION_TYPE;


        static Property parse(String tag, String value) {
            try {
                return Property.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)SetSecurityUserProcessor.TYPE, (String)tag, (String)"properties", (String)("Property value [" + value + "] is in valid"));
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final Supplier<SecurityContext> securityContext;
        private final Settings settings;

        public Factory(Supplier<SecurityContext> securityContext, Settings settings) {
            this.securityContext = securityContext;
            this.settings = settings;
        }

        public SetSecurityUserProcessor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
            EnumSet<Property> properties;
            String field = ConfigurationUtils.readStringProperty((String)SetSecurityUserProcessor.TYPE, (String)tag, config, (String)"field");
            List propertyNames = ConfigurationUtils.readOptionalList((String)SetSecurityUserProcessor.TYPE, (String)tag, config, (String)"properties");
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String propertyName : propertyNames) {
                    properties.add(Property.parse(tag, propertyName));
                }
            } else {
                properties = EnumSet.allOf(Property.class);
            }
            return new SetSecurityUserProcessor(tag, description, this.securityContext.get(), this.settings, field, properties);
        }
    }
}

