/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;

public class SecurityRestFilter
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final RestHandler restHandler;
    private final AuthenticationService authenticationService;
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final boolean enabled;
    private final ThreadContext threadContext;
    private final boolean extractClientCertificate;

    public SecurityRestFilter(boolean enabled, ThreadContext threadContext, AuthenticationService authenticationService, SecondaryAuthenticator secondaryAuthenticator, RestHandler restHandler, boolean extractClientCertificate) {
        this.enabled = enabled;
        this.threadContext = threadContext;
        this.authenticationService = authenticationService;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.restHandler = restHandler;
        this.extractClientCertificate = extractClientCertificate;
    }

    public boolean allowSystemIndexAccessByDefault() {
        return this.restHandler.allowSystemIndexAccessByDefault();
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (request.method() == RestRequest.Method.OPTIONS) {
            this.restHandler.handleRequest(request, channel, client);
            return;
        }
        if (!this.enabled) {
            this.doHandleRequest(request, channel, client);
            return;
        }
        if (this.extractClientCertificate) {
            HttpChannel httpChannel = request.getHttpChannel();
            SSLEngineUtils.extractClientCertificates(logger, this.threadContext, httpChannel);
        }
        this.authenticationService.authenticate(this.maybeWrapRestRequest(request), (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
            if (authentication == null) {
                logger.trace("No authentication available for REST request [{}]", (Object)request.uri());
            } else {
                logger.trace("Authenticated REST request [{}] as {}", (Object)request.uri(), authentication);
            }
            this.secondaryAuthenticator.authenticateAndAttachToContext(request, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
                if (secondaryAuthentication != null) {
                    logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)request.uri());
                }
                RemoteHostHeader.process(request, this.threadContext);
                try {
                    this.doHandleRequest(request, channel, client);
                }
                catch (Exception e) {
                    this.handleException(ActionType.RequestHandling, request, channel, e);
                }
            }, e -> this.handleException(ActionType.SecondaryAuthentication, request, channel, (Exception)e)));
        }, e -> this.handleException(ActionType.Authentication, request, channel, (Exception)e)));
    }

    private void doHandleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.threadContext.sanitizeHeaders();
        this.restHandler.handleRequest(request, channel, client);
    }

    protected void handleException(final ActionType actionType, RestRequest request, RestChannel channel, Exception e) {
        logger.debug(() -> Strings.format((String)"%s failed for REST request [%s]", (Object[])new Object[]{actionType, request.uri()}), (Throwable)e);
        this.threadContext.sanitizeHeaders();
        final RestStatus restStatus = ExceptionsHelper.status((Throwable)e);
        try {
            channel.sendResponse(new RestResponse(channel, restStatus, e){

                protected boolean skipStackTrace() {
                    return restStatus == RestStatus.UNAUTHORIZED;
                }

                public Map<String, List<String>> filterHeaders(Map<String, List<String>> headers) {
                    if (actionType != ActionType.RequestHandling || restStatus == RestStatus.UNAUTHORIZED || restStatus == RestStatus.FORBIDDEN) {
                        if (headers.containsKey("Warning")) {
                            headers = Maps.copyMapWithRemovedEntry(headers, (Object)"Warning");
                        }
                        if (headers.containsKey("X-elastic-product")) {
                            headers = Maps.copyMapWithRemovedEntry((Map)headers, (Object)"X-elastic-product");
                        }
                    }
                    return headers;
                }
            });
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error(() -> "failed to send failure response for uri [" + request.uri() + "]", (Throwable)inner);
        }
    }

    public boolean canTripCircuitBreaker() {
        return this.restHandler.canTripCircuitBreaker();
    }

    public boolean supportsContentStream() {
        return this.restHandler.supportsContentStream();
    }

    public boolean allowsUnsafeBuffers() {
        return this.restHandler.allowsUnsafeBuffers();
    }

    public List<RestHandler.Route> routes() {
        return this.restHandler.routes();
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest) {
        if (this.restHandler instanceof RestRequestFilter) {
            return ((RestRequestFilter)this.restHandler).getFilteredRequest(restRequest);
        }
        return restRequest;
    }

    public boolean mediaTypesValid(RestRequest request) {
        return this.restHandler.mediaTypesValid(request);
    }

    public static enum ActionType {
        Authentication("Authentication"),
        SecondaryAuthentication("Secondary authentication"),
        RequestHandling("Request handling");

        private final String name;

        private ActionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

