/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestBulkUpdateApiKeyAction
extends ApiKeyBaseRestHandler {
    static final ConstructingObjectParser<BulkUpdateApiKeyRequest, Void> PARSER = new ConstructingObjectParser("bulk_update_api_key_request", a -> new BulkUpdateApiKeyRequest((List)a[0], (List)a[1], (Map)a[2]));

    public RestBulkUpdateApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key/_bulk_update"));
    }

    public String getName() {
        return "xpack_security_bulk_update_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            BulkUpdateApiKeyRequest parsed = (BulkUpdateApiKeyRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)BulkUpdateApiKeyAction.INSTANCE, (ActionRequest)parsed, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("ids", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return RoleDescriptor.parse((String)n, (XContentParser)p, (boolean)false);
        }, new ParseField("role_descriptors", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
    }
}

