/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestQueryApiKeyAction
extends ApiKeyBaseRestHandler {
    private static final ConstructingObjectParser<Payload, Void> PARSER = new ConstructingObjectParser("query_api_key_request_payload", a -> new Payload((QueryBuilder)a[0], (Integer)a[1], (Integer)a[2], (List)a[3], (SearchAfterBuilder)a[4]));

    public RestQueryApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/_query/api_key"), new RestHandler.Route(RestRequest.Method.POST, "/_security/_query/api_key"));
    }

    public String getName() {
        return "xpack_security_query_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        QueryApiKeyRequest queryApiKeyRequest;
        boolean withLimitedBy = request.paramAsBoolean("with_limited_by", false);
        if (request.hasContentOrSourceParam()) {
            Payload payload = (Payload)PARSER.parse(request.contentOrSourceParamParser(), null);
            queryApiKeyRequest = new QueryApiKeyRequest(payload.queryBuilder, payload.from, payload.size, payload.fieldSortBuilders, payload.searchAfterBuilder, withLimitedBy);
        } else {
            queryApiKeyRequest = new QueryApiKeyRequest(null, null, null, null, null, withLimitedBy);
        }
        return channel -> client.execute((ActionType)QueryApiKeyAction.INSTANCE, (ActionRequest)queryApiKeyRequest, (ActionListener)new RestToXContentListener(channel));
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AbstractQueryBuilder.parseTopLevelQuery((XContentParser)p), new ParseField("query", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("from", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("size", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new FieldSortBuilder(p.text());
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                FieldSortBuilder fieldSortBuilder = FieldSortBuilder.fromXContent((XContentParser)p, (String)p.currentName());
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
                return fieldSortBuilder;
            }
            throw new IllegalArgumentException("mal-formatted sort object");
        }, new ParseField("sort", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchAfterBuilder.fromXContent((XContentParser)p), new ParseField("search_after", new String[0]), ObjectParser.ValueType.VALUE_ARRAY);
    }

    private record Payload(@Nullable QueryBuilder queryBuilder, @Nullable Integer from, @Nullable Integer size, @Nullable List<FieldSortBuilder> fieldSortBuilders, @Nullable SearchAfterBuilder searchAfterBuilder) {
    }
}

