/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetRoleMappingsAction
extends SecurityBaseRestHandler {
    public RestGetRoleMappingsAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/role_mapping/").replaces(RestRequest.Method.GET, "/_xpack/security/role_mapping/", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/role_mapping/{name}").replaces(RestRequest.Method.GET, "/_xpack/security/role_mapping/{name}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_get_role_mappings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        return channel -> new GetRoleMappingsRequestBuilder((ElasticsearchClient)client).names(names).execute((ActionListener)new RestBuilderListener<GetRoleMappingsResponse>(channel){

            public RestResponse buildResponse(GetRoleMappingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (ExpressionRoleMapping mapping : response.mappings()) {
                    builder.field(mapping.getName(), (ToXContent)mapping);
                }
                builder.endObject();
                if (names.length != 0 && response.mappings().length == 0) {
                    return new RestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }
}

