/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.support.ApiKeyFieldNameTranslators;

public class ApiKeyBoolQueryBuilder
extends BoolQueryBuilder {
    private static final Set<String> ALLOWED_EXACT_INDEX_FIELD_NAMES = Set.of("_id", "doc_type", "name", "api_key_invalidated", "creation_time", "expiration_time");

    private ApiKeyBoolQueryBuilder() {
    }

    public static ApiKeyBoolQueryBuilder build(QueryBuilder queryBuilder, @Nullable Authentication authentication) {
        ApiKeyBoolQueryBuilder finalQuery = new ApiKeyBoolQueryBuilder();
        if (queryBuilder != null) {
            QueryBuilder processedQuery = ApiKeyBoolQueryBuilder.doProcess(queryBuilder);
            finalQuery.must(processedQuery);
        }
        finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"api_key"));
        if (authentication != null) {
            if (authentication.isApiKey()) {
                String apiKeyId = (String)authentication.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
                assert (apiKeyId != null) : "api key id must be present in the metadata";
                finalQuery.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{apiKeyId}));
            } else {
                finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"creator.principal", (String)authentication.getEffectiveSubject().getUser().principal()));
                String[] realms = ApiKeyService.getOwnersRealmNames(authentication);
                QueryBuilder realmsQuery = ApiKeyService.filterForRealmNames(realms);
                assert (realmsQuery != null);
                finalQuery.filter(realmsQuery);
            }
        }
        return finalQuery;
    }

    private static QueryBuilder doProcess(QueryBuilder qb) {
        if (qb instanceof BoolQueryBuilder) {
            BoolQueryBuilder query = (BoolQueryBuilder)qb;
            BoolQueryBuilder newQuery = QueryBuilders.boolQuery().minimumShouldMatch(query.minimumShouldMatch()).adjustPureNegative(query.adjustPureNegative());
            query.must().stream().map(ApiKeyBoolQueryBuilder::doProcess).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).must(arg_0));
            query.should().stream().map(ApiKeyBoolQueryBuilder::doProcess).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).should(arg_0));
            query.mustNot().stream().map(ApiKeyBoolQueryBuilder::doProcess).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).mustNot(arg_0));
            query.filter().stream().map(ApiKeyBoolQueryBuilder::doProcess).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).filter(arg_0));
            return newQuery;
        }
        if (qb instanceof MatchAllQueryBuilder) {
            return qb;
        }
        if (qb instanceof IdsQueryBuilder) {
            return qb;
        }
        if (qb instanceof TermQueryBuilder) {
            TermQueryBuilder query = (TermQueryBuilder)qb;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            return QueryBuilders.termQuery((String)translatedFieldName, (Object)query.value()).caseInsensitive(query.caseInsensitive());
        }
        if (qb instanceof ExistsQueryBuilder) {
            ExistsQueryBuilder query = (ExistsQueryBuilder)qb;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            return QueryBuilders.existsQuery((String)translatedFieldName);
        }
        if (qb instanceof TermsQueryBuilder) {
            TermsQueryBuilder query = (TermsQueryBuilder)qb;
            if (query.termsLookup() != null) {
                throw new IllegalArgumentException("terms query with terms lookup is not supported for API Key query");
            }
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            return QueryBuilders.termsQuery((String)translatedFieldName, (Collection)query.getValues());
        }
        if (qb instanceof PrefixQueryBuilder) {
            PrefixQueryBuilder query = (PrefixQueryBuilder)qb;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            return QueryBuilders.prefixQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive());
        }
        if (qb instanceof WildcardQueryBuilder) {
            WildcardQueryBuilder query = (WildcardQueryBuilder)qb;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            return QueryBuilders.wildcardQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite());
        }
        if (qb instanceof RangeQueryBuilder) {
            RangeQueryBuilder query = (RangeQueryBuilder)qb;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            if (query.relation() != null) {
                throw new IllegalArgumentException("range query with relation is not supported for API Key query");
            }
            RangeQueryBuilder newQuery = QueryBuilders.rangeQuery((String)translatedFieldName);
            if (query.format() != null) {
                newQuery.format(query.format());
            }
            if (query.timeZone() != null) {
                newQuery.timeZone(query.timeZone());
            }
            if (query.from() != null) {
                newQuery.from(query.from()).includeLower(query.includeLower());
            }
            if (query.to() != null) {
                newQuery.to(query.to()).includeUpper(query.includeUpper());
            }
            return newQuery.boost(query.boost());
        }
        throw new IllegalArgumentException("Query type [" + qb.getName() + "] is not supported for API Key query");
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.setAllowedFields(ApiKeyBoolQueryBuilder::isIndexFieldNameAllowed);
        return super.doToQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext instanceof SearchExecutionContext) {
            ((SearchExecutionContext)queryRewriteContext).setAllowedFields(ApiKeyBoolQueryBuilder::isIndexFieldNameAllowed);
        }
        return super.doRewrite(queryRewriteContext);
    }

    static boolean isIndexFieldNameAllowed(String fieldName) {
        return ALLOWED_EXACT_INDEX_FIELD_NAMES.contains(fieldName) || fieldName.startsWith("metadata_flattened.") || fieldName.startsWith("creator.");
    }
}

