/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TcpTransport;

public class RemoteClusterAuthorizationResolver {
    private static final Logger LOGGER = LogManager.getLogger(RemoteClusterAuthorizationResolver.class);
    private final Map<String, String> apiKeys = ConcurrentCollections.newConcurrentMap();

    public RemoteClusterAuthorizationResolver(Settings settings, ClusterSettings clusterSettings) {
        if (TcpTransport.isUntrustedRemoteClusterEnabled()) {
            for (Map.Entry entry : RemoteClusterService.REMOTE_CLUSTER_AUTHORIZATION.getAsMap(settings).entrySet()) {
                if (Strings.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                this.updateAuthorization((String)entry.getKey(), (String)entry.getValue());
            }
            clusterSettings.addAffixUpdateConsumer(RemoteClusterService.REMOTE_CLUSTER_AUTHORIZATION, this::updateAuthorization, (clusterAlias, authorization) -> {});
        }
    }

    public String resolveAuthorization(String clusterAlias) {
        if (TcpTransport.isUntrustedRemoteClusterEnabled()) {
            return this.apiKeys.get(clusterAlias);
        }
        return null;
    }

    private void updateAuthorization(String clusterAlias, String authorization) {
        if (Strings.isEmpty((CharSequence)authorization)) {
            this.apiKeys.remove(clusterAlias);
            LOGGER.debug("Authorization value for clusterAlias {} removed", (Object)clusterAlias);
        } else {
            boolean notFound = Strings.isEmpty((CharSequence)this.apiKeys.put(clusterAlias, authorization));
            LOGGER.debug("Authorization value for clusterAlias {} {}", (Object)clusterAlias, (Object)(notFound ? "added" : "updated"));
        }
    }
}

