/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.RemoteAccessAuthentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.PreAuthorizationUtils;
import org.elasticsearch.xpack.security.transport.RemoteClusterAuthorizationResolver;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    public static final String REMOTE_ACCESS_CLUSTER_CREDENTIAL_HEADER_KEY = "_remote_access_cluster_credential";
    private static final TransportVersion VERSION_REMOTE_ACCESS_HEADERS = TransportVersion.V_8_7_0;
    private static final Logger logger = LogManager.getLogger(SecurityServerTransportInterceptor.class);
    static final Set<String> REMOTE_ACCESS_ACTION_ALLOWLIST;
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;
    private final RemoteClusterAuthorizationResolver remoteClusterAuthorizationResolver;
    private final Function<Transport.Connection, Optional<String>> remoteClusterAliasResolver;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, RemoteClusterAuthorizationResolver remoteClusterAuthorizationResolver) {
        this(settings, threadPool, authcService, authzService, sslService, securityContext, destructiveOperations, remoteClusterAuthorizationResolver, RemoteConnectionManager::resolveRemoteClusterAlias);
    }

    SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, RemoteClusterAuthorizationResolver remoteClusterAuthorizationResolver, Function<Transport.Connection, Optional<String>> remoteClusterAliasResolver) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
        this.remoteClusterAuthorizationResolver = remoteClusterAuthorizationResolver;
        this.remoteClusterAliasResolver = remoteClusterAliasResolver;
    }

    public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
        return this.interceptForAllRequests(TcpTransport.isUntrustedRemoteClusterEnabled() ? this.interceptForRemoteAccessRequests(sender) : sender);
    }

    private TransportInterceptor.AsyncSender interceptForAllRequests(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                this.assertNoRemoteAccessHeadersInContext();
                Optional<String> remoteClusterAlias = SecurityServerTransportInterceptor.this.remoteClusterAliasResolver.apply(connection);
                if (PreAuthorizationUtils.shouldRemoveParentAuthorizationFromThreadContext(remoteClusterAlias, action, SecurityServerTransportInterceptor.this.securityContext)) {
                    SecurityServerTransportInterceptor.this.securityContext.executeAfterRemovingParentAuthorization(original -> SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler)));
                } else {
                    SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, handler);
                }
            }

            private void assertNoRemoteAccessHeadersInContext() {
                assert (SecurityServerTransportInterceptor.this.securityContext.getThreadContext().getHeader(SecurityServerTransportInterceptor.REMOTE_ACCESS_CLUSTER_CREDENTIAL_HEADER_KEY) == null) : "remote access headers should not be in security context";
                assert (SecurityServerTransportInterceptor.this.securityContext.getThreadContext().getHeader("_remote_access_authentication") == null) : "remote access headers should not be in security context";
            }
        };
    }

    public <T extends TransportResponse> void sendRequestInner(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TransportVersion minVersion = TransportVersion.min((TransportVersion)connection.getTransportVersion(), (TransportVersion)TransportVersion.CURRENT);
        if (AuthorizationUtils.shouldReplaceUserWithSystem(this.threadPool.getThreadContext(), action)) {
            this.securityContext.executeAsSystemUser(minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(this.threadPool.getThreadContext())) {
            AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(this.threadPool.getThreadContext(), this.securityContext, minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (this.securityContext.getAuthentication() != null && !this.securityContext.getAuthentication().getEffectiveSubject().getTransportVersion().equals((Object)minVersion)) {
            this.securityContext.executeAfterRewritingAuthentication(original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender), minVersion);
        } else {
            this.sendWithUser(connection, action, request, options, handler, sender);
        }
    }

    Map<String, ServerTransportFilter> getProfileFilters() {
        return this.profileFilters;
    }

    private TransportInterceptor.AsyncSender interceptForRemoteAccessRequests(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                Optional<RemoteAccessCredentials> remoteAccessCredentials = this.getRemoteAccessCredentials(connection, action);
                if (remoteAccessCredentials.isPresent()) {
                    this.sendWithRemoteAccessHeaders(remoteAccessCredentials.get(), connection, action, request, options, handler);
                } else {
                    try {
                        sender.sendRequest(connection, action, request, options, handler);
                    }
                    catch (Exception e) {
                        handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
                    }
                }
            }

            private Optional<RemoteAccessCredentials> getRemoteAccessCredentials(Transport.Connection connection, String action) {
                Optional<String> optionalRemoteClusterAlias = SecurityServerTransportInterceptor.this.remoteClusterAliasResolver.apply(connection);
                if (optionalRemoteClusterAlias.isEmpty()) {
                    logger.trace("Connection is not remote");
                    return Optional.empty();
                }
                String remoteClusterAlias = optionalRemoteClusterAlias.get();
                String remoteClusterCredential = SecurityServerTransportInterceptor.this.remoteClusterAuthorizationResolver.resolveAuthorization(remoteClusterAlias);
                if (remoteClusterCredential == null) {
                    logger.trace("No cluster credential is configured for remote cluster [{}]", (Object)remoteClusterAlias);
                    return Optional.empty();
                }
                if (!REMOTE_ACCESS_ACTION_ALLOWLIST.contains(action)) {
                    logger.trace("Action [{}] towards remote cluster [{}] is not allow-listed", (Object)action, (Object)remoteClusterAlias);
                    return Optional.empty();
                }
                Authentication authentication = SecurityServerTransportInterceptor.this.securityContext.getAuthentication();
                assert (authentication != null) : "authentication must be present in security context";
                Subject effectiveSubject = authentication.getEffectiveSubject();
                if (!effectiveSubject.getType().equals((Object)Subject.Type.USER)) {
                    logger.trace("Effective subject of request to remote cluster [{}] has an unsupported type [{}]", (Object)remoteClusterAlias, (Object)effectiveSubject.getType());
                    return Optional.empty();
                }
                return Optional.of(new RemoteAccessCredentials(remoteClusterAlias, remoteClusterCredential));
            }

            private <T extends TransportResponse> void sendWithRemoteAccessHeaders(RemoteAccessCredentials remoteAccessCredentials, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                String remoteClusterAlias = remoteAccessCredentials.clusterAlias();
                if (connection.getTransportVersion().before(VERSION_REMOTE_ACCESS_HEADERS)) {
                    throw new IllegalArgumentException("Settings for remote cluster [" + remoteClusterAlias + "] indicate remote access headers should be sent but target cluster version [" + connection.getTransportVersion() + "] does not support receiving them");
                }
                logger.debug("Sending [{}] request to [{}] with remote access headers for [{}] action", request.getClass(), (Object)remoteClusterAlias, (Object)action);
                Authentication authentication = SecurityServerTransportInterceptor.this.securityContext.getAuthentication();
                assert (authentication != null) : "authentication must be present in security context";
                ThreadContext threadContext = SecurityServerTransportInterceptor.this.securityContext.getThreadContext();
                TransportService.ContextRestoreResponseHandler contextRestoreHandler = new TransportService.ContextRestoreResponseHandler(threadContext.newRestorableContext(true), handler);
                User user = authentication.getEffectiveSubject().getUser();
                if (SystemUser.is((User)user)) {
                    try (ThreadContext.StoredContext ignored = threadContext.stashContext();){
                        remoteAccessCredentials.writeToContext(threadContext);
                        new RemoteAccessAuthentication(authentication, RoleDescriptorsIntersection.EMPTY).writeToContext(threadContext);
                        sender.sendRequest(connection, action, request, options, (TransportResponseHandler)contextRestoreHandler);
                    }
                    catch (IOException e2) {
                        contextRestoreHandler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e2));
                    }
                } else {
                    if (User.isInternal((User)user)) {
                        String message = "internal user [" + user.principal() + "] should not be used for cross cluster requests";
                        assert (false) : message;
                        throw new IllegalArgumentException(message);
                    }
                    SecurityServerTransportInterceptor.this.authzService.retrieveRemoteAccessRoleDescriptorsIntersection(remoteClusterAlias, authentication.getEffectiveSubject(), (ActionListener<RoleDescriptorsIntersection>)ActionListener.wrap(roleDescriptorsIntersection -> {
                        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                            remoteAccessCredentials.writeToContext(threadContext);
                            new RemoteAccessAuthentication(authentication, roleDescriptorsIntersection).writeToContext(threadContext);
                            sender.sendRequest(connection, action, request, options, (TransportResponseHandler)contextRestoreHandler);
                        }
                    }, e -> contextRestoreHandler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e))));
                }
            }

            record RemoteAccessCredentials(String clusterAlias, String credentials) {
                void writeToContext(ThreadContext ctx) {
                    ctx.putHeader(SecurityServerTransportInterceptor.REMOTE_ACCESS_CLUSTER_CREDENTIAL_HEADER_KEY, this.withApiKeyPrefix(this.credentials));
                }

                private String withApiKeyPrefix(String clusterCredential) {
                    return "ApiKey " + clusterCredential;
                }
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            this.assertNoAuthentication(action);
            throw new IllegalStateException("there should always be a user when sending a message for action [" + action + "]");
        }
        assert (this.securityContext.getParentAuthorization() == null || !this.remoteClusterAliasResolver.apply(connection).isPresent()) : "parent authorization header should not be set for remote cluster requests";
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
        }
    }

    void assertNoAuthentication(String action) {
        assert (false) : "there should always be a user when sending a message for action [" + action + "]";
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.threadPool);
    }

    private Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        Map<String, SslConfiguration> profileConfigurations = ProfileConfigurations.get(this.settings, this.sslService, false);
        Map profileFilters = Maps.newMapWithExpectedSize((int)(profileConfigurations.size() + 1));
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        boolean remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_PORT_ENABLED.get(this.settings);
        boolean remoteClusterSSLEnabled = remoteClusterPortEnabled && (Boolean)XPackSettings.REMOTE_CLUSTER_SSL_ENABLED.get(this.settings) != false;
        for (Map.Entry<String, SslConfiguration> entry : profileConfigurations.entrySet()) {
            SslConfiguration profileConfiguration = entry.getValue();
            String profileName = entry.getKey();
            boolean extractClientCert = remoteClusterPortEnabled && "_remote_cluster".equals(profileName) ? remoteClusterSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration) : transportSSLEnabled && SSLService.isSSLClientAuthEnabled((SslConfiguration)profileConfiguration);
            profileFilters.put(profileName, new ServerTransportFilter(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.securityContext));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    static {
        Stream<String> actions = Stream.of("indices:data/read/search", "cluster:monitor/state", "indices:admin/shards/search_shards", "indices:data/read/search[free_context/scroll]", "indices:data/read/search[free_context]", "indices:data/read/search[clear_scroll_contexts]", "indices:data/read/search[phase/dfs]", "indices:data/read/search[phase/query]", "indices:data/read/search[phase/query/id]", "indices:data/read/search[phase/query/scroll]", "indices:data/read/search[phase/query+fetch/scroll]", "indices:data/read/search[phase/fetch/id/scroll]", "indices:data/read/search[phase/fetch/id]", "indices:data/read/search[can_match]", "indices:data/read/search[can_match][n]");
        REMOTE_ACCESS_ACTION_ALLOWLIST = actions.flatMap(name -> Stream.of(name, TransportActionProxy.getProxyAction((String)name))).collect(Collectors.toUnmodifiableSet());
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final ThreadContext threadContext;
        private final String executorName;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, String executorName, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executorName = executorName;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            RunOnce releaseRequest = new RunOnce(() -> request.decRef());
            request.incRef();
            return new AbstractRunnable((TransportRequest)request, task, (Runnable)releaseRequest){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                final /* synthetic */ Runnable val$releaseRequest;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                    this.val$releaseRequest = runnable;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }

                public void onAfter() {
                    this.val$releaseRequest.run();
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + "', executorName='" + this.executorName + "', forceExecution=" + this.forceExecution + "}";
        }

        public void messageReceived(T request, TransportChannel channel, Task task) {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContextPreservingResponseHeaders();){
                AbstractFilterListener filterListener;
                String profile = channel.getProfileName();
                ServerTransportFilter filter = this.profileFilters.get(profile);
                if (filter == null) {
                    if (".direct".equals(profile)) {
                        filter = this.profileFilters.get("default");
                    } else {
                        String msg = "transport profile [" + profile + "] is not associated with a transport filter";
                        throw new IllegalStateException(msg);
                    }
                }
                assert (filter != null);
                AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
                if ("same".equals(this.executorName)) {
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            this.receiveMessage.run();
                        }
                    };
                } else {
                    final Thread executingThread = Thread.currentThread();
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            if (executingThread == Thread.currentThread()) {
                                this.receiveMessage.run();
                            } else {
                                try {
                                    threadPool.executor(executorName).execute((Runnable)this.receiveMessage);
                                }
                                catch (Exception e) {
                                    this.onFailure(e);
                                }
                            }
                        }
                    };
                }
                filter.inbound(this.action, (TransportRequest)request, channel, filterListener);
            }
        }
    }

    private static abstract class AbstractFilterListener
    implements ActionListener<Void> {
        protected final AbstractRunnable receiveMessage;

        protected AbstractFilterListener(AbstractRunnable receiveMessage) {
            this.receiveMessage = receiveMessage;
        }

        public void onFailure(Exception e) {
            try {
                this.receiveMessage.onFailure(e);
            }
            finally {
                this.receiveMessage.onAfter();
            }
        }
    }
}

