/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.jacoco.KotlinFileLocator;
import org.sonar.plugins.jacoco.ReversePathTree;

public class FileLocator {
    private final ReversePathTree tree = new ReversePathTree();
    private final KotlinFileLocator kotlinFileLocator;

    public FileLocator(Iterable<InputFile> inputFiles, KotlinFileLocator kotlinFileLocator) {
        this(StreamSupport.stream(inputFiles.spliterator(), false).collect(Collectors.toList()), kotlinFileLocator);
    }

    public FileLocator(List<InputFile> inputFiles, KotlinFileLocator kotlinFileLocator) {
        this.kotlinFileLocator = kotlinFileLocator;
        for (InputFile inputFile : inputFiles) {
            String[] path = inputFile.relativePath().split("/");
            this.tree.index(inputFile, path);
        }
    }

    @CheckForNull
    public InputFile getInputFile(String packagePath, String fileName) {
        Object filePath = packagePath.isEmpty() ? fileName : packagePath + "/" + fileName;
        String[] path = ((String)filePath).split("/");
        InputFile fileWithSuffix = this.tree.getFileWithSuffix(path);
        if (fileWithSuffix == null && fileName.endsWith(".kt")) {
            fileWithSuffix = this.kotlinFileLocator.getInputFile(packagePath, fileName);
        }
        return fileWithSuffix;
    }
}

