/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.stax;

import java.util.Collections;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.kotlin.com.fasterxml.aalto.UncheckedStreamException;
import org.jetbrains.kotlin.com.fasterxml.aalto.WFCException;
import org.jetbrains.kotlin.com.fasterxml.aalto.impl.ErrorConsts;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.InputBootstrapper;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.PName;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ReaderConfig;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.XmlScanner;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.TextAccumulator;
import org.jetbrains.kotlin.org.codehaus.stax2.LocationInfo;
import org.jetbrains.kotlin.org.codehaus.stax2.XMLStreamLocation2;
import org.jetbrains.kotlin.org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.kotlin.org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.jetbrains.kotlin.org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.jetbrains.kotlin.org.codehaus.stax2.typed.TypedValueDecoder;
import org.jetbrains.kotlin.org.codehaus.stax2.typed.TypedXMLStreamException;

public class StreamReaderImpl
implements LocationInfo,
XMLStreamReader2 {
    protected final XmlScanner _scanner;
    protected final boolean _cfgCoalesceText;
    protected final boolean _cfgReportTextAsChars;
    protected int _currToken;
    protected int _parseState;
    protected PName _currName;
    protected int _attrCount;
    protected ValueDecoderFactory _decoderFactory;
    protected CharArrayBase64Decoder _base64Decoder = null;
    protected PName _dtdRootName;

    public StreamReaderImpl(XmlScanner scanner) {
        this._scanner = scanner;
        this._currToken = 7;
        ReaderConfig cfg = scanner.getConfig();
        this._cfgCoalesceText = cfg.willCoalesceText();
        this._cfgReportTextAsChars = !cfg.willReportCData();
    }

    public static StreamReaderImpl construct(InputBootstrapper bs) throws XMLStreamException {
        return new StreamReaderImpl(bs.bootstrap());
    }

    @Override
    public final String getCharacterEncodingScheme() {
        return this._scanner.getConfig().getXmlDeclEncoding();
    }

    @Override
    public final String getEncoding() {
        return this._scanner.getConfig().getActualEncoding();
    }

    @Override
    public String getVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    @Override
    public final boolean isStandalone() {
        return this._scanner.getConfig().getXmlDeclStandalone() == 1;
    }

    @Override
    public final boolean standaloneSet() {
        return this._scanner.getConfig().getXmlDeclStandalone() != 0;
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("javax.xml.stream.entities")) {
            return Collections.EMPTY_LIST;
        }
        if (name.equals("javax.xml.stream.notations")) {
            return Collections.EMPTY_LIST;
        }
        return this._scanner.getConfig().getProperty(name, false);
    }

    @Override
    public final int getAttributeCount() {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._attrCount;
    }

    @Override
    public final String getAttributeLocalName(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrLocalName(index2);
    }

    @Override
    public final QName getAttributeName(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrQName(index2);
    }

    @Override
    public final String getAttributeNamespace(int index2) {
        String p;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return (p = this._scanner.getAttrNsURI(index2)) == null ? "" : p;
    }

    @Override
    public final String getAttributePrefix(int index2) {
        String p;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return (p = this._scanner.getAttrPrefix(index2)) == null ? "" : p;
    }

    @Override
    public final String getAttributeType(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrType(index2);
    }

    @Override
    public final String getAttributeValue(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrValue(index2);
    }

    @Override
    public final String getAttributeValue(String nsURI, String localName) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.getAttrValue(nsURI, localName);
    }

    @Override
    public final String getElementText() throws XMLStreamException {
        int type2;
        int type3;
        if (this._currToken != 1) {
            this.throwWfe(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        do {
            if ((type3 = this.next()) != 2) continue;
            return "";
        } while (type3 == 5 || type3 == 3);
        if ((1 << type3 & 0x1250) == 0) {
            this._reportNonTextEvent(type3);
        }
        String text = this._scanner.getText();
        TextAccumulator acc = null;
        while ((type2 = this.next()) != 2) {
            if ((1 << type2 & 0x1250) != 0) {
                if (acc == null) {
                    acc = new TextAccumulator();
                    acc.addText(text);
                }
                acc.addText(this.getText());
                continue;
            }
            if (type2 == 5 || type2 == 3) continue;
            this._reportNonTextEvent(type2);
        }
        return acc == null ? text : acc.getAndClear();
    }

    @Override
    public final int getEventType() {
        if (this._currToken == 12 && (this._cfgCoalesceText || this._cfgReportTextAsChars)) {
            return 4;
        }
        return this._currToken;
    }

    @Override
    public final String getLocalName() {
        if (this._currToken == 1 || this._currToken == 2 || this._currToken == 9) {
            return this._currName.getLocalName();
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    @Override
    public final QName getName() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getQName();
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this._scanner;
    }

    @Override
    public final int getNamespaceCount() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNsCount();
    }

    @Override
    public final String getNamespacePrefix(int index2) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p = this._scanner.getNamespacePrefix(index2);
        return p == null ? "" : p;
    }

    @Override
    public final String getNamespaceURI() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    @Override
    public final String getNamespaceURI(int index2) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI(index2);
        return uri == null ? "" : uri;
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNamespaceURI(prefix);
    }

    @Override
    public final String getPIData() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final String getPITarget() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this._currName.getLocalName();
    }

    @Override
    public final String getPrefix() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p = this._currName.getPrefix();
        return p == null ? "" : p;
    }

    @Override
    public final String getText() {
        if ((1 << this._currToken & 0x1A70) == 0) {
            this.throwNotTextual(this._currToken);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final char[] getTextCharacters() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextCharacters(int srcStart, char[] target, int targetStart, int len) {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters(srcStart, target, targetStart, len);
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextLength() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextLength();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextStart() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        return 0;
    }

    @Override
    public final boolean hasName() {
        return this._currToken == 1 || this._currToken == 2;
    }

    @Override
    public final boolean hasNext() {
        return this._currToken != 8;
    }

    @Override
    public final boolean hasText() {
        return (1 << this._currToken & 0x1A70) != 0;
    }

    @Override
    public final boolean isAttributeSpecified(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.isAttrSpecified(index2);
    }

    @Override
    public final boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public final boolean isEndElement() {
        return this._currToken == 2;
    }

    @Override
    public final boolean isStartElement() {
        return this._currToken == 1;
    }

    @Override
    public final boolean isWhiteSpace() {
        if (this._currToken == 4 || this._currToken == 12) {
            try {
                return this._scanner.isTextWhitespace();
            }
            catch (XMLStreamException sex) {
                throw UncheckedStreamException.createFrom(sex);
            }
        }
        return this._currToken == 6;
    }

    @Override
    public final void require(int type2, String nsUri, String localName) throws XMLStreamException {
        int curr = this._currToken;
        if (curr != type2) {
            if (curr == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    curr = 4;
                }
            } else if (curr == 6) {
                // empty if block
            }
        }
        if (type2 != curr) {
            this.throwWfe("Expected type " + ErrorConsts.tokenTypeDesc(type2) + ", current type " + ErrorConsts.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwWfe("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
            }
            if ((n = this.getLocalName()) != localName && !n.equals(localName)) {
                this.throwWfe("Expected local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwWfe("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(curr) + ")");
            }
            String uri = this.getNamespaceURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwWfe("Expected empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwWfe("Expected namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    @Override
    public final int next() throws XMLStreamException {
        int type2;
        if (this._parseState == 1) {
            int type3 = this._scanner.nextFromTree();
            if (type3 == -1) {
                this.handleTreeEoi();
            }
            this._currToken = type3;
            if (type3 == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    return 4;
                }
            } else {
                this._currName = this._scanner.getName();
                if (type3 == 2) {
                    if (this._scanner.hasEmptyStack()) {
                        this._parseState = 2;
                    }
                } else if (type3 == 1) {
                    this._attrCount = this._scanner.getAttrCount();
                }
            }
            return type3;
        }
        if (this._parseState == 0) {
            type2 = this._scanner.nextFromProlog(true);
            if (type2 == 1) {
                this._parseState = 1;
                this._attrCount = this._scanner.getAttrCount();
            } else if (type2 == 11) {
                if (this._dtdRootName != null) {
                    this.throwWfe("Duplicate DOCTYPE declaration");
                }
                this._dtdRootName = this._scanner.getName();
            }
        } else if (this._parseState == 2) {
            type2 = this._scanner.nextFromProlog(false);
        } else {
            throw new NoSuchElementException();
        }
        if (type2 < 0) {
            return this.handlePrologEoi(this._parseState == 0);
        }
        this._currName = this._scanner.getName();
        this._currToken = type2;
        return this._currToken;
    }

    @Override
    public final int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwWfe("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwWfe("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    @Override
    public final void close() throws XMLStreamException {
        this._closeScanner(false);
    }

    @Override
    public final Location getLocation() {
        return this.getStartLocation();
    }

    @Override
    public final boolean getAttributeAsBoolean(int index2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final int getAttributeAsInt(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    public final void getAttributeAs(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        try {
            this._scanner.decodeAttrValue(index2, tvd);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, this.getAttributeValue(index2));
        }
    }

    @Override
    public final void skipElement() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int nesting = 1;
        while (true) {
            int type2;
            if ((type2 = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type2 == 2 && --nesting == 0) break;
        }
    }

    @Override
    public final LocationInfo getLocationInfo() {
        return this;
    }

    @Override
    public final boolean isEmptyElement() throws XMLStreamException {
        return this._currToken == 1 ? this._scanner.isEmptyTag() : false;
    }

    @Override
    public final void closeCompletely() throws XMLStreamException {
        this._closeScanner(true);
    }

    public final XMLStreamLocation2 getStartLocation() {
        return this._scanner.getStartLocation();
    }

    protected void _reportNonTextEvent(int type2) throws XMLStreamException {
        this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type2) + ".");
    }

    protected Location getLastCharLocation() {
        return this._scanner.getCurrentLocation();
    }

    protected int handlePrologEoi(boolean isProlog) throws XMLStreamException {
        this.close();
        if (isProlog) {
            this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_PROLOG);
        }
        return 8;
    }

    protected void handleTreeEoi() throws XMLStreamException {
        this._currToken = 8;
        this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_TREE);
    }

    protected void throwWfe(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getLastCharLocation());
    }

    private void throwNotTextual(int type2) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    private void throwNotTextXxx(int type2) {
        throw new IllegalStateException("getTextXxx() methods can not be called on " + ErrorConsts.tokenTypeDesc(this._currToken));
    }

    protected void throwUnexpectedEOI(String msg) throws XMLStreamException {
        this.throwWfe("Unexpected End-of-input" + msg);
    }

    private TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, iae.getMessage(), this.getStartLocation(), iae);
    }

    protected void reportInvalidAttrIndex(int index2) {
        throw new IllegalArgumentException("Illegal attribute index, " + index2 + ", current START_ELEMENT has " + this._attrCount + " attributes");
    }

    protected void _closeScanner(boolean forceStreamClose) throws XMLStreamException {
        if (this._parseState != 3) {
            this._parseState = 3;
            if (this._currToken != 8) {
                this._currToken = 8;
            }
        }
        this._scanner.close(forceStreamClose);
    }

    protected final ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    public final String toString() {
        return "[Aalto stream reader, scanner: " + this._scanner + "]";
    }
}

