/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\b\u00a8\u0006\t"}, d2={"createSynthesizedFunctionWithFirstParameterAsReceiver", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptor", "createSynthesizedInvokes", "", "functions", "isSynthesizedInvoke", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
@SourceDebugExtension(value={"SMAP\nsynthesizedInvokes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 synthesizedInvokes.kt\norg/jetbrains/kotlin/resolve/calls/tasks/SynthesizedInvokesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1549#2:96\n1620#2,3:97\n*S KotlinDebug\n*F\n+ 1 synthesizedInvokes.kt\norg/jetbrains/kotlin/resolve/calls/tasks/SynthesizedInvokesKt\n*L\n79#1:96\n79#1:97,3\n*E\n"})
public final class SynthesizedInvokesKt {
    @NotNull
    public static final Collection<FunctionDescriptor> createSynthesizedInvokes(@NotNull Collection<? extends FunctionDescriptor> functions2) {
        Intrinsics.checkNotNullParameter(functions2, "functions");
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>(1);
        for (FunctionDescriptor functionDescriptor : functions2) {
            FunctionDescriptor functionDescriptor2;
            if (!Intrinsics.areEqual(functionDescriptor.getName(), OperatorNameConventions.INVOKE) || functionDescriptor.getValueParameters().isEmpty()) continue;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassId containerClassId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)declarationDescriptor));
            if (containerClassId != null && FunctionTypesKt.isBuiltinFunctionClass(containerClassId)) {
                functionDescriptor2 = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(functionDescriptor);
            } else {
                FunctionDescriptor fakeOverride;
                FunctionDescriptor invokeDeclaration;
                Collection<? extends FunctionDescriptor> collection = functionDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, "invoke.overriddenDescriptors");
                if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)collection) == null) {
                    throw new IllegalStateException(("No single overridden invoke for " + functionDescriptor + ": " + functionDescriptor.getOverriddenDescriptors()).toString());
                }
                FunctionDescriptor synthesizedSuperFun = SynthesizedInvokesKt.createSynthesizedFunctionWithFirstParameterAsReceiver(invokeDeclaration);
                Intrinsics.checkNotNullExpressionValue(synthesizedSuperFun.copy(functionDescriptor.getContainingDeclaration(), synthesizedSuperFun.getModality(), synthesizedSuperFun.getVisibility(), CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false), "synthesizedSuperFun.copy\u2026 = */ false\n            )");
                DescriptorUtilsKt.setSingleOverridden(fakeOverride, synthesizedSuperFun);
                functionDescriptor2 = fakeOverride;
            }
            FunctionDescriptor synthesized = functionDescriptor2;
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor);
            FunctionDescriptor functionDescriptor3 = synthesized.substitute(TypeSubstitutor.create(receiverParameterDescriptor.getType()));
            if (functionDescriptor3 == null) continue;
            result2.add(functionDescriptor3);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final FunctionDescriptor createSynthesizedFunctionWithFirstParameterAsReceiver(FunctionDescriptor descriptor2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CallableMemberDescriptor.CopyBuilder copyBuilder;
        CallableMemberDescriptor.CopyBuilder $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u241 = copyBuilder = descriptor2.getOriginal().newCopyBuilder();
        boolean bl = false;
        CallableDescriptor callableDescriptor = descriptor2.getOriginal();
        List<ValueParameterDescriptor> list2 = descriptor2.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "descriptor.original.valueParameters");
        $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u241.setExtensionReceiverParameter(DescriptorFactory.createExtensionReceiverParameterForCallable(callableDescriptor, CollectionsKt.first(list2).getType(), Annotations.Companion.getEMPTY()));
        List<ValueParameterDescriptor> list3 = descriptor2.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "descriptor.original.valueParameters");
        Iterable iterable = CollectionsKt.drop((Iterable)list3, 1);
        CallableMemberDescriptor.CopyBuilder copyBuilder2 = $this$createSynthesizedFunctionWithFirstParameterAsReceiver_u24lambda_u241;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue(functionDescriptor, "descriptor.original");
            CallableDescriptor callableDescriptor2 = functionDescriptor;
            Name name = Name.identifier("" + 'p' + (p.getIndex() + 1));
            Intrinsics.checkNotNullExpressionValue(name, "identifier(\"p${p.index + 1}\")");
            collection.add(p.copy(callableDescriptor2, name, p.getIndex() - 1));
        }
        copyBuilder2.setValueParameters((List)destination$iv$iv);
        CallableMemberDescriptor callableMemberDescriptor = copyBuilder.build();
        Intrinsics.checkNotNull(callableMemberDescriptor);
        return callableMemberDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSynthesizedInvoke(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!Intrinsics.areEqual(descriptor2.getName(), OperatorNameConventions.INVOKE)) return false;
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor real = (FunctionDescriptor)descriptor2;
        while (!real.getKind().isReal()) {
            Collection<? extends FunctionDescriptor> collection = real.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "real.overriddenDescriptors");
            if ((FunctionDescriptor)CollectionsKt.singleOrNull((Iterable)collection) != null) continue;
            return false;
        }
        if (real.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        DeclarationDescriptor declarationDescriptor = real.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "real.containingDeclaration");
        if (FunctionTypesKt.getFunctionTypeKind(declarationDescriptor) == null) return false;
        return true;
    }
}

