/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.util.AnalysisExceptionsKt;
import org.jetbrains.kotlin.util.FileAnalysisException;
import org.jetbrains.kotlin.util.SourceCodeAnalysisException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a%\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\"\u0010\u0015\u001a\u00020\u0014*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0002\u001a@\u0010\u001a\u001a\u00020\u0006*\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u000b2 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001f0\u001d\u001a\u0014\u0010 \u001a\u00020\u0006*\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u000b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"asQuote", "", "", "getAsQuote", "(Ljava/lang/CharSequence;)Ljava/lang/String;", "classNameAndMessage", "", "getClassNameAndMessage", "(Ljava/lang/Throwable;)Ljava/lang/String;", "reportFileMismatch", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "fileSource", "cause", "withSourceCodeAnalysisExceptionUnwrapping", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isDefinitelyNotInsideFile", "", "isInside", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "other", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "wrapIntoFileAnalysisExceptionIfNeeded", "filePath", "linesMapping", "Lkotlin/Function1;", "", "Lkotlin/Pair;", "wrapIntoSourceCodeAnalysisExceptionIfNeeded", "element", "frontend.common"})
@SourceDebugExtension(value={"SMAP\nAnalysisExceptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisExceptions.kt\norg/jetbrains/kotlin/util/AnalysisExceptionsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n1247#2,2:108\n*S KotlinDebug\n*F\n+ 1 AnalysisExceptions.kt\norg/jetbrains/kotlin/util/AnalysisExceptionsKt\n*L\n97#1:108,2\n*E\n"})
public final class AnalysisExceptionsKt {
    @NotNull
    public static final String getClassNameAndMessage(@NotNull Throwable $this$classNameAndMessage) {
        Intrinsics.checkNotNullParameter($this$classNameAndMessage, "<this>");
        return Reflection.getOrCreateKotlinClass($this$classNameAndMessage.getClass()).getQualifiedName() + ": " + $this$classNameAndMessage.getMessage();
    }

    @NotNull
    public static final Throwable wrapIntoSourceCodeAnalysisExceptionIfNeeded(@NotNull Throwable $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded, @Nullable KtSourceElement element) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter($this$wrapIntoSourceCodeAnalysisExceptionIfNeeded, "<this>");
        Throwable throwable2 = $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        if (throwable2 instanceof SourceCodeAnalysisException) {
            throwable = $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        } else if (throwable2 instanceof IndexNotReadyException) {
            throwable = $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        } else if (throwable2 instanceof ControlFlowException) {
            throwable = $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        } else if (throwable2 instanceof VirtualMachineError) {
            throwable = $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        } else {
            KtSourceElement ktSourceElement = element;
            throwable = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind ? (Throwable)new SourceCodeAnalysisException(element, $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded) : $this$wrapIntoSourceCodeAnalysisExceptionIfNeeded;
        }
        return throwable;
    }

    @NotNull
    public static final Throwable wrapIntoFileAnalysisExceptionIfNeeded(@NotNull Throwable $this$wrapIntoFileAnalysisExceptionIfNeeded, @Nullable String filePath, @Nullable KtSourceElement fileSource, @NotNull Function1<? super Integer, Pair<Integer, Integer>> linesMapping) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter($this$wrapIntoFileAnalysisExceptionIfNeeded, "<this>");
        Intrinsics.checkNotNullParameter(linesMapping, "linesMapping");
        if (filePath == null || fileSource == null) {
            if ($this$wrapIntoFileAnalysisExceptionIfNeeded instanceof SourceCodeAnalysisException) {
                throw new IllegalStateException("Sourceless FirFile contains a FirElement with a real source element".toString());
            }
            throwable = $this$wrapIntoFileAnalysisExceptionIfNeeded;
        } else {
            throwable = $this$wrapIntoFileAnalysisExceptionIfNeeded instanceof SourceCodeAnalysisException ? (Intrinsics.areEqual(fileSource, ((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getSource()) ? (Throwable)new FileAnalysisException(filePath, ((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getCause(), null, 4, null) : (AnalysisExceptionsKt.isDefinitelyNotInsideFile(((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getSource(), fileSource) ? AnalysisExceptionsKt.reportFileMismatch(((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getSource(), fileSource, ((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getCause()) : (Throwable)new FileAnalysisException(filePath, ((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getCause(), linesMapping.invoke((Integer)((SourceCodeAnalysisException)$this$wrapIntoFileAnalysisExceptionIfNeeded).getSource().getStartOffset())))) : ($this$wrapIntoFileAnalysisExceptionIfNeeded instanceof IndexNotReadyException ? $this$wrapIntoFileAnalysisExceptionIfNeeded : ($this$wrapIntoFileAnalysisExceptionIfNeeded instanceof ControlFlowException ? $this$wrapIntoFileAnalysisExceptionIfNeeded : ($this$wrapIntoFileAnalysisExceptionIfNeeded instanceof VirtualMachineError ? $this$wrapIntoFileAnalysisExceptionIfNeeded : (Throwable)new FileAnalysisException(filePath, $this$wrapIntoFileAnalysisExceptionIfNeeded, null, 4, null))));
        }
        return throwable;
    }

    private static final boolean isDefinitelyNotInsideFile(KtSourceElement $this$isDefinitelyNotInsideFile, KtSourceElement fileSource) {
        PsiElement thisPsi = KtSourceElementKt.getPsi($this$isDefinitelyNotInsideFile);
        PsiElement otherPsi = KtSourceElementKt.getPsi(fileSource);
        return thisPsi != null && otherPsi != null ? !Intrinsics.areEqual(thisPsi.getContainingFile(), otherPsi) : !AnalysisExceptionsKt.isInside($this$isDefinitelyNotInsideFile.getLighterASTNode(), fileSource.getLighterASTNode(), $this$isDefinitelyNotInsideFile.getTreeStructure());
    }

    private static final Throwable reportFileMismatch(KtSourceElement source, KtSourceElement fileSource, Throwable cause) {
        String string2;
        PsiElement thisPsi = KtSourceElementKt.getPsi(source);
        PsiElement otherPsi = KtSourceElementKt.getPsi(fileSource);
        CharSequence charSequence = KtSourceElementKt.getText(source);
        String comparison = "This:\n\n" + (charSequence != null ? AnalysisExceptionsKt.getAsQuote(charSequence) : null) + "\n\n...is not present in";
        if (thisPsi != null && otherPsi != null) {
            String string3 = thisPsi.getContainingFile().getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue(string3, "thisPsi.containingFile.virtualFile.path");
            String actualPath = string3;
            String string4 = otherPsi.getContainingFile().getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue(string4, "otherPsi.containingFile.virtualFile.path");
            String expectedPath = string4;
            string2 = expectedPath + ", but rather in " + actualPath;
        } else {
            CharSequence charSequence2 = KtSourceElementKt.getText(fileSource);
            string2 = "..." + (charSequence2 != null ? AnalysisExceptionsKt.getAsQuote(charSequence2) : null);
        }
        String expectedFileMessage = string2;
        return new IllegalStateException("KtSourceElement inside a SourceCodeAnalysisException was matched against the wrong FirFile source. " + comparison + expectedFileMessage, cause);
    }

    private static final String getAsQuote(CharSequence $this$asQuote) {
        String[] stringArray = new String[]{"\n"};
        return CollectionsKt.joinToString$default(StringsKt.split$default($this$asQuote, stringArray, false, 0, 6, null), "\n", null, null, 0, null, asQuote.1.INSTANCE, 30, null);
    }

    private static final boolean isInside(LighterASTNode $this$isInside, LighterASTNode other, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        boolean bl;
        block1: {
            Sequence<LighterASTNode> $this$any$iv = SequencesKt.generateSequence(tree.getParent($this$isInside), (Function1)new Function1<LighterASTNode, LighterASTNode>(tree){
                final /* synthetic */ FlyweightCapableTreeStructure<LighterASTNode> $tree;
                {
                    this.$tree = $tree;
                    super(1);
                }

                @Nullable
                public final LighterASTNode invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$tree.getParent(it);
                }
            });
            boolean $i$f$any = false;
            Iterator<LighterASTNode> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it, other)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final <R> R withSourceCodeAnalysisExceptionUnwrapping(@NotNull Function0<? extends R> block) {
        R r;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withSourceCodeAnalysisExceptionUnwrapping = false;
        try {
            r = block.invoke();
        }
        catch (Throwable throwable) {
            throw throwable instanceof SourceCodeAnalysisException ? ((SourceCodeAnalysisException)throwable).getCause() : throwable;
        }
        return r;
    }
}

