/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.spring;

import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Rule(key="S3439")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3439")
public class DefaultMessageListenerContainerCheck
extends SimpleXPathBasedCheck {
    private XPathExpression defaultMessageListenerContainerBeanExpression = this.getXPathExpression("beans/bean[@class='org.springframework.jms.listener.DefaultMessageListenerContainer']");
    private XPathExpression acceptMessageWhileStoppingPropertyExpression = this.getXPathExpression("property[@name='acceptMessagesWhileStopping']");
    private XPathExpression sessionTransactedPropertyExpression = this.getXPathExpression("property[@name='sessionTransacted']");
    private XPathExpression valueExpression = this.getXPathExpression("value[text()='true']");

    @Override
    public void scanFile(XmlFile xmlFile) {
        this.evaluateAsList(this.defaultMessageListenerContainerBeanExpression, xmlFile.getNamespaceUnawareDocument()).forEach(bean -> {
            if (!this.hasAcceptMessagePropertyEnabled((Node)bean) && this.hasSessionTransactedDisabled((Node)bean)) {
                this.reportIssue((Node)bean, "Enable \"acceptMessagesWhileStopping\".");
            }
        });
    }

    private boolean hasAcceptMessagePropertyEnabled(Node bean) {
        return DefaultMessageListenerContainerCheck.hasAttributeValue(bean, "acceptMessagesWhileStopping") || this.hasPropertyAsChild(bean, this.acceptMessageWhileStoppingPropertyExpression);
    }

    private boolean hasSessionTransactedDisabled(Node bean) {
        return !DefaultMessageListenerContainerCheck.hasAttributeValue(bean, "sessionTransacted") && !this.hasPropertyAsChild(bean, this.sessionTransactedPropertyExpression);
    }

    private static boolean hasAttributeValue(Node bean, String attributeName) {
        NamedNodeMap attributes = bean.getAttributes();
        return IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).anyMatch(attribute -> attribute.getNodeName().endsWith(attributeName) && "true".equals(attribute.getNodeValue()));
    }

    private boolean hasPropertyAsChild(Node bean, XPathExpression expression) {
        return this.evaluateAsList(expression, bean).stream().anyMatch(property -> DefaultMessageListenerContainerCheck.hasAttributeValue(property, "value") || this.evaluate(this.valueExpression, (Node)property).getLength() > 0);
    }
}

