/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class SingleResultDeduplicator<T> {
    private final ThreadContext threadContext;
    private List<ActionListener<T>> waitingListeners;
    private final Consumer<ActionListener<T>> executeAction;

    public SingleResultDeduplicator(ThreadContext threadContext, Consumer<ActionListener<T>> executeAction) {
        this.threadContext = threadContext;
        this.executeAction = executeAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionListener<T> listener) {
        SingleResultDeduplicator singleResultDeduplicator = this;
        synchronized (singleResultDeduplicator) {
            if (this.waitingListeners != null) {
                this.waitingListeners.add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadContext));
                return;
            }
            this.waitingListeners = new ArrayList<ActionListener<T>>();
        }
        this.doExecute(listener);
    }

    private void doExecute(ActionListener<T> listener) {
        ActionListener<T> wrappedListener = ActionListener.runBefore(listener, () -> {
            List<ActionListener<T>> listeners;
            SingleResultDeduplicator singleResultDeduplicator = this;
            synchronized (singleResultDeduplicator) {
                if (this.waitingListeners.isEmpty()) {
                    this.waitingListeners = null;
                    return;
                }
                listeners = this.waitingListeners;
                this.waitingListeners = new ArrayList<ActionListener<T>>();
            }
            this.doExecute(new ActionListener<T>(){

                @Override
                public void onResponse(T response) {
                    ActionListener.onResponse(listeners, response);
                }

                @Override
                public void onFailure(Exception e) {
                    ActionListener.onFailure(listeners, e);
                }
            });
        });
        ActionListener.run(wrappedListener, this.executeAction::accept);
    }
}

