/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.desirednodes.DeleteDesiredNodesAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteDesiredNodesAction
extends TransportMasterNodeAction<DeleteDesiredNodesAction.Request, ActionResponse.Empty> {
    private final ClusterStateTaskExecutor<DeleteDesiredNodesTask> taskExecutor = new DeleteDesiredNodesExecutor();

    @Inject
    public TransportDeleteDesiredNodesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/desired_nodes/delete", transportService, clusterService, threadPool, actionFilters, DeleteDesiredNodesAction.Request::new, indexNameExpressionResolver, in -> ActionResponse.Empty.INSTANCE, "same");
    }

    @Override
    protected void masterOperation(Task task, DeleteDesiredNodesAction.Request request, ClusterState state, ActionListener<ActionResponse.Empty> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("delete-desired-nodes", new DeleteDesiredNodesTask(listener), ClusterStateTaskConfig.build(Priority.HIGH, request.masterNodeTimeout()), this.taskExecutor);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteDesiredNodesAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static class DeleteDesiredNodesExecutor
    extends SimpleBatchedExecutor<DeleteDesiredNodesTask, Void> {
        private DeleteDesiredNodesExecutor() {
        }

        @Override
        public Tuple<ClusterState, Void> executeTask(DeleteDesiredNodesTask task, ClusterState clusterState) {
            return Tuple.tuple((Object)clusterState, null);
        }

        @Override
        public void taskSucceeded(DeleteDesiredNodesTask task, Void unused) {
            task.listener().onResponse(ActionResponse.Empty.INSTANCE);
        }

        @Override
        public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
            return clusterState.copyAndUpdateMetadata(metadata -> metadata.removeCustom("desired_nodes"));
        }
    }

    private record DeleteDesiredNodesTask(ActionListener<ActionResponse.Empty> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

