/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.refresh.UnpromotableShardRefreshRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportUnpromotableShardRefreshAction
extends HandledTransportAction<UnpromotableShardRefreshRequest, ActionResponse.Empty> {
    public static final String NAME = "indices:admin/refresh[u]";
    private final IndicesService indicesService;

    @Inject
    public TransportUnpromotableShardRefreshAction(TransportService transportService, ActionFilters actionFilters, IndicesService indicesService) {
        super(NAME, transportService, actionFilters, UnpromotableShardRefreshRequest::new, "refresh");
        this.indicesService = indicesService;
    }

    @Override
    protected void doExecute(Task task, UnpromotableShardRefreshRequest request, ActionListener<ActionResponse.Empty> responseListener) {
        ActionListener.run(responseListener, listener -> {
            assert (request.getSegmentGeneration() != -1L) : "The request segment is " + request.getSegmentGeneration();
            IndexShard shard = this.indicesService.indexServiceSafe(request.getShardId().getIndex()).getShard(request.getShardId().id());
            shard.waitForSegmentGeneration(request.getSegmentGeneration(), listener.map(l -> ActionResponse.Empty.INSTANCE));
        });
    }
}

