/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesShardStoresAction
extends TransportMasterNodeReadAction<IndicesShardStoresRequest, IndicesShardStoresResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesShardStoresAction.class);
    private final NodeClient client;

    @Inject
    public TransportIndicesShardStoresAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:monitor/shard_stores", transportService, clusterService, threadPool, actionFilters, IndicesShardStoresRequest::new, indexNameExpressionResolver, IndicesShardStoresResponse::new, "same");
        this.client = client;
    }

    @Override
    protected void masterOperation(Task task, IndicesShardStoresRequest request, ClusterState state, ActionListener<IndicesShardStoresResponse> listener) {
        RoutingTable routingTables = state.routingTable();
        RoutingNodes routingNodes = state.getRoutingNodes();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        HashSet<Tuple<ShardId, String>> shardsToFetch = new HashSet<Tuple<ShardId, String>>();
        logger.trace("using cluster state version [{}] to determine shards", (Object)state.version());
        for (String index : concreteIndices) {
            IndexRoutingTable indexShardRoutingTables = routingTables.index(index);
            if (indexShardRoutingTables == null) continue;
            String customDataPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(state.metadata().index(index).getSettings());
            for (int i = 0; i < indexShardRoutingTables.size(); ++i) {
                IndexShardRoutingTable routing = indexShardRoutingTables.shard(i);
                int shardId = routing.shardId().id();
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardId, routing);
                if (!request.shardStatuses().contains(shardHealth.getStatus())) continue;
                shardsToFetch.add((Tuple<ShardId, String>)Tuple.tuple((Object)routing.shardId(), (Object)customDataPath));
            }
        }
        new AsyncShardStoresInfoFetches(state.nodes(), routingNodes, shardsToFetch, listener).start();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesShardStoresRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    private class AsyncShardStoresInfoFetches {
        private final DiscoveryNodes nodes;
        private final RoutingNodes routingNodes;
        private final Set<Tuple<ShardId, String>> shards;
        private final ActionListener<IndicesShardStoresResponse> listener;
        private final RefCountingRunnable refs = new RefCountingRunnable(this::finish);
        private final Queue<InternalAsyncFetch.Response> fetchResponses;

        AsyncShardStoresInfoFetches(DiscoveryNodes nodes, RoutingNodes routingNodes, Set<Tuple<ShardId, String>> shards, ActionListener<IndicesShardStoresResponse> listener) {
            this.nodes = nodes;
            this.routingNodes = routingNodes;
            this.shards = shards;
            this.listener = listener;
            this.fetchResponses = new ConcurrentLinkedQueue<InternalAsyncFetch.Response>();
        }

        void start() {
            try {
                for (Tuple<ShardId, String> shard : this.shards) {
                    new InternalAsyncFetch(logger, "shard_stores", (ShardId)shard.v1(), (String)shard.v2()).fetchData(this.nodes, Collections.emptySet());
                }
            }
            finally {
                this.refs.close();
            }
        }

        private void listStartedShards(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> listener) {
            TransportNodesListGatewayStartedShards.Request request = new TransportNodesListGatewayStartedShards.Request(shardId, customDataPath, nodes);
            TransportIndicesShardStoresAction.this.client.executeLocally(TransportNodesListGatewayStartedShards.TYPE, request, ActionListener.wrap(listener::onResponse, listener::onFailure));
        }

        void finish() {
            HashMap<String, Map> indicesStatuses = new HashMap<String, Map>();
            ArrayList<IndicesShardStoresResponse.Failure> failures = new ArrayList<IndicesShardStoresResponse.Failure>();
            for (InternalAsyncFetch.Response fetchResponse : this.fetchResponses) {
                String indexName = fetchResponse.shardId.getIndexName();
                int shardId = fetchResponse.shardId.id();
                Map indexStatuses = indicesStatuses.computeIfAbsent(indexName, k -> new HashMap());
                List storeStatuses = indexStatuses.computeIfAbsent(shardId, k -> new ArrayList());
                for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards r : fetchResponse.responses) {
                    if (!AsyncShardStoresInfoFetches.shardExistsInNode(r)) continue;
                    IndicesShardStoresResponse.StoreStatus.AllocationStatus allocationStatus = this.getAllocationStatus(indexName, shardId, r.getNode());
                    storeStatuses.add(new IndicesShardStoresResponse.StoreStatus(r.getNode(), r.allocationId(), allocationStatus, r.storeException()));
                }
                for (FailedNodeException failure : fetchResponse.failures) {
                    failures.add(new IndicesShardStoresResponse.Failure(failure.nodeId(), indexName, shardId, failure.getCause()));
                }
            }
            indicesStatuses.replaceAll((k, v) -> {
                v.replaceAll((s, l) -> {
                    CollectionUtil.timSort((List)l);
                    return List.copyOf(l);
                });
                return Map.copyOf(v);
            });
            this.listener.onResponse(new IndicesShardStoresResponse(Map.copyOf(indicesStatuses), List.copyOf(failures)));
        }

        private IndicesShardStoresResponse.StoreStatus.AllocationStatus getAllocationStatus(String index, int shardID, DiscoveryNode node) {
            for (ShardRouting shardRouting : this.routingNodes.node(node.getId())) {
                ShardId shardId = shardRouting.shardId();
                if (shardId.id() != shardID || !shardId.getIndexName().equals(index)) continue;
                if (shardRouting.primary()) {
                    return IndicesShardStoresResponse.StoreStatus.AllocationStatus.PRIMARY;
                }
                if (shardRouting.assignedToNode()) {
                    return IndicesShardStoresResponse.StoreStatus.AllocationStatus.REPLICA;
                }
                return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
            }
            return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
        }

        private static boolean shardExistsInNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response) {
            return response.storeException() != null || response.allocationId() != null;
        }

        private class InternalAsyncFetch
        extends AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> {
            private final Releasable ref;

            InternalAsyncFetch(Logger logger, String type, ShardId shardId, String customDataPath) {
                super(logger, type, shardId, customDataPath);
                this.ref = AsyncShardStoresInfoFetches.this.refs.acquire();
            }

            @Override
            protected synchronized void processAsyncFetch(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures, long fetchingRound) {
                AsyncShardStoresInfoFetches.this.fetchResponses.add(new Response(this.shardId, responses, failures));
                this.ref.close();
            }

            @Override
            protected void list(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> listener) {
                AsyncShardStoresInfoFetches.this.listStartedShards(shardId, customDataPath, nodes, listener);
            }

            @Override
            protected void reroute(ShardId shardId, String reason) {
            }

            public class Response {
                private final ShardId shardId;
                private final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses;
                private final List<FailedNodeException> failures;

                Response(ShardId shardId, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
                    this.shardId = shardId;
                    this.responses = responses;
                    this.failures = failures;
                }
            }
        }
    }
}

