/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.ChunkedBroadcastResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndicesStatsResponse
extends ChunkedBroadcastResponse {
    private final Map<String, ClusterHealthStatus> indexHealthMap;
    private final Map<String, IndexMetadata.State> indexStateMap;
    private final ShardStats[] shards;
    private Map<ShardRouting, ShardStats> shardStatsMap;
    private Map<String, IndexStats> indicesStats;
    private CommonStats total = null;
    private CommonStats primary = null;

    IndicesStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readArray(ShardStats::new, ShardStats[]::new);
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            this.indexHealthMap = in.readMap(StreamInput::readString, ClusterHealthStatus::readFrom);
            this.indexStateMap = in.readMap(StreamInput::readString, IndexMetadata.State::readFrom);
        } else {
            this.indexHealthMap = Map.of();
            this.indexStateMap = Map.of();
        }
    }

    IndicesStatsResponse(ShardStats[] shards, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Metadata metadata, RoutingTable routingTable) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(routingTable);
        Objects.requireNonNull(shards);
        HashMap<String, ClusterHealthStatus> indexHealthModifiableMap = new HashMap<String, ClusterHealthStatus>();
        HashMap<String, IndexMetadata.State> indexStateModifiableMap = new HashMap<String, IndexMetadata.State>();
        for (ShardStats shard : shards) {
            Index index = shard.getShardRouting().index();
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null) continue;
            indexHealthModifiableMap.computeIfAbsent(index.getName(), ignored -> new ClusterIndexHealth(indexMetadata, routingTable.index(index)).getStatus());
            indexStateModifiableMap.computeIfAbsent(index.getName(), ignored -> indexMetadata.getState());
        }
        this.indexHealthMap = Collections.unmodifiableMap(indexHealthModifiableMap);
        this.indexStateMap = Collections.unmodifiableMap(indexStateModifiableMap);
    }

    public Map<ShardRouting, ShardStats> asMap() {
        if (this.shardStatsMap == null) {
            HashMap<ShardRouting, ShardStats> shardStatsMap = new HashMap<ShardRouting, ShardStats>();
            for (ShardStats ss : this.shards) {
                shardStatsMap.put(ss.getShardRouting(), ss);
            }
            this.shardStatsMap = Collections.unmodifiableMap(shardStatsMap);
        }
        return this.shardStatsMap;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    public IndexStats getIndex(String index) {
        return this.getIndices().get(index);
    }

    public Map<String, IndexStats> getIndices() {
        if (this.indicesStats != null) {
            return this.indicesStats;
        }
        HashMap<String, IndexStats.IndexStatsBuilder> indexToIndexStatsBuilder = new HashMap<String, IndexStats.IndexStatsBuilder>();
        for (ShardStats shard : this.shards) {
            Index index = shard.getShardRouting().index();
            IndexStats.IndexStatsBuilder indexStatsBuilder = indexToIndexStatsBuilder.computeIfAbsent(index.getName(), k -> new IndexStats.IndexStatsBuilder((String)k, index.getUUID(), this.indexHealthMap.get(index.getName()), this.indexStateMap.get(index.getName())));
            indexStatsBuilder.add(shard);
        }
        this.indicesStats = indexToIndexStatsBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IndexStats.IndexStatsBuilder)entry.getValue()).build()));
        return this.indicesStats;
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.shards);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            out.writeMap(this.indexHealthMap, StreamOutput::writeString, (o, s) -> s.writeTo(o));
            out.writeMap(this.indexStateMap, StreamOutput::writeString, (o, s) -> s.writeTo(o));
        }
    }

    @Override
    protected Iterator<ToXContent> customXContentChunks(ToXContent.Params params) {
        boolean isLevelValid;
        String level = params.param("level", "indices");
        boolean bl = isLevelValid = "cluster".equalsIgnoreCase(level) || "indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [cluster] or [indices] or [shards] but was [" + level + "]");
        }
        if ("indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level)) {
            return Iterators.concat(Iterators.single((builder, p) -> {
                this.commonStats(builder, p);
                return builder.startObject("indices");
            }), this.getIndices().values().stream().map(indexStats -> (builder, p) -> {
                builder.startObject(indexStats.getIndex());
                builder.field("uuid", indexStats.getUuid());
                if (indexStats.getHealth() != null) {
                    builder.field("health", indexStats.getHealth().toString().toLowerCase(Locale.ROOT));
                }
                if (indexStats.getState() != null) {
                    builder.field("status", indexStats.getState().toString().toLowerCase(Locale.ROOT));
                }
                builder.startObject("primaries");
                indexStats.getPrimaries().toXContent(builder, p);
                builder.endObject();
                builder.startObject("total");
                indexStats.getTotal().toXContent(builder, p);
                builder.endObject();
                if ("shards".equalsIgnoreCase(level)) {
                    builder.startObject("shards");
                    for (IndexShardStats indexShardStats : indexStats) {
                        builder.startArray(Integer.toString(indexShardStats.getShardId().id()));
                        for (ShardStats shardStats : indexShardStats) {
                            builder.startObject();
                            shardStats.toXContent(builder, p);
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                return builder.endObject();
            }).iterator(), Iterators.single((b, p) -> b.endObject()));
        }
        return Iterators.single((b, p) -> {
            this.commonStats(b, p);
            return b;
        });
    }

    private void commonStats(XContentBuilder builder, ToXContent.Params p) throws IOException {
        builder.startObject("_all");
        builder.startObject("primaries");
        this.getPrimaries().toXContent(builder, p);
        builder.endObject();
        builder.startObject("total");
        this.getTotal().toXContent(builder, p);
        builder.endObject();
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

