/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.delete.DeleteComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteComponentTemplateAction
extends AcknowledgedTransportMasterNodeAction<DeleteComponentTemplateAction.Request> {
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportDeleteComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/component_template/delete", transportService, clusterService, threadPool, actionFilters, DeleteComponentTemplateAction.Request::new, indexNameExpressionResolver, "same");
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, DeleteComponentTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.indexTemplateService.removeComponentTemplate(request.names(), request.masterNodeTimeout(), state, listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("index_templates");
    }

    @Override
    public Set<String> modifiedKeys(DeleteComponentTemplateAction.Request request) {
        return Arrays.stream(request.names()).map(n -> ReservedComposableIndexTemplateAction.reservedComponentName(n)).collect(Collectors.toSet());
    }
}

