/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public final class ThreadedActionListener<Response>
extends ActionListener.Delegating<Response, Response> {
    private static final Logger logger = LogManager.getLogger(ThreadedActionListener.class);
    private final ExecutorService executor;
    private final boolean forceExecution;

    public ThreadedActionListener(ExecutorService executor, ActionListener<Response> listener) {
        this(executor, false, listener);
    }

    public ThreadedActionListener(ExecutorService executor, boolean forceExecution, ActionListener<Response> listener) {
        super(listener);
        this.forceExecution = forceExecution;
        this.executor = executor;
    }

    @Override
    public void onResponse(final Response response) {
        this.executor.execute(new ActionRunnable<Response>(this.delegate){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                this.listener.onResponse(response);
            }

            @Override
            public String toString() {
                return ThreadedActionListener.this + "/onResponse";
            }
        });
    }

    @Override
    public void onFailure(final Exception e) {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return ThreadedActionListener.this.forceExecution;
            }

            @Override
            protected void doRun() {
                ThreadedActionListener.this.delegate.onFailure(e);
            }

            @Override
            public void onRejection(Exception e2) {
                e.addSuppressed(e2);
                try {
                    ThreadedActionListener.this.delegate.onFailure(e);
                }
                catch (Exception e3) {
                    e.addSuppressed(e3);
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e2) {
                logger.error(() -> "failed to execute failure callback on [" + ThreadedActionListener.this + "]", (Throwable)e2);
                assert (false) : e2;
            }

            public String toString() {
                return ThreadedActionListener.this + "/onFailure";
            }
        });
    }

    @Override
    public String toString() {
        return "ThreadedActionListener[" + this.executor + "/" + this.delegate + "]";
    }
}

