/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal;

import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.xcontent.XContentType;

public class Requests {
    public static XContentType CONTENT_TYPE = XContentType.SMILE;
    public static XContentType INDEX_CONTENT_TYPE = XContentType.JSON;

    public static IndexRequest indexRequest() {
        return new IndexRequest();
    }

    public static IndexRequest indexRequest(String index) {
        return new IndexRequest(index);
    }

    public static DeleteRequest deleteRequest(String index) {
        return new DeleteRequest(index);
    }

    public static BulkRequest bulkRequest() {
        return new BulkRequest();
    }

    public static GetRequest getRequest(String index) {
        return new GetRequest(index);
    }

    public static SearchRequest searchRequest(String ... indices) {
        return new SearchRequest(indices);
    }

    public static SearchScrollRequest searchScrollRequest(String scrollId) {
        return new SearchScrollRequest(scrollId);
    }

    public static IndicesSegmentsRequest indicesSegmentsRequest(String ... indices) {
        return new IndicesSegmentsRequest(indices);
    }

    public static IndicesShardStoresRequest indicesShardStoresRequest(String ... indices) {
        return new IndicesShardStoresRequest(indices);
    }

    public static CreateIndexRequest createIndexRequest(String index) {
        return new CreateIndexRequest(index);
    }

    public static DeleteIndexRequest deleteIndexRequest(String index) {
        return new DeleteIndexRequest(index);
    }

    public static CloseIndexRequest closeIndexRequest(String index) {
        return new CloseIndexRequest(index);
    }

    public static OpenIndexRequest openIndexRequest(String index) {
        return new OpenIndexRequest(index);
    }

    public static PutMappingRequest putMappingRequest(String ... indices) {
        return new PutMappingRequest(indices);
    }

    public static IndicesAliasesRequest indexAliasesRequest() {
        return new IndicesAliasesRequest();
    }

    public static RefreshRequest refreshRequest(String ... indices) {
        return new RefreshRequest(indices);
    }

    public static FlushRequest flushRequest(String ... indices) {
        return new FlushRequest(indices);
    }

    public static ForceMergeRequest forceMergeRequest(String ... indices) {
        return new ForceMergeRequest(indices);
    }

    public static ClearIndicesCacheRequest clearIndicesCacheRequest(String ... indices) {
        return new ClearIndicesCacheRequest(indices);
    }

    public static UpdateSettingsRequest updateSettingsRequest(String ... indices) {
        return new UpdateSettingsRequest(indices);
    }

    public static ClusterStateRequest clusterStateRequest() {
        return new ClusterStateRequest();
    }

    public static ClusterRerouteRequest clusterRerouteRequest() {
        return new ClusterRerouteRequest();
    }

    public static ClusterUpdateSettingsRequest clusterUpdateSettingsRequest() {
        return new ClusterUpdateSettingsRequest();
    }

    public static ClusterHealthRequest clusterHealthRequest(String ... indices) {
        return new ClusterHealthRequest(indices);
    }

    public static ClusterSearchShardsRequest clusterSearchShardsRequest() {
        return new ClusterSearchShardsRequest();
    }

    public static ClusterSearchShardsRequest clusterSearchShardsRequest(String ... indices) {
        return new ClusterSearchShardsRequest(indices);
    }

    public static NodesInfoRequest nodesInfoRequest() {
        return new NodesInfoRequest(new String[0]);
    }

    public static NodesInfoRequest nodesInfoRequest(String ... nodesIds) {
        return new NodesInfoRequest(nodesIds);
    }

    public static NodesStatsRequest nodesStatsRequest(String ... nodesIds) {
        return new NodesStatsRequest(nodesIds);
    }

    public static NodesUsageRequest nodesUsageRequest(String ... nodesIds) {
        return new NodesUsageRequest(nodesIds);
    }

    public static ClusterStatsRequest clusterStatsRequest() {
        return new ClusterStatsRequest(new String[0]);
    }

    public static ListTasksRequest listTasksRequest() {
        return new ListTasksRequest();
    }

    public static GetTaskRequest getTaskRequest() {
        return new GetTaskRequest();
    }

    public static CancelTasksRequest cancelTasksRequest() {
        return new CancelTasksRequest();
    }

    public static PutRepositoryRequest putRepositoryRequest(String name) {
        return new PutRepositoryRequest(name);
    }

    public static GetRepositoriesRequest getRepositoryRequest(String ... repositories) {
        return new GetRepositoriesRequest(repositories);
    }

    public static DeleteRepositoryRequest deleteRepositoryRequest(String name) {
        return new DeleteRepositoryRequest(name);
    }

    public static CleanupRepositoryRequest cleanupRepositoryRequest(String name) {
        return new CleanupRepositoryRequest(name);
    }

    public static VerifyRepositoryRequest verifyRepositoryRequest(String name) {
        return new VerifyRepositoryRequest(name);
    }

    public static CreateSnapshotRequest createSnapshotRequest(String repository, String snapshot) {
        return new CreateSnapshotRequest(repository, snapshot);
    }

    public static GetSnapshotsRequest getSnapshotsRequest(String ... repositories) {
        return new GetSnapshotsRequest(repositories);
    }

    public static RestoreSnapshotRequest restoreSnapshotRequest(String repository, String snapshot) {
        return new RestoreSnapshotRequest(repository, snapshot);
    }

    public static DeleteSnapshotRequest deleteSnapshotRequest(String repository, String ... snapshots) {
        return new DeleteSnapshotRequest(repository, snapshots);
    }

    public static SnapshotsStatusRequest snapshotsStatusRequest(String repository) {
        return new SnapshotsStatusRequest(repository);
    }
}

