/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;

public final class DiffableUtils {
    private static final MapDiff<?, ?, ?> EMPTY = new MapDiff<Object, Object, Map<Object, Object>>(null, null, List.of(), List.of(), List.of(), null){

        @Override
        public Map<Object, Object> apply(Map<Object, Object> part) {
            return part;
        }
    };

    private DiffableUtils() {
    }

    public static KeySerializer<String> getStringKeySerializer() {
        return StringKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getIntKeySerializer() {
        return IntKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getVIntKeySerializer() {
        return VIntKeySerializer.INSTANCE;
    }

    public static <K, T extends Diffable<T>, M extends Map<K, T>> MapDiff<K, T, M> diff(M before, M after, KeySerializer<K> keySerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : DiffableUtils.createDiff(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> diff(M before, M after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : DiffableUtils.createDiff(before, after, keySerializer, valueSerializer);
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> emptyDiff() {
        return EMPTY;
    }

    public static <K, T> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, ImmutableOpenMap>(in, keySerializer, valueSerializer, ImmutableOpenMapBuilder::new));
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, Map>(in, keySerializer, valueSerializer, JdkMapBuilder::new));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, DiffableValueReader<K, T> diffableValueReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, ImmutableOpenMap>(in, keySerializer, diffableValueReader, ImmutableOpenMapBuilder::new));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, Map>(in, keySerializer, new DiffableValueReader(reader, diffReader), JdkMapBuilder::new));
    }

    private static <K, T, M extends Map<K, T>> MapDiff<K, T, M> diffOrEmpty(MapDiff<K, T, M> diff) {
        if (diff.getUpserts().isEmpty() && diff.getDiffs().isEmpty() && diff.getDeletes().isEmpty()) {
            return DiffableUtils.emptyDiff();
        }
        return diff;
    }

    private static <K, T, M extends Map<K, T>> MapDiff<K, T, M> createDiff(M before, M after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        int inserts = 0;
        ArrayList upserts = new ArrayList();
        ArrayList diffs = new ArrayList();
        for (Map.Entry<K, T> entry : after.entrySet()) {
            Object previousValue = before.get(entry.getKey());
            if (previousValue == null) {
                upserts.add(entry);
                ++inserts;
                continue;
            }
            if (entry.getValue().equals(previousValue)) continue;
            if (valueSerializer.supportsDiffableValues()) {
                diffs.add(new Maps.ImmutableEntry<K, Diff<Object>>(entry.getKey(), valueSerializer.diff(entry.getValue(), previousValue)));
                continue;
            }
            upserts.add(entry);
        }
        int expectedDeletes = before.size() + inserts - after.size();
        ArrayList deletes = new ArrayList(expectedDeletes);
        if (expectedDeletes > 0) {
            for (Object key : before.keySet()) {
                if (after.containsKey(key)) continue;
                deletes.add(key);
                if (--expectedDeletes != 0) continue;
                break;
            }
        }
        Function<Map, MapBuilder> builderCtor = before instanceof ImmutableOpenMap ? DiffableUtils::createImmutableMapBuilder : DiffableUtils::createJdkMapBuilder;
        return new MapDiff<K, T, Map>(keySerializer, valueSerializer, deletes, diffs, upserts, builderCtor);
    }

    private static <K, T, M extends Map<K, T>> MapBuilder<K, T, M> createImmutableMapBuilder(Map<K, T> m) {
        assert (m instanceof ImmutableOpenMap);
        return new ImmutableOpenMapBuilder((ImmutableOpenMap)m);
    }

    private static <K, T, M extends Map<K, T>> MapBuilder<K, T, M> createJdkMapBuilder(Map<K, T> m) {
        return new JdkMapBuilder<K, T>(m);
    }

    private static final class StringKeySerializer
    implements KeySerializer<String> {
        private static final StringKeySerializer INSTANCE = new StringKeySerializer();

        private StringKeySerializer() {
        }

        @Override
        public void writeKey(String key, StreamOutput out) throws IOException {
            out.writeString(key);
        }

        @Override
        public String readKey(StreamInput in) throws IOException {
            return in.readString();
        }
    }

    private static final class IntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private IntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            out.writeInt(key);
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readInt();
        }
    }

    private static final class VIntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private VIntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            if (key < 0) {
                throw new IllegalArgumentException("Map key [" + key + "] must be positive");
            }
            out.writeVInt(key);
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readVInt();
        }
    }

    public static class MapDiff<K, T, M extends Map<K, T>>
    implements Diff<M> {
        protected final List<K> deletes;
        protected final List<Map.Entry<K, Diff<T>>> diffs;
        protected final List<Map.Entry<K, T>> upserts;
        protected final KeySerializer<K> keySerializer;
        protected final ValueSerializer<K, T> valueSerializer;
        private final Function<M, MapBuilder<K, T, M>> builderCtor;

        private MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, List<K> deletes, List<Map.Entry<K, Diff<T>>> diffs, List<Map.Entry<K, T>> upserts, Function<M, MapBuilder<K, T, M>> builderCtor) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = deletes;
            this.diffs = diffs;
            this.upserts = upserts;
            this.builderCtor = builderCtor;
        }

        private MapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, Function<M, MapBuilder<K, T, M>> builderCtor) throws IOException {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = in.readList(keySerializer::readKey);
            int diffsCount = in.readVInt();
            this.diffs = diffsCount == 0 ? List.of() : new ArrayList(diffsCount);
            for (int i = 0; i < diffsCount; ++i) {
                K key = keySerializer.readKey(in);
                Diff<T> diff = valueSerializer.readDiff(in, key);
                this.diffs.add(new Maps.ImmutableEntry<K, Diff<T>>(key, diff));
            }
            int upsertsCount = in.readVInt();
            this.upserts = upsertsCount == 0 ? List.of() : new ArrayList(upsertsCount);
            for (int i = 0; i < upsertsCount; ++i) {
                K key = keySerializer.readKey(in);
                T newValue = valueSerializer.read(in, key);
                this.upserts.add(new Maps.ImmutableEntry<K, T>(key, newValue));
            }
            this.builderCtor = builderCtor;
        }

        @Override
        public M apply(M map) {
            MapBuilder builder = this.builderCtor.apply(map);
            for (K k : this.deletes) {
                builder.remove(k);
            }
            for (Map.Entry entry : this.diffs) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            for (Map.Entry entry : this.upserts) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }

        public List<K> getDeletes() {
            return this.deletes;
        }

        public List<Map.Entry<K, Diff<T>>> getDiffs() {
            return this.diffs;
        }

        public List<Map.Entry<K, T>> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.deletes, (o, v) -> this.keySerializer.writeKey(v, o));
            TransportVersion version = out.getTransportVersion();
            int diffCount = 0;
            for (Map.Entry<K, Diff<T>> diff : this.diffs) {
                if (!this.valueSerializer.supportsVersion((T)diff.getValue(), version)) continue;
                ++diffCount;
            }
            out.writeVInt(diffCount);
            for (Map.Entry<K, Diff<T>> entry : this.diffs) {
                if (!this.valueSerializer.supportsVersion((T)entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.writeDiff(entry.getValue(), out);
            }
            int upsertsCount = 0;
            for (Map.Entry<K, T> upsert : this.upserts) {
                if (!this.valueSerializer.supportsVersion(upsert.getValue(), version)) continue;
                ++upsertsCount;
            }
            out.writeVInt(upsertsCount);
            for (Map.Entry<K, T> entry : this.upserts) {
                if (!this.valueSerializer.supportsVersion(entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.write(entry.getValue(), out);
            }
        }
    }

    public static abstract class DiffableValueSerializer<K, V extends Diffable<V>>
    implements ValueSerializer<K, V> {
        private static final DiffableValueSerializer WRITE_ONLY_INSTANCE = new DiffableValueSerializer(){

            @Override
            public Object read(StreamInput in, Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Diff<Object> readDiff(StreamInput in, Object key) {
                throw new UnsupportedOperationException();
            }
        };

        private static <K, V extends Diffable<V>> DiffableValueSerializer<K, V> getWriteOnlyInstance() {
            return WRITE_ONLY_INSTANCE;
        }

        @Override
        public boolean supportsDiffableValues() {
            return true;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            return value.diff(beforePart);
        }

        @Override
        public void write(V value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }
    }

    public static interface KeySerializer<K> {
        public void writeKey(K var1, StreamOutput var2) throws IOException;

        public K readKey(StreamInput var1) throws IOException;
    }

    public static interface ValueSerializer<K, V> {
        public void write(V var1, StreamOutput var2) throws IOException;

        public V read(StreamInput var1, K var2) throws IOException;

        public boolean supportsDiffableValues();

        default public boolean supportsVersion(Diff<V> value, TransportVersion version) {
            return true;
        }

        default public boolean supportsVersion(V value, TransportVersion version) {
            return true;
        }

        public Diff<V> diff(V var1, V var2);

        public void writeDiff(Diff<V> var1, StreamOutput var2) throws IOException;

        public Diff<V> readDiff(StreamInput var1, K var2) throws IOException;
    }

    public static class DiffableValueReader<K, V extends Diffable<V>>
    extends DiffableValueSerializer<K, V> {
        private final Writeable.Reader<V> reader;
        private final Writeable.Reader<Diff<V>> diffReader;

        public DiffableValueReader(Writeable.Reader<V> reader, Writeable.Reader<Diff<V>> diffReader) {
            this.reader = reader;
            this.diffReader = diffReader;
        }

        @Override
        public V read(StreamInput in, K key) throws IOException {
            return (V)((Diffable)this.reader.read(in));
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            return this.diffReader.read(in);
        }
    }

    private static class ImmutableOpenMapBuilder<K, T>
    implements MapBuilder<K, T, ImmutableOpenMap<K, T>> {
        private final ImmutableOpenMap.Builder<K, T> builder;

        ImmutableOpenMapBuilder(ImmutableOpenMap<K, T> map) {
            this.builder = ImmutableOpenMap.builder(map);
        }

        @Override
        public void remove(K key) {
            this.builder.remove(key);
        }

        @Override
        public T get(K key) {
            return this.builder.get(key);
        }

        @Override
        public void put(K key, T value) {
            this.builder.put(key, value);
        }

        @Override
        public ImmutableOpenMap<K, T> build() {
            return this.builder.build();
        }
    }

    private static class JdkMapBuilder<K, T>
    implements MapBuilder<K, T, Map<K, T>> {
        private final Map<K, T> map;

        JdkMapBuilder(Map<K, T> map) {
            this.map = new HashMap<K, T>(map);
        }

        @Override
        public void remove(K key) {
            this.map.remove(key);
        }

        @Override
        public T get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, T value) {
            this.map.put(key, value);
        }

        @Override
        public Map<K, T> build() {
            return Collections.unmodifiableMap(this.map);
        }
    }

    public static class StringSetValueSerializer<K>
    extends NonDiffableValueSerializer<K, Set<String>> {
        private static final StringSetValueSerializer INSTANCE = new StringSetValueSerializer();

        public static <K> StringSetValueSerializer<K> getInstance() {
            return INSTANCE;
        }

        @Override
        public void write(Set<String> value, StreamOutput out) throws IOException {
            out.writeStringCollection(value);
        }

        @Override
        public Set<String> read(StreamInput in, K key) throws IOException {
            return Set.of(in.readStringArray());
        }
    }

    public static abstract class NonDiffableValueSerializer<K, V>
    implements ValueSerializer<K, V> {
        @Override
        public boolean supportsDiffableValues() {
            return false;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) {
            throw new UnsupportedOperationException();
        }
    }

    private static interface MapBuilder<K, T, M extends Map<K, T>> {
        public void remove(K var1);

        public T get(K var1);

        public void put(K var1, T var2);

        public M build();
    }
}

