/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.JoinReason;
import org.elasticsearch.cluster.coordination.JoinTask;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;

public class NodeJoinExecutor
implements ClusterStateTaskExecutor<JoinTask> {
    private static final Logger logger = LogManager.getLogger(NodeJoinExecutor.class);
    private final AllocationService allocationService;
    private final RerouteService rerouteService;

    public NodeJoinExecutor(AllocationService allocationService, RerouteService rerouteService) {
        this.allocationService = allocationService;
        this.rerouteService = rerouteService;
    }

    @Override
    public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<JoinTask> batchExecutionContext) throws Exception {
        ClusterState.Builder newState;
        assert (!batchExecutionContext.taskContexts().isEmpty()) : "Expected to have non empty join tasks list";
        long term = batchExecutionContext.taskContexts().stream().mapToLong(t -> ((JoinTask)t.getTask()).term()).max().getAsLong();
        Map<Boolean, List<ClusterStateTaskExecutor.TaskContext>> split = batchExecutionContext.taskContexts().stream().collect(Collectors.partitioningBy(t -> ((JoinTask)t.getTask()).term() == term));
        for (ClusterStateTaskExecutor.TaskContext outdated : split.get(false)) {
            outdated.onFailure(new NotMasterException("Higher term encountered (encountered: " + term + " > used: " + ((JoinTask)outdated.getTask()).term() + ")"));
        }
        List<ClusterStateTaskExecutor.TaskContext<JoinTask>> joinTaskContexts = split.get(true);
        ClusterState initialState = batchExecutionContext.initialState();
        if (initialState.term() > term) {
            logger.trace("encountered higher term {} than current {}, there is a newer master", (Object)initialState.term(), (Object)term);
            throw new NotMasterException("Higher term encountered (current: " + initialState.term() + " > used: " + term + "), there is a newer master");
        }
        boolean isBecomingMaster = joinTaskContexts.stream().anyMatch(t -> ((JoinTask)t.getTask()).isBecomingMaster());
        DiscoveryNodes currentNodes = initialState.nodes();
        boolean nodesChanged = false;
        if (currentNodes.getMasterNode() == null && isBecomingMaster) {
            assert (initialState.term() < term) : "there should be at most one become master task per election (= by term)";
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                newState = this.becomeMasterAndTrimConflictingNodes(initialState, joinTaskContexts, term);
            }
            nodesChanged = true;
        } else if (currentNodes.isLocalNodeElectedMaster()) {
            assert (initialState.term() == term) : "term should be stable for the same master";
            newState = ClusterState.builder(initialState);
        } else {
            logger.trace("processing node joins, but we are not the master. current master: {}", (Object)currentNodes.getMasterNode());
            throw new NotMasterException("Node [" + currentNodes.getLocalNode() + "] not master for join request");
        }
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder(newState.nodes());
        assert (nodesBuilder.isLocalNodeElectedMaster());
        Version minClusterNodeVersion = newState.nodes().getMinNodeVersion();
        Version maxClusterNodeVersion = newState.nodes().getMaxNodeVersion();
        boolean enforceVersionBarrier = !initialState.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
        HashMap<String, String> joinedNodeIdsByNodeName = new HashMap<String, String>();
        for (ClusterStateTaskExecutor.TaskContext<JoinTask> joinTaskContext : joinTaskContexts) {
            JoinTask joinTask = joinTaskContext.getTask();
            ArrayList<Runnable> onTaskSuccess = new ArrayList<Runnable>(joinTask.nodeCount());
            for (JoinTask.NodeJoinTask nodeJoinTask : joinTask.nodeJoinTasks()) {
                block27: {
                    DiscoveryNode node = nodeJoinTask.node();
                    if (currentNodes.nodeExistsWithSameRoles(node)) {
                        logger.debug("received a join request for an existing node [{}]", (Object)node);
                    } else {
                        try {
                            if (enforceVersionBarrier) {
                                NodeJoinExecutor.ensureVersionBarrier(node.getVersion(), minClusterNodeVersion);
                            }
                            NodeJoinExecutor.ensureNodesCompatibility(node.getVersion(), minClusterNodeVersion, maxClusterNodeVersion);
                            NodeJoinExecutor.ensureIndexCompatibility(node.getVersion(), initialState.getMetadata());
                            nodesBuilder.add(node);
                            nodesChanged = true;
                            minClusterNodeVersion = Version.min(minClusterNodeVersion, node.getVersion());
                            maxClusterNodeVersion = Version.max(maxClusterNodeVersion, node.getVersion());
                            if (!node.isMasterNode()) break block27;
                            joinedNodeIdsByNodeName.put(node.getName(), node.getId());
                        }
                        catch (IllegalArgumentException | IllegalStateException e2) {
                            onTaskSuccess.add(() -> nodeJoinTask.listener().onFailure(e2));
                            continue;
                        }
                    }
                }
                onTaskSuccess.add(() -> {
                    JoinReason reason = nodeJoinTask.reason();
                    if (reason.guidanceDocs() == null) {
                        logger.info("node-join: [{}] with reason [{}]", (Object)nodeJoinTask.node().descriptionWithoutAttributes(), (Object)reason.message());
                    } else {
                        logger.warn("node-join: [{}] with reason [{}]; for troubleshooting guidance, see {}", (Object)nodeJoinTask.node().descriptionWithoutAttributes(), (Object)reason.message(), (Object)reason.guidanceDocs());
                    }
                    nodeJoinTask.listener().onResponse(null);
                });
            }
            joinTaskContext.success(() -> {
                for (Runnable joinCompleter : onTaskSuccess) {
                    joinCompleter.run();
                }
            });
        }
        if (nodesChanged) {
            Set<CoordinationMetadata.VotingConfigExclusion> currentVotingConfigExclusions;
            Set<CoordinationMetadata.VotingConfigExclusion> newVotingConfigExclusions;
            this.rerouteService.reroute("post-join reroute", Priority.HIGH, ActionListener.wrap(r -> logger.trace("post-join reroute completed"), e -> logger.debug("post-join reroute failed", (Throwable)e)));
            if (!joinedNodeIdsByNodeName.isEmpty() && !(newVotingConfigExclusions = (currentVotingConfigExclusions = initialState.getVotingConfigExclusions()).stream().map(e -> {
                if ("_absent_".equals(e.getNodeId()) && joinedNodeIdsByNodeName.containsKey(e.getNodeName())) {
                    return new CoordinationMetadata.VotingConfigExclusion((String)joinedNodeIdsByNodeName.get(e.getNodeName()), e.getNodeName());
                }
                return e;
            }).collect(Collectors.toSet())).equals(currentVotingConfigExclusions)) {
                CoordinationMetadata.Builder coordMetadataBuilder = CoordinationMetadata.builder(initialState.coordinationMetadata()).term(term).clearVotingConfigExclusions();
                newVotingConfigExclusions.forEach(coordMetadataBuilder::addVotingConfigExclusion);
                newState.metadata(Metadata.builder(initialState.metadata()).coordinationMetadata(coordMetadataBuilder.build()).build());
            }
            ClusterState clusterStateWithNewNodesAndDesiredNodes = DesiredNodes.updateDesiredNodesStatusIfNeeded(newState.nodes(nodesBuilder).build());
            ClusterState updatedState = this.allocationService.adaptAutoExpandReplicas(clusterStateWithNewNodesAndDesiredNodes);
            assert (!enforceVersionBarrier || updatedState.nodes().getMinNodeVersion().onOrAfter(initialState.nodes().getMinNodeVersion())) : "min node version decreased from [" + initialState.nodes().getMinNodeVersion() + "] to [" + updatedState.nodes().getMinNodeVersion() + "]";
            return updatedState;
        }
        return newState.build();
    }

    protected ClusterState.Builder becomeMasterAndTrimConflictingNodes(ClusterState currentState, List<ClusterStateTaskExecutor.TaskContext<JoinTask>> taskContexts, long term) {
        assert (currentState.nodes().getMasterNodeId() == null) : currentState;
        assert (currentState.term() < term) : term + " vs " + currentState;
        DiscoveryNodes currentNodes = currentState.nodes();
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder(currentNodes);
        nodesBuilder.masterNodeId(currentState.nodes().getLocalNodeId());
        for (ClusterStateTaskExecutor.TaskContext<JoinTask> taskContext : taskContexts) {
            for (DiscoveryNode joiningNode : taskContext.getTask().nodes()) {
                DiscoveryNode nodeWithSameAddress;
                DiscoveryNode nodeWithSameId = nodesBuilder.get(joiningNode.getId());
                if (nodeWithSameId != null && !nodeWithSameId.equals(joiningNode)) {
                    logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameId, (Object)joiningNode);
                    nodesBuilder.remove(nodeWithSameId.getId());
                }
                if ((nodeWithSameAddress = currentNodes.findByAddress(joiningNode.getAddress())) == null || nodeWithSameAddress.equals(joiningNode)) continue;
                logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameAddress, (Object)joiningNode);
                nodesBuilder.remove(nodeWithSameAddress.getId());
            }
        }
        ClusterState tmpState = ClusterState.builder(currentState).nodes(nodesBuilder).blocks(ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(2)).metadata(Metadata.builder(currentState.metadata()).coordinationMetadata(CoordinationMetadata.builder(currentState.coordinationMetadata()).term(term).build()).build()).build();
        logger.trace("becomeMasterAndTrimConflictingNodes: {}", (Object)tmpState.nodes());
        this.allocationService.cleanCaches();
        tmpState = PersistentTasksCustomMetadata.disassociateDeadNodes(tmpState);
        return ClusterState.builder(this.allocationService.disassociateDeadNodes(tmpState, false, "removed dead nodes on election"));
    }

    @Override
    public boolean runOnlyOnMaster() {
        return false;
    }

    public static void ensureIndexCompatibility(Version nodeVersion, Metadata metadata) {
        Version supportedIndexVersion = nodeVersion.minimumIndexCompatibilityVersion();
        for (IndexMetadata idxMetadata : metadata) {
            if (idxMetadata.getCompatibilityVersion().after(nodeVersion)) {
                throw new IllegalStateException("index " + idxMetadata.getIndex() + " version not supported: " + idxMetadata.getCompatibilityVersion() + " the node version is: " + nodeVersion);
            }
            if (!idxMetadata.getCompatibilityVersion().before(supportedIndexVersion)) continue;
            throw new IllegalStateException("index " + idxMetadata.getIndex() + " version not supported: " + idxMetadata.getCompatibilityVersion() + " minimum compatible index version is: " + supportedIndexVersion);
        }
    }

    public static void ensureNodesCompatibility(Version joiningNodeVersion, DiscoveryNodes currentNodes) {
        Version minNodeVersion = currentNodes.getMinNodeVersion();
        Version maxNodeVersion = currentNodes.getMaxNodeVersion();
        NodeJoinExecutor.ensureNodesCompatibility(joiningNodeVersion, minNodeVersion, maxNodeVersion);
    }

    public static void ensureNodesCompatibility(Version joiningNodeVersion, Version minClusterNodeVersion, Version maxClusterNodeVersion) {
        assert (minClusterNodeVersion.onOrBefore(maxClusterNodeVersion)) : minClusterNodeVersion + " > " + maxClusterNodeVersion;
        if (!joiningNodeVersion.isCompatible(maxClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported. The cluster contains nodes with version [" + maxClusterNodeVersion + "], which is incompatible.");
        }
        if (!joiningNodeVersion.isCompatible(minClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported.The cluster contains nodes with version [" + minClusterNodeVersion + "], which is incompatible.");
        }
    }

    public static void ensureVersionBarrier(Version joiningNodeVersion, Version minClusterNodeVersion) {
        if (joiningNodeVersion.before(minClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] may not join a cluster comprising only nodes of version [" + minClusterNodeVersion + "] or greater");
        }
    }

    public static Collection<BiConsumer<DiscoveryNode, ClusterState>> addBuiltInJoinValidators(Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> validators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        validators.add((node, state) -> {
            NodeJoinExecutor.ensureNodesCompatibility(node.getVersion(), state.getNodes());
            NodeJoinExecutor.ensureIndexCompatibility(node.getVersion(), state.getMetadata());
        });
        validators.addAll(onJoinValidators);
        return Collections.unmodifiableCollection(validators);
    }
}

